/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker.ui;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.binding.Binding;
import com.iosoft.helpers.binding.Disposables;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.Language;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.ui.awt.ErrorScreen;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.watermarker.Compatibility;
import com.iosoft.watermarker.DataModel;
import com.iosoft.watermarker.ErrorEntry;
import com.iosoft.watermarker.ExportFormat;
import com.iosoft.watermarker.Format;
import com.iosoft.watermarker.Template;
import com.iosoft.watermarker.ui.ImagePreview;
import com.iosoft.watermarker.ui.TemplateEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UI {
    public final DataModel DataModel;
    public final Localizer Localizer;
    private final JFrame window;
    private final Disposables disposables = new Disposables();
    private final TemplateEditor templateEditor;
    private final JFileChooser fileChooser;
    private final ImagePreview imagePreview;
    private boolean closing = false;
    private final List<DefaultTemplateMenuButton> defaultTemplateMenuButtons = new ArrayList<DefaultTemplateMenuButton>();
    private JMenu defaultTemplateMenu;

    public UI(DataModel dataModel, Localizer localizer) {
        this.DataModel = dataModel;
        this.Localizer = localizer;
        this.imagePreview = new ImagePreview();
        this.disposables.addDisposable(this.imagePreview);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", evt -> {
            if (this.fileChooser.getAccessory() == this.imagePreview) {
                File selectedFile = this.fileChooser.getSelectedFile();
                if (selectedFile != null) {
                    selectedFile = MiscIO.sanitizeFileName(selectedFile);
                }
                this.imagePreview.loadImage(selectedFile);
            }
        });
        this.window = new JFrame();
        Binding.bind(dataModel.Dirty, dataModel.DoingIO, (dirty, doingIO) -> this.window.setTitle("Watermarker 1.4 by AyCe" + (dirty ? " *" : "") + (doingIO ? " (...)" : "")));
        this.window.setIconImage(new BufferedImage(1, 1, 2));
        dataModel.Icon.await((Image)((Object)((Consumer<Image>)this.window::setIconImage)));
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UI.this.onExit();
            }
        });
        this.window.setMinimumSize(new Dimension(800, 700));
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.window.add(mainPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        mainPanel.add((Component)tabbedPane, "Center");
        this.templateEditor = new TemplateEditor(this);
        this.disposables.addDisposable(this.templateEditor);
        tabbedPane.addTab("", this.templateEditor);
        localizer.bind("#Tab_Templates", x -> tabbedPane.setTitleAt(0, (String)x));
        JList<ErrorEntry> listErrors = new JList<ErrorEntry>(dataModel.getErrorList());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel labelDate = new JLabel();
        panel.add((Component)labelDate, "Before");
        labelDate.setMinimumSize(new Dimension(200, 20));
        labelDate.setPreferredSize(new Dimension(200, 20));
        JLabel labelException = new JLabel();
        panel.add((Component)labelException, "Center");
        listErrors.setCellRenderer((list, value, index, isSelected, hasFocus) -> {
            labelDate.setText(value.Date.toString());
            labelException.setText(value.Exception.toString());
            return panel;
        });
        JScrollPane scrollPane = new JScrollPane(listErrors);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(22);
        tabbedPane.addTab("", scrollPane);
        localizer.bind("#Tab_Errors", x -> tabbedPane.setTitleAt(1, (String)x));
        this.window.setJMenuBar(this.createMenuBar());
        this.window.setSize(1000, 700);
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        Dispatcher.getForCurrentThread().setMainUnhandledExceptionHandler(x -> {
            this.window.setJMenuBar(null);
            ErrorScreen.showAndDump(this.window.getContentPane(), x, this.window.getTitle());
        });
        this.disposables.addDisposable(MiscAWT.createEDTKeepalive());
        dataModel.DefaultTemplate.bind(x -> this.rebuildDefaultTemplateMenu());
        MiscAWT.bind(dataModel.Templates, this::rebuildDefaultTemplateMenu);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = this.createMenu(menuBar, "File", 'F');
        this.createMenuItem(menu, "File_Open", 'O', () -> {
            File file = this.openFileChooser("OpenImage");
            if (file != null) {
                this.DataModel.openImage(file);
            }
        });
        JMenuItem itemExport = this.createMenuItem(menu, "File_Export", 'E', () -> {
            Task<Boolean> task = this.DataModel.export(this.templateEditor.CurrentTemplate.get(), null, new ExportFormat(this.DataModel.CurrentImage.get().getTransparency() == 3 ? Format.Png : Format.Jpg));
        });
        JMenuItem itemExportTo = this.createMenuItem(menu, "File_ExportTo", 'R', () -> {
            ExportFormat format;
            MutableBool hadQuotes;
            File file;
            block13: {
                Format realFormat;
                block12: {
                    this.setImagePreview(false);
                    this.prepareFileChooser("ExportImage", false, false, this.DataModel.CurrentImage.get().getTransparency() == 3);
                    this.fileChooser.setSelectedFile(this.DataModel.getCurrentImageFile());
                    File file2 = file = this.fileChooser.showSaveDialog(this.window) == 0 ? this.fileChooser.getSelectedFile() : null;
                    if (file == null) {
                        return;
                    }
                    hadQuotes = new MutableBool(false);
                    file = MiscIO.sanitizeFileName(file, hadQuotes);
                    FileFilter fileFilter = this.fileChooser.getFileFilter();
                    if (!(fileFilter instanceof FileNameExtensionFilter)) break block12;
                    format = ExportFormat.createFromExtension(((FileNameExtensionFilter)fileFilter).getExtensions()[0]);
                    break block13;
                }
                switch (MiscIO.getExtension(file)) {
                    case "jpg": {
                        realFormat = Format.Jpg;
                        break;
                    }
                    case "bmp": {
                        realFormat = Format.Bmp;
                        break;
                    }
                    default: {
                        realFormat = Format.Png;
                    }
                }
                format = new ExportFormat(realFormat);
            }
            String extension = MiscIO.getExtension(file);
            String formatExtension = format.getExtension();
            if (!hadQuotes.Value && !extension.equals(Misc.toUpper(formatExtension))) {
                file = new File(file.getParentFile(), String.valueOf(extension.trim().length() == extension.length() && extension.length() <= 4 ? MiscIO.getWithoutExtension(file) : file.getName()) + "." + formatExtension);
            }
            this.DataModel.export(this.templateEditor.CurrentTemplate.get(), file, format);
        });
        Binding.bind(this.DataModel.CurrentImage, this.templateEditor.CurrentTemplate, (currentImage, currentTemplate) -> {
            boolean enabled = currentImage != null && currentTemplate != null;
            itemExport.setEnabled(enabled);
            itemExportTo.setEnabled(enabled);
        });
        JMenuItem itemClose = this.createMenuItem(menu, "File_Close", 'C', () -> this.DataModel.openImage(null));
        this.DataModel.CurrentImage.bind(x -> itemClose.setEnabled(x != null));
        menu.addSeparator();
        JMenuItem itemSave = this.createMenuItem(menu, "File_Save", 'S', this::saveSettings);
        this.DataModel.DoingIO.bind(x -> itemSave.setEnabled(!x));
        menu.addSeparator();
        this.createMenuItem(menu, "File_Exit", this::onExit);
        menu = this.createMenu(menuBar, "Edit", 'E');
        this.createMenuItem(menu, "Edit_PasteLayer", 'V', this.templateEditor::onPaste);
        this.createMenuItem(menu, "Edit_OpenLayer", () -> {
            File[] files = this.openFilesChooser("OpenLayers");
            if (files != null) {
                this.templateEditor.addFilesAsync(Arrays.asList(files));
            }
        });
        menu = this.createMenu(menuBar, "Language", 'L');
        for (Language language : this.Localizer) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(language.getUiName());
            this.DataModel.Icon.await((Image)((Object)((Consumer<Image>)x -> {
                Icon icon = language.getProperty("flagIcon", null);
                menuItem.setIcon(icon);
                menuItem.setDisabledIcon(icon);
            })));
            menu.add(menuItem);
            this.Localizer.DefaultLanguage.bind(x -> {
                menuItem.setEnabled(x != language);
                menuItem.setSelected(x == language);
            });
            menuItem.addActionListener(evt -> {
                this.Localizer.setDefaultLanguage(language);
                this.DataModel.setLanguage(language);
            });
        }
        this.defaultTemplateMenu = this.createMenu(menuBar, "DefaultTemplate", 'a');
        this.rebuildDefaultTemplateMenu();
        return menuBar;
    }

    private void onExit() {
        if (this.DataModel.Dirty.get()) {
            int result = JOptionPane.showConfirmDialog(this.window, this.Localizer.translate("#Dlg_SaveOnExit"), this.Localizer.translate("#Dlg_SaveOnExit_Title"), 1, 3);
            switch (result) {
                case -1: 
                case 2: {
                    return;
                }
                case 0: {
                    this.saveSettings();
                }
            }
        }
        this.window.dispose();
        if (!this.closing) {
            this.closing = true;
            this.DataModel.shutDownAsync().await(this.disposables::dispose);
        }
    }

    private void saveSettings() {
        VTask task = this.DataModel.saveSettingsAsync();
        if (task == null) {
            JOptionPane.showMessageDialog(this.window, "cannot save", "error", 0);
        } else {
            Cursor oldCursor = this.window.getCursor();
            this.window.setCursor(Cursor.getPredefinedCursor(3));
            task.await(() -> this.window.setCursor(oldCursor));
        }
    }

    private void rebuildDefaultTemplateMenu() {
        Template defaultTemplate = this.DataModel.DefaultTemplate.get();
        Iterator<DefaultTemplateMenuButton> iterDefaultTemplateMenuButtons = this.defaultTemplateMenuButtons.iterator();
        boolean anyAdded = false;
        for (Template template : MiscLINQ.toIterable(this.DataModel.Templates.elements())) {
            DefaultTemplateMenuButton button;
            if (iterDefaultTemplateMenuButtons.hasNext()) {
                button = iterDefaultTemplateMenuButtons.next();
            } else {
                anyAdded = true;
                button = new DefaultTemplateMenuButton();
                button.Template = template;
                this.defaultTemplateMenu.add(button.MenuItem);
                this.defaultTemplateMenuButtons.add(button);
            }
            button.MenuItem.setSelected(button.Template == defaultTemplate);
            button.MenuItem.setText(button.Template.Name.get());
        }
        while (!anyAdded && iterDefaultTemplateMenuButtons.hasNext()) {
            DefaultTemplateMenuButton button = iterDefaultTemplateMenuButtons.next();
            iterDefaultTemplateMenuButtons.remove();
            this.defaultTemplateMenu.remove(button.MenuItem);
        }
    }

    private JMenu createMenu(JMenuBar menuBar, String name, char mnemonic) {
        JMenu menu = menuBar.add(new JMenu(name));
        menu.setMnemonic(mnemonic);
        this.Localizer.bind("#Menu_" + name, menu::setText);
        return menu;
    }

    private JMenuItem createMenuItem(JMenu menu, String name, Runnable onClick) {
        JMenuItem menuItem = menu.add(new JMenuItem(name));
        menuItem.addActionListener(evt -> onClick.run());
        this.Localizer.bind("#Menu_" + name, menuItem::setText);
        return menuItem;
    }

    private JMenuItem createMenuItem(JMenu menu, String name, char mnemonic, Runnable onClick) {
        JMenuItem menuItem = this.createMenuItem(menu, name, onClick);
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)mnemonic, Compatibility.getMenuShortcutKeyMaskEx(this.window.getToolkit())));
        return menuItem;
    }

    private void setImagePreview(boolean on) {
        this.fileChooser.setAccessory(on ? this.imagePreview : null);
    }

    private void prepareFileChooser(String title, boolean multi) {
        this.setImagePreview(true);
        this.prepareFileChooser(title, multi, true, true);
    }

    private void prepareFileChooser(String title, boolean multi, boolean anyImageFormat, boolean transparency) {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setMultiSelectionEnabled(multi);
        this.fileChooser.setDialogTitle(this.Localizer.translate("#FC_" + title));
        String[] formats = ImageIO.getReaderFormatNames();
        if (anyImageFormat) {
            this.fileChooser.setFileFilter(new FileNameExtensionFilter(this.Localizer.translate("#FC_Images", Arrays.stream(formats).map(x -> "*." + Misc.toLower(x)).distinct().sorted(String::compareTo).collect(Collectors.joining(", "))), formats));
        } else {
            FileNameExtensionFilter jpgFilter = new FileNameExtensionFilter("JPG", "jpg");
            this.fileChooser.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
            this.fileChooser.addChoosableFileFilter(jpgFilter);
            this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("BMP", "bmp"));
            if (!transparency) {
                this.fileChooser.setFileFilter(jpgFilter);
            }
        }
    }

    private File openFileChooser(String title) {
        this.prepareFileChooser(title, false);
        return this.fileChooser.showOpenDialog(this.window) == 0 ? MiscIO.sanitizeFileName(this.fileChooser.getSelectedFile()) : null;
    }

    private File[] openFilesChooser(String title) {
        this.prepareFileChooser(title, true);
        return this.fileChooser.showOpenDialog(this.window) == 0 ? (File[])Stream.of(this.fileChooser.getSelectedFiles()).map(MiscIO::sanitizeFileName).toArray(File[]::new) : null;
    }

    private class DefaultTemplateMenuButton {
        public final JCheckBoxMenuItem MenuItem = new JCheckBoxMenuItem();
        public Template Template;

        DefaultTemplateMenuButton() {
            this.MenuItem.addActionListener(evt -> UI.this.DataModel.setDefaultTemplate(UI.this.DataModel.DefaultTemplate.get() == this.Template ? null : this.Template));
        }
    }
}

