/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker.ui;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.async.Ticker;
import com.iosoft.helpers.math.Vector2D;
import com.iosoft.watermarker.Layer;
import com.iosoft.watermarker.Template;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TemplatePreview
extends JPanel
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private Template currentTemplate;
    private Layer currentLayer;
    private BufferedImage backgroundImage;
    private boolean disposed = false;
    private final Vector2D size = new Vector2D();
    private final Ticker ticker = new Ticker("Preview Animator", 12.0, this::repaint);

    public TemplatePreview() {
        this.setBackground(Color.LIGHT_GRAY);
    }

    public void setBackgroundImage(BufferedImage newImage) {
        this.backgroundImage = newImage;
        this.repaint();
    }

    public void setTemplate(Template template) {
        this.currentTemplate = template;
        this.repaint();
    }

    public void setLayer(Layer layer) {
        this.currentLayer = layer;
        if (layer == null) {
            this.ticker.stop();
        } else if (!this.disposed) {
            this.ticker.start();
        }
        this.repaint();
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.ticker.stop();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        g.setColor(this.getBackground());
        int width = this.getWidth();
        int height = this.getHeight();
        g.fillRect(0, 0, width, height);
        if (this.backgroundImage != null) {
            double imgHeight = this.backgroundImage.getHeight();
            double ratioWidthPerHeight = imgHeight == 0.0 ? 0.0 : (double)this.backgroundImage.getWidth() / imgHeight;
            double widthForMaxHeight = (double)height * ratioWidthPerHeight;
            if (widthForMaxHeight < (double)width) {
                this.size.put(widthForMaxHeight, height);
            } else {
                this.size.put(width, ratioWidthPerHeight == 0.0 ? 0.0 : (double)width / ratioWidthPerHeight);
            }
            g.translate(((double)width - this.size.X) * 0.5, ((double)height - this.size.Y) * 0.5);
            g.drawImage(this.backgroundImage, 0, 0, (int)this.size.X, (int)this.size.Y, null);
            g.setColor(Color.DARK_GRAY);
            g.drawRect(0, 0, (int)this.size.X - 1, (int)this.size.Y - 1);
        } else {
            this.size.put(width, height);
        }
        if (this.currentTemplate != null) {
            this.currentTemplate.drawWatermarks(g, this.size, false);
        }
        if (this.currentLayer != null) {
            this.currentLayer.renderControls(g, this.size);
        }
    }
}

