/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker.ui;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.UnexpandingPanel;
import com.iosoft.watermarker.Layer;
import com.iosoft.watermarker.Template;
import com.iosoft.watermarker.ui.EditableList;
import com.iosoft.watermarker.ui.TemplatePreview;
import com.iosoft.watermarker.ui.UI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TemplateEditor
extends JPanel
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private static final int SLIDER_RESOLUTION = 1000;
    private static final Color COLOR_VALID_INPUT = Color.DARK_GRAY;
    private static final Color COLOR_INVALID_INPUT = Color.RED.darker().darker();
    private static final float DEFAULT_QUALITY = 0.75f;
    private final UI Ui;
    private final EditableList<Template> listTemplates;
    private final EditableList<Layer> listLayers;
    private final TemplatePreview preview;
    private final LayerListModel listModelLayers;
    public final Observable<Template> CurrentTemplate;
    private Layer currentLayer;
    private static final Insets SEPARATOR_INSETS = new Insets(5, 0, 5, 0);
    private static final DecimalFormat FormatDoubles = new DecimalFormat("#.####");

    static {
        FormatDoubles.setRoundingMode(RoundingMode.CEILING);
    }

    public TemplateEditor(UI ui) {
        super(new BorderLayout());
        Runnable onPaste;
        this.Ui = ui;
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel panelTemplates = new JPanel(new BorderLayout());
        panelTemplates.setOpaque(false);
        this.listTemplates = new EditableList<Template>(ui.Localizer, ui.DataModel.Templates, x -> "[" + x.Name.get() + "]", this::addNewTemplate, template -> this.Ui.DataModel.Templates.removeElement((Template)template), (i1, i2) -> TemplateEditor.swap(i1, i2, uI.DataModel.Templates));
        this.listTemplates.OnPasteHack = onPaste = this::onPaste;
        this.CurrentTemplate = this.listTemplates.SelectedElement;
        panelTemplates.add(this.listTemplates, "Center");
        JPanel panelTemplate = new JPanel(new GridBagLayout());
        panelTemplate.setOpaque(false);
        panelTemplates.add((Component)panelTemplate, "South");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        TemplateEditor.addSeparator(panelTemplate, gbc);
        JLabel labelTemplateName = new JLabel();
        this.Ui.Localizer.bind("#Label_TemplateName", labelTemplateName::setText);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panelTemplate.add((Component)labelTemplateName, gbc);
        JTextField textField = new JTextField();
        MutableBool updating = new MutableBool(false);
        this.listTemplates.SelectedElement.bind(template -> {
            textField.setEnabled(template != null);
            if (template != null) {
                mutableBool.Value = true;
                textField.setText(template.Name.get());
                mutableBool.Value = false;
            }
        });
        MiscAWT.bind(textField.getDocument(), () -> {
            Template currentTemplate = this.CurrentTemplate.get();
            if (currentTemplate != null && !mutableBool.Value) {
                currentTemplate.setName(textField.getText().trim());
            }
        });
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        panelTemplate.add((Component)textField, gbc);
        gbc.fill = 0;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        TemplateEditor.addSeparator(panelTemplate, gbc);
        MutableBool settingValue = new MutableBool(false);
        JTextField textFieldMaxWidth = new JTextField(5);
        JTextField textFieldMaxHeight = new JTextField(5);
        JCheckBox checkBoxResize = new JCheckBox();
        checkBoxResize.setOpaque(false);
        this.Ui.Localizer.bind("#Label_TemplateResize", checkBoxResize::setText);
        Runnable inputChecker = () -> {
            boolean enabled = this.listTemplates.SelectedElement.get() != null && checkBoxResize.isSelected();
            textFieldMaxWidth.setEnabled(enabled);
            textFieldMaxHeight.setEnabled(enabled);
        };
        this.listTemplates.SelectedElement.bind(template -> {
            mutableBool.Value = true;
            boolean enabled = template != null;
            checkBoxResize.setEnabled(enabled);
            if (enabled) {
                checkBoxResize.setSelected(template.Resize);
                textFieldMaxWidth.setText("" + template.MaximumSize.width);
                textFieldMaxHeight.setText("" + template.MaximumSize.height);
            }
            inputChecker.run();
            mutableBool.Value = false;
        });
        checkBoxResize.addActionListener(evt -> {
            Template currentTemplate = this.CurrentTemplate.get();
            if (!mutableBool.Value && currentTemplate != null) {
                currentTemplate.Resize = checkBoxResize.isSelected();
                this.Ui.DataModel.setDirty();
                inputChecker.run();
            }
        });
        panelTemplate.add((Component)checkBoxResize, gbc);
        ++gbc.gridy;
        JPanel panelResizeMax = new JPanel(new GridBagLayout());
        panelResizeMax.setOpaque(false);
        panelTemplate.add((Component)panelResizeMax, gbc);
        ++gbc.gridy;
        JLabel labelMax = new JLabel();
        this.Ui.Localizer.bind("#Label_TemplateResizeMax", labelMax::setText);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.weightx = 0.0;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        panelResizeMax.add((Component)labelMax, gbc2);
        Runnable setSize = () -> {
            Template template = this.CurrentTemplate.get();
            if (!mutableBool.Value && template != null) {
                template.MaximumSize.setSize(Misc.getAsInt(textFieldMaxWidth.getText(), template.MaximumSize.width), Misc.getAsInt(textFieldMaxHeight.getText(), template.MaximumSize.height));
                this.Ui.DataModel.setDirty();
            }
        };
        MiscAWT.bind(textFieldMaxWidth.getDocument(), setSize);
        MiscAWT.bind(textFieldMaxHeight.getDocument(), setSize);
        textFieldMaxWidth.setHorizontalAlignment(0);
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        ++gbc2.gridx;
        panelResizeMax.add((Component)textFieldMaxWidth, gbc2);
        gbc2.fill = 0;
        gbc2.weightx = 0.0;
        ++gbc2.gridx;
        panelResizeMax.add((Component)new JLabel(" x "), gbc2);
        textFieldMaxHeight.setHorizontalAlignment(0);
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        ++gbc2.gridx;
        panelResizeMax.add((Component)textFieldMaxHeight, gbc2);
        settingValue = new MutableBool(false);
        JTextField textFieldQuality = new JTextField(5);
        JCheckBox checkBoxQuality = new JCheckBox();
        checkBoxQuality.setOpaque(false);
        this.Ui.Localizer.bind("#Label_JPEGQuality", checkBoxQuality::setText);
        Runnable setQuality = () -> {
            Template template = this.CurrentTemplate.get();
            if (!mutableBool.Value && template != null) {
                template.setJPEGQuality(checkBoxQuality.isSelected() ? Float.valueOf(Misc.getAsFloat(textFieldQuality.getText(), 75.0f) / 100.0f) : null);
                this.Ui.DataModel.setDirty();
            }
        };
        Consumer<Template> setQualityText = template -> {
            String text = "";
            if (template.getJPEGQuality() != null) {
                float value = template.getJPEGQuality().floatValue() * 100.0f;
                text = (float)((int)value) == value ? "" + (int)value : "" + value;
            }
            textFieldQuality.setText(text);
        };
        Runnable inputChecker2 = () -> {
            boolean enabled = this.listTemplates.SelectedElement.get() != null && checkBoxQuality.isSelected();
            textFieldQuality.setEnabled(enabled);
            Template currentTemplate = this.CurrentTemplate.get();
            if (enabled && currentTemplate != null && currentTemplate.getJPEGQuality() != null) {
                setQuality.run();
                setQualityText.accept(currentTemplate);
            }
        };
        this.listTemplates.SelectedElement.bind(template -> {
            mutableBool.Value = true;
            boolean enabled = template != null;
            checkBoxQuality.setEnabled(enabled);
            if (enabled) {
                checkBoxQuality.setSelected(template.getJPEGQuality() != null);
                setQualityText.accept((Template)template);
            }
            inputChecker2.run();
            mutableBool.Value = false;
        });
        checkBoxQuality.addActionListener(evt -> {
            Template currentTemplate = this.CurrentTemplate.get();
            if (!mutableBool.Value && currentTemplate != null) {
                currentTemplate.setJPEGQuality(checkBoxQuality.isSelected() && currentTemplate.getJPEGQuality() == null ? Float.valueOf(0.75f) : null);
                this.Ui.DataModel.setDirty();
                inputChecker2.run();
            }
        });
        panelTemplate.add((Component)checkBoxQuality, gbc);
        ++gbc.gridy;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panelTemplate.add((Component)panel, gbc);
        ++gbc.gridy;
        GridBagConstraints gbc22 = new GridBagConstraints();
        gbc22.weightx = 0.0;
        gbc22.gridx = 0;
        gbc22.gridy = 0;
        gbc22.anchor = 21;
        MiscAWT.bind(textFieldQuality.getDocument(), setQuality);
        textFieldQuality.setHorizontalAlignment(0);
        gbc22.fill = 2;
        gbc22.weightx = 0.0;
        panel.add((Component)textFieldQuality, gbc22);
        gbc22.fill = 0;
        gbc22.weightx = 0.0;
        ++gbc22.gridx;
        panel.add((Component)new JLabel(" %"), gbc22);
        this.listModelLayers = new LayerListModel();
        JPanel panelObjects = new JPanel(new BorderLayout(5, 5));
        panelObjects.setOpaque(false);
        JLabel label = new JLabel("");
        this.Ui.Localizer.bind("#Label_Layers", label::setText);
        panelObjects.add((Component)label, "North");
        this.listLayers = new EditableList<Layer>(ui.Localizer, this.listModelLayers, x -> String.valueOf(x.Name) + " (" + Misc.toLower(x.getExtension()) + ")", this::addNewLayer, object -> {
            this.CurrentTemplate.get().Objects.remove(object);
            this.listModelLayers.removeElement(object);
        }, this.listModelLayers::swap);
        this.listLayers.OnPasteHack = onPaste;
        panelObjects.add(this.listLayers, "Center");
        JPanel panelPreview = new JPanel(new BorderLayout());
        panelPreview.setOpaque(false);
        panelPreview.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.preview = new TemplatePreview();
        panelPreview.add((Component)this.preview, "Center");
        JPanel panelLayer = new JPanel(new GridBagLayout());
        panelLayer.setOpaque(false);
        panelObjects.add((Component)panelLayer, "South");
        this.listLayers.SelectedElement.bind(this::setLayer);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        TemplateEditor.addSeparator(panelLayer, gbc);
        JPanel panelLayerName = new JPanel(new BorderLayout());
        panelLayerName.setOpaque(false);
        JLabel labelLayerName = new JLabel();
        this.Ui.Localizer.bind("#Label_LayerName", labelLayerName::setText);
        panelLayerName.add((Component)labelLayerName, "Before");
        JTextField textField2 = new JTextField();
        MutableBool updating2 = new MutableBool(false);
        this.listLayers.SelectedElement.bind(layer -> {
            textField2.setEnabled(layer != null);
            if (layer != null) {
                mutableBool.Value = true;
                textField2.setText(layer.Name);
                mutableBool.Value = false;
            }
        });
        MiscAWT.bind(textField2.getDocument(), () -> {
            if (this.currentLayer != null && !mutableBool.Value) {
                this.currentLayer.Name = textField2.getText().trim();
                this.listModelLayers.update(this.currentLayer);
                this.Ui.DataModel.setDirty();
            }
        });
        panelLayerName.add((Component)textField2, "Center");
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        panelLayer.add((Component)panelLayerName, gbc);
        ++gbc.gridy;
        TemplateEditor.addSeparator(panelLayer, gbc);
        this.addController(panelLayer, gbc, "PosX", l -> l.Position.X, (l, v) -> {
            double d = l.Position.X = v;
        });
        this.addController(panelLayer, gbc, "PosY", l -> l.Position.Y, (l, v) -> {
            double d = l.Position.Y = v;
        });
        TemplateEditor.addSeparator(panelLayer, gbc);
        this.addController(panelLayer, gbc, "ScaleX", l -> l.Scale.X, (l, v) -> {
            double d = l.Scale.X = v;
        });
        this.addController(panelLayer, gbc, "ScaleY", l -> l.Scale.Y, (l, v) -> {
            double d = l.Scale.Y = v;
        });
        TemplateEditor.addSeparator(panelLayer, gbc);
        this.addController(panelLayer, gbc, "PivotX", l -> l.Pivot.X, (l, v) -> {
            double d = l.Pivot.X = v;
        });
        this.addController(panelLayer, gbc, "PivotY", l -> l.Pivot.Y, (l, v) -> {
            double d = l.Pivot.Y = v;
        });
        TemplateEditor.addSeparator(panelLayer, gbc);
        this.addController(panelLayer, gbc, "Fill", l -> l.Fill, (l, v) -> {
            double d = l.Fill = v;
        });
        this.addController(panelLayer, gbc, "Rotation", l -> l.Rotation, (l, v) -> {
            double d = l.Rotation = v;
        });
        this.addController(panelLayer, gbc, "Opacity", l -> l.Opacity, (l, v) -> {
            float f = l.Opacity = (float)v;
        });
        this.add((Component)new UnexpandingPanel(panelTemplates, 200, null), "Before");
        this.add((Component)panelPreview, "Center");
        this.add((Component)new UnexpandingPanel(panelObjects, 200, null), "After");
        this.listTemplates.SelectedElement.bind(this::setTemplate);
        ui.DataModel.CurrentImage.bind(this.preview::setBackgroundImage);
        ui.DataModel.waitForLoadedAsync().await(() -> {
            Template template = uI.DataModel.DefaultTemplate.get();
            this.listTemplates.select(template == null && uI.DataModel.Templates.size() > 0 ? (Template)uI.DataModel.Templates.firstElement() : template);
        });
        new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                boolean flvFileList = dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
                boolean flvImage = dtde.isDataFlavorSupported(DataFlavor.imageFlavor);
                if (!flvFileList && !flvImage) {
                    dtde.rejectDrop();
                } else {
                    dtde.acceptDrop(dtde.getDropAction());
                    try {
                        if (flvFileList) {
                            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                            TemplateEditor.this.addFilesAsync(files).await((Boolean)((Object)((Consumer<Boolean>)dtde::dropComplete)));
                        } else {
                            TemplateEditor.this.addImage((Image)dtde.getTransferable().getTransferData(DataFlavor.imageFlavor));
                            dtde.dropComplete(true);
                        }
                    }
                    catch (UnsupportedFlavorException | IOException e) {
                        dtde.dropComplete(false);
                        ((TemplateEditor)TemplateEditor.this).Ui.DataModel.addException(e);
                    }
                }
            }
        });
    }

    public void onPaste() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                if (image != null) {
                    this.addImage(image);
                    return;
                }
            }
            catch (UnsupportedFlavorException | IOException | IllegalStateException image) {
                // empty catch block
            }
            try {
                List files = (List)clipboard.getData(DataFlavor.javaFileListFlavor);
                if (files != null) {
                    this.addFilesAsync(files);
                }
            }
            catch (UnsupportedFlavorException | IOException | IllegalStateException exception) {}
        }
        catch (Exception e) {
            this.Ui.DataModel.addException(e);
        }
    }

    private static void addSeparator(JPanel panel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        Insets insets = gbc.insets;
        gbc.insets = SEPARATOR_INSETS;
        panel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.insets = insets;
    }

    private void addController(JPanel panel, GridBagConstraints gbc, String name, DoubleGet get, DoubleSet set) {
        MutableBool changing = new MutableBool(false);
        JLabel label = new JLabel();
        this.Ui.Localizer.bind("#Ctrl_" + name, label::setText);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        panel.add((Component)label, gbc);
        ++gbc.gridy;
        JTextField textField = new JTextField(5);
        textField.setMinimumSize(textField.getPreferredSize());
        textField.setForeground(COLOR_VALID_INPUT);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        panel.add((Component)textField, gbc);
        gbc.weightx = 1.0;
        JSlider slider = new JSlider(0, 1000);
        slider.setOpaque(false);
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(100);
        slider.setMinorTickSpacing(50);
        ++gbc.gridx;
        panel.add((Component)slider, gbc);
        ++gbc.gridy;
        DoubleConsumer setValue = value -> {
            if (this.currentLayer != null) {
                this.Ui.DataModel.setDirty();
                set.set(this.currentLayer, value);
            }
        };
        DoubleConsumer setSliderValue = value -> {
            if (value < 0.0) {
                slider.setEnabled(false);
                slider.setValue(0);
            } else if (value > 1.0) {
                slider.setEnabled(false);
                slider.setValue(1000);
            } else {
                slider.setEnabled(this.currentLayer != null);
                slider.setValue((int)Math.round(value * 1000.0));
            }
        };
        DoubleConsumer setTextFieldValue = value -> {
            textField.setText(FormatDoubles.format(value));
            textField.setForeground(COLOR_VALID_INPUT);
        };
        MiscAWT.bind(textField.getDocument(), () -> {
            double value;
            if (mutableBool.Value) {
                return;
            }
            mutableBool.Value = true;
            String text = textField.getText();
            try {
                value = Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                try {
                    value = Double.parseDouble(text.replace(',', '.'));
                }
                catch (NumberFormatException e2) {
                    textField.setForeground(COLOR_INVALID_INPUT);
                    mutableBool.Value = false;
                    return;
                }
            }
            textField.setForeground(COLOR_VALID_INPUT);
            setValue.accept(value);
            setSliderValue.accept(value);
            mutableBool.Value = false;
            this.preview.repaint();
        });
        slider.addChangeListener(evt -> {
            if (mutableBool.Value) {
                return;
            }
            mutableBool.Value = true;
            double value = (double)slider.getValue() / 1000.0;
            setValue.accept(value);
            setTextFieldValue.accept(value);
            mutableBool.Value = false;
            this.preview.repaint();
        });
        this.listLayers.SelectedElement.bind(x -> {
            if (x == null) {
                textField.setEnabled(false);
                slider.setEnabled(false);
                return;
            }
            textField.setEnabled(true);
            slider.setEnabled(true);
            double value = get.get((Layer)x);
            mutableBool.Value = true;
            setSliderValue.accept(value);
            setTextFieldValue.accept(value);
            mutableBool.Value = false;
        });
    }

    private void addNewTemplate() {
        Template newTemplate = new Template(this.Ui.DataModel, "new template_" + Misc.getRandomInt(Integer.MAX_VALUE));
        this.Ui.DataModel.Templates.addElement(newTemplate);
        this.listTemplates.select(newTemplate);
        this.repaint();
    }

    private Layer addNewLayer() {
        return this.addNewLayer(this.CurrentTemplate.get(), "Layer" + this.CurrentTemplate.get().Objects.size());
    }

    private Layer addNewLayer(Template template, String name) {
        Layer layer = new Layer(template, name);
        template.Objects.add(layer);
        if (template == this.CurrentTemplate.get()) {
            this.listModelLayers.addElement(layer);
            this.listLayers.select(layer);
        }
        template.DataModel.setDirty();
        this.repaint();
        return layer;
    }

    public void selectTemplate(Template template) {
        this.listTemplates.select(template);
    }

    private void setTemplate(Template template) {
        this.listLayers.setEnabled(template != null);
        this.preview.setTemplate(template);
        this.listModelLayers.refresh();
        this.listLayers.select(template == null ? null : (template.Objects.size() > 0 ? template.Objects.get(0) : null));
        this.repaint();
    }

    private void setLayer(Layer layer) {
        this.currentLayer = layer;
        this.preview.setLayer(layer);
        this.repaint();
    }

    @Override
    public void dispose() {
        this.listTemplates.dispose();
        this.preview.dispose();
    }

    public Task<Boolean> addFilesAsync(List<File> files) {
        if (!files.isEmpty()) {
            if (this.CurrentTemplate.get() == null) {
                this.addNewTemplate();
            }
            Template template = this.CurrentTemplate.get();
            Layer firstLayer = this.currentLayer;
            MutableBool allIsWell = new MutableBool(true);
            MutableBool replaced = new MutableBool(false);
            return Async.forEach(files, Layer::loadImageAsync, result -> {
                Layer layer2;
                if (result.Exception != null) {
                    mutableBool.Value = false;
                    return;
                }
                Layer layer3 = layer2 = mutableBool2.Value ? null : firstLayer;
                if (layer2 == null) {
                    layer2 = this.addNewLayer(template, MiscIO.getWithoutExtension(((Layer.LoadImageResult)result.Value).File));
                }
                mutableBool2.Value = true;
                if (!this.setImage(layer2, (FailableResult<Layer.LoadImageResult, IOException>)result)) {
                    mutableBool.Value = false;
                }
            }).awaitAndContinue(() -> mutableBool.Value);
        }
        return new Task<Boolean>(false);
    }

    private boolean setImage(Layer layer, FailableResult<Layer.LoadImageResult, IOException> result) {
        if (result.Exception != null) {
            this.Ui.DataModel.addException((Throwable)result.Exception);
            return false;
        }
        this.Ui.DataModel.setDirty();
        layer.setImage((Layer.LoadImageResult)result.Value);
        this.listLayers.update(this.currentLayer);
        this.repaint();
        return true;
    }

    private void addImage(Image image) {
        if (this.CurrentTemplate.get() == null) {
            this.addNewTemplate();
        }
        if (this.currentLayer == null) {
            this.addNewLayer();
        }
        this.Ui.DataModel.setDirty();
        this.currentLayer.setImage(MiscImg.prepareImage(image));
        this.listLayers.update(this.currentLayer);
    }

    private static <T> void swap(int index1, int index2, DefaultListModel<T> model) {
        if (index1 > index2) {
            int tmp = index2;
            index2 = index1;
            index1 = tmp;
        }
        T obj = model.get(index1);
        model.set(index1, model.get(index2));
        model.set(index2, obj);
    }

    @FunctionalInterface
    private static interface DoubleGet {
        public double get(Layer var1);
    }

    @FunctionalInterface
    private static interface DoubleSet {
        public void set(Layer var1, double var2);
    }

    private class LayerListModel
    extends DefaultListModel<Layer> {
        private static final long serialVersionUID = 1L;

        private LayerListModel() {
        }

        public void refresh() {
            this.clear();
            Template currentTemplate = TemplateEditor.this.CurrentTemplate.get();
            if (currentTemplate != null) {
                for (Layer object : currentTemplate.Objects) {
                    this.addElement(object);
                }
            }
        }

        public void update(Layer layer) {
            int index = this.indexOf(layer);
            this.fireContentsChanged(this, index, index);
        }

        public void swap(int index1, int index2) {
            Collections.swap(TemplateEditor.this.CurrentTemplate.get().Objects, index1, index2);
            TemplateEditor.swap(index1, index2, this);
            ((TemplateEditor)TemplateEditor.this).Ui.DataModel.setDirty();
            TemplateEditor.this.repaint();
        }

        @Override
        public boolean removeElement(Object obj) {
            Layer layer = (Layer)obj;
            File imageFile = layer.getImageFile();
            if (imageFile != null) {
                ((TemplateEditor)TemplateEditor.this).Ui.DataModel.DeletedFiles.add(imageFile);
            }
            return super.removeElement(obj);
        }
    }
}

