/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker.ui;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.helpers.ui.awt.UnexpandingPanel;
import com.iosoft.watermarker.ResizablePreviewImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ImagePreview
extends JPanel
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private final ResizablePreviewImage previewImage = new ResizablePreviewImage();
    private final Dimension lastSize = new Dimension(0, 0);
    private final Point currentOffset = new Point();
    private final JProgressBar progressBar = new JProgressBar();
    private VTask taskLoad;

    public ImagePreview() {
        super(new BorderLayout());
        MiscAWT.setSize(this, new Dimension(200, 200));
        this.progressBar.setIndeterminate(true);
        this.add((Component)new UnexpandingPanel(this.progressBar, null, 30), "South");
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previewImage.Loading.bind(x -> this.checkProgressBar());
        this.checkProgressBar();
    }

    public void loadImage(File file) {
        this.cancelLoad();
        if (file == null) {
            this.previewImage.setImageFlushOld(null);
        } else {
            this.taskLoad = Async.runAsyncWrap(() -> MiscImg.loadImage(file)).awaitAndContinue(result -> {
                this.taskLoad = null;
                this.lastSize.setSize(0, 0);
                this.previewImage.setImageFlushOld((BufferedImage)result.Value);
                this.checkResize();
                this.checkProgressBar();
            });
        }
        this.checkProgressBar();
    }

    private void cancelLoad() {
        if (this.taskLoad != null) {
            this.taskLoad.cancel();
            this.taskLoad = null;
            this.checkProgressBar();
        }
    }

    private void checkProgressBar() {
        this.progressBar.setVisible(this.taskLoad != null || this.previewImage.Loading.get());
        this.repaint();
    }

    private void checkResize() {
        BufferedImage image = this.previewImage.getImage();
        if (image == null) {
            return;
        }
        int currentWidth = Math.max(1, this.getWidth());
        int currentHeight = Math.max(1, this.getHeight());
        if ((double)currentWidth != this.lastSize.getWidth() || (double)currentHeight != this.lastSize.getHeight()) {
            double height;
            double width;
            this.lastSize.setSize(currentWidth, currentHeight);
            double ratioWidthForHeight = (double)image.getWidth() / (double)image.getHeight();
            double widthForMaxHeight = (double)currentHeight * ratioWidthForHeight;
            if (widthForMaxHeight < (double)currentWidth) {
                width = widthForMaxHeight;
                height = currentHeight;
            } else {
                width = currentWidth;
                height = (double)currentWidth / ratioWidthForHeight;
            }
            this.currentOffset.setLocation(((double)currentWidth - width) * 0.5, ((double)currentHeight - height) * 0.5);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        int currentWidth = this.getWidth();
        int currentHeight = this.getHeight();
        g.fillRect(0, 0, currentWidth, currentHeight);
        this.checkResize();
        g.translate(this.currentOffset.x, this.currentOffset.y);
        this.previewImage.draw(g, currentWidth - this.currentOffset.x * 2, currentHeight - this.currentOffset.y * 2);
        g.translate(-this.currentOffset.x, -this.currentOffset.y);
    }

    @Override
    public void dispose() {
        this.previewImage.dispose();
        this.cancelLoad();
    }
}

