/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker.ui;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.binding.Command;
import com.iosoft.helpers.binding.Disposables;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.localizer.ILocalizer;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class EditableList<T>
extends JPanel
implements IDisposable {
    private static final long serialVersionUID = 1L;
    private final Disposables disposables = new Disposables();
    private final Swap swap;
    private final Function<T, String> toString;
    private final EditableListModel listModel;
    private final JList<ElementWrapper> list;
    private final JButton buttonAdd;
    private final JButton buttonRemove;
    private final JButton buttonUp;
    private final JButton buttonDown;
    private final JButton buttonDeselect;
    private boolean swapping = false;
    public Runnable OnPasteHack;
    private final MyObservable<T> selectedElement = new MyObservable<Object>(null);
    public final Observable<T> SelectedElement;

    public EditableList(ILocalizer translator, ListModel<T> nativeListModel, Runnable onAdd, Consumer<T> onRemove, Swap swap) {
        this(translator, nativeListModel, Object::toString, onAdd, onRemove, swap);
    }

    public EditableList(ILocalizer translator, ListModel<T> nativeListModel, Function<T, String> toString, Runnable onAdd, Consumer<T> onRemove, Swap swap) {
        super(new BorderLayout());
        this.SelectedElement = this.selectedElement.Getter;
        this.setOpaque(false);
        this.toString = Misc.notNull(toString);
        this.swap = Misc.notNull(swap);
        Misc.notNull(onAdd);
        Misc.notNull(onRemove);
        this.listModel = new EditableListModel(nativeListModel, this.disposables);
        this.list = new JList<ElementWrapper>(this.listModel);
        MyBoolObservable entrySelected = new MyBoolObservable(false);
        MyBoolObservable entryCanUp = new MyBoolObservable(false);
        MyBoolObservable entryCanDown = new MyBoolObservable(false);
        final Command deleteSelectedEntry = new Command(entrySelected.Getter, () -> onRemove.accept(this.list.getSelectedValue().Element));
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    deleteSelectedEntry.tryPerform();
                } else if (EditableList.this.OnPasteHack != null && e.getKeyCode() == 86 && MiscAWT.isCtrlDown(e)) {
                    EditableList.this.OnPasteHack.run();
                }
            }
        });
        this.list.addListSelectionListener(evt -> {
            if (this.swapping) {
                return;
            }
            ElementWrapper selectedValue = this.list.getSelectedValue();
            boolean notNull = selectedValue != null;
            int index = this.list.getSelectedIndex();
            entrySelected.set(notNull);
            entryCanUp.set(index > 0);
            entryCanDown.set(index < this.listModel.size() - 1);
            this.selectedElement.set(notNull ? selectedValue.Element : null);
        });
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)scrollPane, "Center");
        JPanel panelBottom = new JPanel(new FlowLayout(3, 0, 0));
        panelBottom.setOpaque(false);
        this.add((Component)panelBottom, "South");
        this.buttonAdd = new JButton("+");
        this.buttonAdd.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAdd.setPreferredSize(new Dimension(30, 20));
        this.buttonAdd.setOpaque(false);
        this.buttonAdd.setForeground(Color.GREEN.darker().darker());
        this.buttonAdd.addActionListener(evt -> onAdd.run());
        this.disposables.addDisposable(translator.bind("#List_Add_TT", this.buttonAdd::setToolTipText));
        panelBottom.add(this.buttonAdd);
        this.buttonRemove = new JButton("-");
        this.buttonRemove.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRemove.setPreferredSize(new Dimension(30, 20));
        this.buttonRemove.setOpaque(false);
        this.buttonRemove.setForeground(Color.RED);
        this.disposables.addDisposable(translator.bind("#List_Remove_TT", this.buttonRemove::setToolTipText));
        MiscAWT.bindCommand(this.buttonRemove, deleteSelectedEntry);
        panelBottom.add(this.buttonRemove);
        this.buttonUp = new JButton("^");
        this.buttonUp.setMargin(new Insets(0, 0, 0, 0));
        this.buttonUp.setPreferredSize(new Dimension(30, 20));
        this.buttonUp.setOpaque(false);
        this.disposables.addDisposable(translator.bind("#List_Up_TT", this.buttonUp::setToolTipText));
        MiscAWT.bindCommand(this.buttonUp, new Command(entryCanUp.Getter, () -> this.move(false)));
        panelBottom.add(this.buttonUp);
        this.buttonDown = new JButton("v");
        this.buttonDown.setMargin(new Insets(0, 0, 0, 0));
        this.buttonDown.setPreferredSize(new Dimension(30, 20));
        this.buttonDown.setOpaque(false);
        this.disposables.addDisposable(translator.bind("#List_Down_TT", this.buttonDown::setToolTipText));
        MiscAWT.bindCommand(this.buttonDown, new Command(entryCanDown.Getter, () -> this.move(true)));
        panelBottom.add(this.buttonDown);
        this.buttonDeselect = new JButton("x");
        this.buttonDeselect.setForeground(Color.ORANGE.darker().darker());
        this.buttonDeselect.setMargin(new Insets(0, 0, 0, 0));
        this.buttonDeselect.setPreferredSize(new Dimension(30, 20));
        this.buttonDeselect.setOpaque(false);
        this.disposables.addDisposable(translator.bind("#List_Deselect_TT", this.buttonDeselect::setToolTipText));
        this.buttonDeselect.addActionListener(evt -> this.list.setSelectedIndices(Misc.EMPTYINTS));
        panelBottom.add(this.buttonDeselect);
        deleteSelectedEntry.bind(x -> {
            this.buttonRemove.setVisible(x);
            this.buttonUp.setVisible(x);
            this.buttonDown.setVisible(x);
            this.buttonDeselect.setVisible(x);
        });
    }

    private void move(boolean down) {
        this.swapping = true;
        ElementWrapper wrapper = this.list.getSelectedValue();
        this.listModel.move(down, this.list.getSelectedIndex());
        this.swapping = false;
        this.listModel.rebuild();
        this.list.setSelectedValue(wrapper, true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonDeselect.setEnabled(enabled);
    }

    private ElementWrapper get(T element) {
        return MiscLINQ.firstOrDefault(this.listModel::size, this.listModel::get, x -> ((ElementWrapper)x).Element == element);
    }

    public boolean update(T element) {
        ElementWrapper wrapper = this.get(element);
        if (wrapper != null) {
            this.listModel.update(wrapper);
            return true;
        }
        return false;
    }

    public boolean select(T element) {
        ElementWrapper wrapper = this.get(element);
        if (wrapper != null) {
            this.list.setSelectedValue(wrapper, true);
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    private class EditableListModel
    extends DefaultListModel<ElementWrapper> {
        private static final long serialVersionUID = 1L;
        private final ListModel<T> listModel;

        EditableListModel(ListModel<T> listModel, Disposables disposables) {
            this.listModel = Misc.notNull(listModel);
            int i = 0;
            while (i < listModel.getSize()) {
                Object element = listModel.getElementAt(i);
                this.addElement(new ElementWrapper(element));
                ++i;
            }
            disposables.addDisposable(MiscAWT.bind(listModel, this::rebuild));
        }

        public void update(ElementWrapper wrapper) {
            int index = this.indexOf(wrapper);
            if (wrapper.updateString()) {
                this.fireContentsChanged(this, index, index);
            }
        }

        private void rebuild() {
            if (EditableList.this.swapping) {
                return;
            }
            int sizeNew = this.listModel.getSize();
            int i = 0;
            while (i < sizeNew) {
                Object element = this.listModel.getElementAt(i);
                if (i < this.size()) {
                    ElementWrapper wrapper = (ElementWrapper)this.getElementAt(i);
                    if (wrapper.Element == element) {
                        if (wrapper.updateString()) {
                            this.set(i, wrapper);
                        }
                    } else {
                        this.remove(i);
                        --i;
                    }
                } else {
                    this.addElement(new ElementWrapper(element));
                }
                ++i;
            }
            while (this.size() > sizeNew) {
                this.remove(this.size() - 1);
            }
        }

        private void move(boolean down, int index) {
            this.swap(index, index + (down ? 1 : -1));
        }

        private void swap(int index1, int index2) {
            if (index1 == index2 || index1 < 0 || index1 >= this.size() || index2 < 0 || index2 >= this.size()) {
                throw new IndexOutOfBoundsException(index1 + " | " + index2);
            }
            ElementWrapper element1 = (ElementWrapper)this.get(index1);
            this.set(index1, (ElementWrapper)this.get(index2));
            this.set(index2, element1);
            EditableList.this.swap.swap(index1, index2);
        }
    }

    private class ElementWrapper {
        private final T Element;
        private String string = "";

        ElementWrapper(T element) {
            this.Element = element;
            this.updateString();
        }

        public boolean updateString() {
            String newString = (String)EditableList.this.toString.apply(this.Element);
            if (newString != null && !newString.equals(this.string)) {
                this.string = newString;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.string;
        }
    }

    @FunctionalInterface
    static interface Swap {
        public void swap(int var1, int var2);
    }
}

