/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.EDTDispatcher;
import com.iosoft.helpers.async.dispatcher.ThreadDispatcher;
import com.iosoft.helpers.datasource.Resource;
import com.iosoft.helpers.localizer.LocalizationParser;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.watermarker.DataModel;
import com.iosoft.watermarker.ui.UI;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class Watermarker {
    public static final String VERSION = "1.4";
    private final Localizer localizer = new Localizer("english");
    private final DataModel dataModel = new DataModel(this.localizer);
    private final LocalizationParser parser = new LocalizationParser(this.localizer);

    public static void main(String[] argsArr) {
        String templateToUse;
        System.out.println("Arguments (" + argsArr.length + "):");
        String[] stringArray = argsArr;
        int n = argsArr.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.println(arg);
            ++n2;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArr));
        boolean silent = args.contains("-s") || args.contains("-silent");
        final boolean ui = !silent || args.contains("-ui");
        int idxTemplate = args.indexOf("-t") + 1;
        if (idxTemplate > 0) {
            if (args.size() <= idxTemplate) {
                Watermarker.alert("-t parameter given without template", ui);
                return;
            }
            templateToUse = (String)args.remove(idxTemplate);
        } else {
            templateToUse = null;
        }
        List files = args.stream().filter(x -> !x.startsWith("-")).map(File::new).collect(Collectors.toList());
        if (silent) {
            if (!files.isEmpty()) {
                ThreadDispatcher.createRunnerForCurrentThread(dispatcher -> {
                    final Watermarker watermarker = new Watermarker(ui);
                    watermarker.dataModel.getErrorList().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                        }

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                            int index = e.getIndex0();
                            do {
                                Watermarker.alert(Misc.printException(((Watermarker)watermarker).dataModel.getErrorList().getElementAt((int)index).Exception), ui);
                            } while (++index <= e.getIndex1());
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                        }
                    });
                    watermarker.startHeadlessAsync(templateToUse).awaitAndContinueVTask(() -> Async.forEach(files, file -> watermarker.dataModel.createWatermarkedImageAsync((File)file, templateToUse), x -> {})).await(dispatcher::dispose);
                }).waitBlockingCrashOnInterrupt();
            }
        } else {
            EDTDispatcher.initialize().dispatch(() -> {
                Watermarker watermarker = new Watermarker(ui);
                VTask task = watermarker.startUIAsync();
                if (!files.isEmpty()) {
                    task.await(() -> watermarker.dataModel.openImage((File)files.get(0)));
                }
            });
        }
    }

    private static void alert(String text, boolean ui) {
        if (ui) {
            JOptionPane.showMessageDialog(null, text, "Error", 0);
        }
        System.err.println(text);
    }

    private Watermarker(boolean ui) {
        Dispatcher.getForCurrentThread().setMainUnhandledExceptionHandler(x -> Watermarker.alert("Unhandled: " + Misc.printException(x), ui));
        this.parser.addTextsPropDB(new Resource("/res/text/"));
    }

    private VTask startUIAsync() {
        return this.startAsync(true, null);
    }

    private VTask startHeadlessAsync(String onlyLoadThisTemplate) {
        return this.startAsync(false, onlyLoadThisTemplate);
    }

    private VTask startAsync(boolean startUI, String onlyLoadThisTemplate) {
        return Async.enforceV(this.parser.loadTextsAsync()).awaitAndContinueVTask(() -> {
            this.dataModel.setLanguage(this.localizer.setDefaultLanguageBySystemLanguage());
            MiscAWT.setSystemLookAndFeel();
            if (startUI) {
                new UI(this.dataModel, this.localizer);
            }
            return this.dataModel.loadAsync(startUI, onlyLoadThisTemplate);
        });
    }
}

