/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.datasource.FileSource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.math.Vector2D;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.propdb.PropDB;
import com.iosoft.watermarker.DataModel;
import com.iosoft.watermarker.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Template {
    private static final String FileSettingsName = "config.dat";
    public final List<Layer> Objects = new ArrayList<Layer>();
    private final MyObservable<String> name = new MyObservable<String>("");
    public final Observable<String> Name;
    public boolean Resize;
    public final Dimension MaximumSize;
    private Float _jpegQuality;
    private File _folder;
    public final DataModel DataModel;

    public Template(DataModel dataModel, String newName) {
        this.Name = this.name.Getter;
        this.MaximumSize = new Dimension(800, 600);
        this.DataModel = dataModel;
        this.name.set(newName);
    }

    private static File getSettingsFile(File folder) {
        return new File(folder, FileSettingsName);
    }

    public static Task<Template> loadAsync(DataModel dataModel, File folder, String onlyLoadIfEqualOrNull) {
        File fileSettings = Template.getSettingsFile(folder);
        return PropDB.loadSourceAsync(new FileSource(fileSettings)).awaitAndContinueTask(result -> {
            if (result.Exception != null) {
                dataModel.addException((Throwable)result.Exception);
                return new Task<Object>(null);
            }
            Template template = new Template(dataModel, "");
            return template.loadAsync(((PropDB)result.Value).getRoot(), folder, onlyLoadIfEqualOrNull).awaitAndContinue(() -> template);
        });
    }

    private VTask loadAsync(PropDB.Node nodeRoot, File folder, String onlyLoadIfEqualOrNull) {
        this._folder = folder;
        String myName = nodeRoot.getAsString();
        if (myName.isEmpty()) {
            myName = folder.getName();
        }
        if (onlyLoadIfEqualOrNull != null && !myName.equals(onlyLoadIfEqualOrNull)) {
            return VTask.COMPLETED_TASK;
        }
        Log.App.info("Loading template '" + myName + "'...");
        this.name.set(myName);
        this.Resize = nodeRoot.get("Resize", this.Resize);
        this.MaximumSize.width = nodeRoot.get("MaxWidth", this.MaximumSize.width);
        this.MaximumSize.height = nodeRoot.get("MaxHeight", this.MaximumSize.height);
        String jpegQuality = nodeRoot.get("JPEGQuality", "");
        this.setJPEGQuality(jpegQuality.isEmpty() ? null : Misc.tryGetAsFloat(jpegQuality));
        PropDB.Node nodeLayers = nodeRoot.tryGetChild("Layers");
        if (nodeLayers == null) {
            return VTask.COMPLETED_TASK;
        }
        return Async.forEach(nodeLayers, node -> Layer.loadObjAsync(this, node, folder), result -> {
            if (result != null) {
                this.Objects.add((Layer)result);
            }
        });
    }

    public void setJPEGQuality(Float quality) {
        this._jpegQuality = quality == null ? null : Float.valueOf(Misc.clamp01(quality.floatValue()));
    }

    public Float getJPEGQuality() {
        return this._jpegQuality;
    }

    private PropDB.Node save(PropDB.Node nodeRoot) {
        nodeRoot.setValue(this.Name.get());
        nodeRoot.set("Resize", this.Resize);
        nodeRoot.set("MaxWidth", this.MaximumSize.width);
        nodeRoot.set("MaxHeight", this.MaximumSize.height);
        nodeRoot.set("JPEGQuality", this._jpegQuality == null ? "" : this._jpegQuality.toString());
        return nodeRoot.add("Layers");
    }

    public void save(List<Supplier<Task<IOException>>> tasks) {
        if (this._folder == null) {
            this._folder = new File(this.DataModel.TemplatesFolder, MiscIO.sanitizeFileName(this.Name.get(), true));
        }
        PropDB propDB = new PropDB();
        PropDB.Node nodeLayers = this.save(propDB.getRoot());
        tasks.add(() -> propDB.saveAsync(Template.getSettingsFile(this._folder)));
        for (Layer layer : this.Objects) {
            tasks.add(layer.save(nodeLayers, this._folder));
        }
    }

    public BufferedImage watermarkImage(BufferedImage imgSource) {
        int width = imgSource.getWidth();
        int height = imgSource.getHeight();
        if (this.Resize) {
            double ratio = (double)height / (double)width;
            if (width > this.MaximumSize.width) {
                width = this.MaximumSize.width;
                height = (int)((double)width * ratio);
            }
            if (height > this.MaximumSize.height) {
                height = this.MaximumSize.height;
                width = (int)((double)height / ratio);
            }
        }
        BufferedImage imgDestination = MiscImg.resizeCopy(imgSource, width, height, imgSource.getTransparency() == 1 ? 5 : 2);
        Vector2D canvasSize = new Vector2D(width, height);
        Graphics2D g = imgDestination.createGraphics();
        this.drawWatermarks(g, canvasSize, true);
        g.dispose();
        return imgDestination;
    }

    public void drawWatermarks(Graphics2D g, Vector2D canvasSize, boolean goodQuality) {
        if (goodQuality) {
            MiscAWT.setBestQuality(g);
        } else {
            MiscAWT.setAA(g);
        }
        int i = this.Objects.size() - 1;
        while (i >= 0) {
            this.Objects.get(i).render(g, canvasSize, goodQuality);
            --i;
        }
    }

    public void setName(String newName) {
        if (!newName.equals(this.Name.get())) {
            this.name.set(newName);
            this.DataModel.Templates.update(this);
            this.DataModel.setDirty();
        }
    }

    public File getFolder() {
        return this._folder;
    }
}

