/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class ResizablePreviewImage
implements IDisposable {
    private final MyBoolObservable loading = new MyBoolObservable(false);
    public final BoolObservable Loading;
    private final Dimension currentDimension;
    private boolean resize;
    private BufferedImage currentImage;
    private BufferedImage currentImageResized;
    private VTask taskResize;

    public ResizablePreviewImage() {
        this.Loading = this.loading.Getter;
        this.currentDimension = new Dimension(0, 0);
    }

    public void setImage(BufferedImage image) {
        this.flushResized();
        this.currentImage = image;
        this.currentImageResized = null;
        int width = this.currentDimension.width;
        int height = this.currentDimension.height;
        this.currentDimension.setSize(0, 0);
        this.setSize(width, height);
    }

    public void setImageFlushOld(BufferedImage image) {
        if (this.currentImage != null) {
            this.currentImage.flush();
        }
        this.setImage(image);
    }

    private void flushResized() {
        if (this.currentImageResized != null) {
            this.currentImageResized.flush();
        }
    }

    public BufferedImage getImage() {
        return this.currentImage;
    }

    public void setSize(int width, int height) {
        this.setSize_(Math.max(1, width), Math.max(1, height));
    }

    private void setSize_(int width, int height) {
        if (width == this.currentDimension.width && height == this.currentDimension.height || this.currentImage == null) {
            return;
        }
        this.resize = true;
        this.currentDimension.setSize(width, height);
        this.cancelResize();
        BufferedImage imageToResize = this.currentImage;
        this.taskResize = Task.runAsync(() -> MiscImg.resizePrepared(imageToResize, width, height)).awaitAndContinue(result -> {
            this.taskResize = null;
            this.flushResized();
            this.currentImageResized = result;
            this.resize = false;
            this.loading.set(false);
        });
        this.loading.set(true);
    }

    private void cancelResize() {
        if (this.taskResize != null) {
            this.taskResize.cancel();
            this.taskResize = null;
        }
    }

    public void draw(Graphics g, int width, int height) {
        this.setSize_(Math.max(1, width), Math.max(1, height));
        if (this.currentImage != null) {
            BufferedImage image;
            BufferedImage bufferedImage = image = this.currentImageResized != null ? this.currentImageResized : this.currentImage;
            if (this.resize) {
                g.drawImage(image, 0, 0, width, height, null);
            } else {
                g.drawImage(image, 0, 0, null);
            }
        }
    }

    @Override
    public void dispose() {
        this.cancelResize();
    }
}

