/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.math.Vector2D;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.propdb.PropDB;
import com.iosoft.watermarker.Template;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

public class Layer
implements IDisposable {
    public final Vector2D Position = new Vector2D(0.5, 0.5);
    public final Vector2D Scale = new Vector2D(0.6, 0.6);
    public final Vector2D Pivot = new Vector2D(0.5, 0.5);
    public double Rotation;
    public float Opacity = 0.5f;
    private BufferedImage imageSource;
    public double Fill;
    public String Name;
    private File imageFile;
    private String format = "-";
    private String newImageFileName;
    private byte[] newImageData;
    private boolean faulted = false;
    private final Template template;
    private static final Task<IOException> IOTaskDone = new Task<Object>(null);
    private static final Supplier<Task<IOException>> IOTaskDoneSupplier = () -> IOTaskDone;
    private static final long sw_strokeani = Stopwatch.start();
    private static final double ANIM_STROKE_LENGTH_MILLIS = 800.0;
    public static final int NUM_ANIM_STROKE_FRAMES_PER_SECOND = 12;
    private static final Stroke[] ANIM_STROKE = new Stroke[12];
    private double maxWidth;
    private double maxHeight;
    private double imgWidth;
    private double imgHeight;

    static {
        float[] dashes = new float[]{4.0f};
        float progressDelta = 0.6666667f;
        int i = 0;
        while (i < 12) {
            Layer.ANIM_STROKE[i] = new BasicStroke(1.0f, 2, 0, 1.0f, dashes, progressDelta * (float)i);
            ++i;
        }
    }

    public Layer(Template template, String name) {
        this.template = template;
        this.Name = Misc.notNull(name);
    }

    static Task<Layer> loadObjAsync(Template template, PropDB.Node node, File folderTemplate) {
        Layer layer = new Layer(template, "");
        return layer.loadAsync(node, folderTemplate).awaitAndContinue(() -> layer);
    }

    public VTask loadAsync(PropDB.Node node, File folderTemplate) {
        this.Name = node.getAsString();
        String imageFileName = node.getName();
        if (this.Name.isEmpty()) {
            this.Name = imageFileName;
        }
        this.imageFile = imageFileName.startsWith("-") ? null : new File(folderTemplate, node.getName());
        this.Opacity = node.get("Opacity", this.Opacity);
        PropDB.Node nodeRotationDeg = node.tryGetChild("RotationDeg");
        if (nodeRotationDeg != null) {
            this.Rotation = nodeRotationDeg.getAsDouble() / 360.0;
        }
        this.Rotation = node.get("Rotation", this.Rotation);
        this.Fill = node.get("Fill", this.Fill);
        node.get("Scale", this.Scale);
        node.get("Pivot", this.Pivot);
        node.get("Position", this.Position);
        return this.reloadImageAsync();
    }

    public Supplier<Task<IOException>> save(PropDB.Node nodeList, File folderTemplate) {
        PropDB.Node node = nodeList.add(this.newImageFileName == null ? (this.imageFile == null ? "-" + UUID.randomUUID().toString() : this.imageFile.getName()) : this.newImageFileName);
        node.setValue(this.Name);
        node.set("Opacity", this.Opacity);
        node.set("Rotation", this.Rotation);
        node.set("Fill", this.Fill);
        node.set("Scale", this.Scale);
        node.set("Pivot", this.Pivot);
        node.set("Position", this.Position);
        if (this.newImageData == null) {
            return IOTaskDoneSupplier;
        }
        byte[] data = this.newImageData;
        String newFileName = this.newImageFileName;
        File oldFile = this.imageFile;
        return () -> Async.runAsyncWrap(() -> {
            File newFile = new File(folderTemplate, newFileName);
            Files.write(newFile.toPath(), data, new OpenOption[0]);
            if (oldFile != null) {
                Files.delete(oldFile.toPath());
            }
            return newFile;
        }).awaitAndTranslate(result -> {
            if (result.Exception == null) {
                this.newImageFileName = null;
                this.newImageData = null;
                this.imageFile = (File)result.Value;
            }
            return (IOException)result.Exception;
        });
    }

    public static Task<FailableResult<LoadImageResult, IOException>> loadImageAsync(File fileSource) {
        return Async.runAsyncWrap(() -> {
            byte[] bytes = Files.readAllBytes(fileSource.toPath());
            Throwable throwable = null;
            Object var3_4 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                BufferedImage image = ImageIO.read(bais);
                if (image == null) {
                    throw new IOException("Could not read file '" + fileSource.getPath() + "' as an image");
                }
                return new LoadImageResult(fileSource, bytes, image);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    public void setImage(LoadImageResult data) {
        this.setImage(data.Image, data.Data, MiscIO.getExtensionSafe(data.File, "x"));
    }

    public void setImage(BufferedImage image) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                if (!ImageIO.write((RenderedImage)image, "png", baos)) {
                    throw new IOException("Could not write a png?");
                }
                this.setImage(image, baos.toByteArray(), "png");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
    }

    private void setImage(BufferedImage image, byte[] data, String extension) {
        this.format = extension;
        this.newImageFileName = String.valueOf(UUID.randomUUID().toString()) + "." + Misc.toLower(extension);
        this.newImageData = data;
        this.flushImage();
        this.imageSource = image;
    }

    public VTask reloadImageAsync() {
        if (this.imageFile == null) {
            return VTask.COMPLETED_TASK;
        }
        File file = this.imageFile;
        return MiscImg.loadImageAsync(file).awaitAndContinue(result -> {
            this.imageSource = (BufferedImage)result.Value;
            this.format = MiscIO.getExtension(file);
            if (result.Exception == null) {
                this.faulted = false;
            } else if (!this.faulted) {
                this.faulted = true;
                this.template.DataModel.addException(new WrapException("Could not load '" + file + "'", (Throwable)result.Exception));
            }
        });
    }

    public void renderControls(Graphics2D g, Vector2D canvasSize) {
        long msPassed = Stopwatch.getMillis(sw_strokeani);
        int phase = (int)(Misc.modNegToPos((double)msPassed / 800.0, 1.0) * 12.0);
        g.setColor(Color.BLACK);
        AffineTransform t = this.transform(g, canvasSize);
        AffineTransform t2 = g.getTransform();
        g.translate(this.imgWidth * this.Pivot.X, this.imgHeight * this.Pivot.Y);
        AffineTransform t3 = g.getTransform();
        g.translate(-this.maxWidth * this.Pivot.X, -this.maxHeight * this.Pivot.Y);
        g.drawRect(0, 0, (int)this.maxWidth, (int)this.maxHeight);
        g.setTransform(t2);
        Stroke stroke = g.getStroke();
        g.setStroke(ANIM_STROKE[phase]);
        g.drawRect(0, 0, (int)Math.round(this.imgWidth), (int)Math.round(this.imgHeight));
        g.setStroke(stroke);
        g.setTransform(t3);
        g.fillOval(-3, -3, 6, 6);
        g.setColor(Color.WHITE);
        g.fillOval(-1, -1, 2, 2);
        g.setTransform(t);
    }

    public void render(Graphics2D g, Vector2D canvasSize, boolean goodQuality) {
        Composite c = MiscAWT.setAlpha(g, this.Opacity);
        AffineTransform t = this.transform(g, canvasSize);
        if (this.imageSource == null) {
            Layer.drawPlaceholder(g, this.imgWidth, this.imgHeight);
        } else if (goodQuality) {
            Image image = this.imageSource.getScaledInstance((int)this.imgWidth, (int)this.imgHeight, 4);
            g.drawImage(image, 0, 0, null);
            image.flush();
        } else {
            g.scale(this.imgWidth, this.imgHeight);
            g.drawImage(this.imageSource, 0, 0, 1, 1, null);
        }
        g.setTransform(t);
        g.setComposite(c);
    }

    private AffineTransform transform(Graphics2D g, Vector2D canvasSize) {
        double maxH;
        double minH;
        double heightForMaxWidth;
        double height;
        double widthPerHeightRatio = this.imageSource == null ? (this.Scale.Y == 0.0 ? 0.0 : this.Scale.X / this.Scale.Y) : ((height = (double)this.imageSource.getHeight()) == 0.0 ? 0.0 : (double)this.imageSource.getWidth() / height);
        this.maxWidth = canvasSize.X * this.Scale.X;
        this.maxHeight = canvasSize.Y * this.Scale.Y;
        double widthForMaxHeight = this.maxHeight * widthPerHeightRatio;
        double d = heightForMaxWidth = widthPerHeightRatio == 0.0 ? 0.0 : this.maxWidth / widthPerHeightRatio;
        if (this.maxWidth < widthForMaxHeight) {
            minH = heightForMaxWidth;
            maxH = this.maxHeight;
        } else {
            minH = this.maxHeight;
            maxH = heightForMaxWidth;
        }
        this.imgHeight = minH + this.Fill * (maxH - minH);
        this.imgWidth = this.imgHeight * widthPerHeightRatio;
        AffineTransform t = g.getTransform();
        g.translate(canvasSize.X * this.Position.X, canvasSize.Y * this.Position.Y);
        g.rotate(this.Rotation * (Math.PI * 2));
        g.translate(-this.imgWidth * this.Pivot.X, -this.imgHeight * this.Pivot.Y);
        return t;
    }

    private static void drawPlaceholder(Graphics2D g, double width, double height) {
        g.setColor(Color.RED);
        AffineTransform t = g.getTransform();
        g.scale(width, height);
        g.fillRect(0, 0, 1, 1);
        g.setTransform(t);
        g.setColor(Color.WHITE);
        double sX = width / 10.0;
        double sY = height / 18.0;
        double scale = Math.min(sX, sY);
        g.translate(width * 0.5, height * 0.5);
        g.scale(scale, scale);
        MiscAWT.drawShadowedCenteredString("?", 0, 0, 0, 0, g);
    }

    private void flushImage() {
        if (this.imageSource != null) {
            this.imageSource.flush();
            this.imageSource = null;
        }
    }

    @Override
    public void dispose() {
        this.flushImage();
    }

    public String getExtension() {
        return this.format;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public static final class LoadImageResult {
        public final File File;
        private final byte[] Data;
        private final BufferedImage Image;

        private LoadImageResult(File file, byte[] data, BufferedImage image) {
            this.File = file;
            this.Data = data;
            this.Image = image;
        }
    }
}

