/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.awt.ImageCollection;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.datasource.FileSource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.localizer.Language;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.ui.awt.MiscAWT;
import com.iosoft.propdb.PropDB;
import com.iosoft.watermarker.ErrorEntry;
import com.iosoft.watermarker.ExportFormat;
import com.iosoft.watermarker.Format;
import com.iosoft.watermarker.Layer;
import com.iosoft.watermarker.Template;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.ListModel;

public class DataModel {
    public final TemplatesListModel Templates = new TemplatesListModel();
    private final DefaultListModel<ErrorEntry> exceptions = new DefaultListModel();
    private final MyBoolObservable doingIO = new MyBoolObservable(false);
    public final BoolObservable DoingIO;
    private final MyBoolObservable dirty;
    public final BoolObservable Dirty;
    private final MyObservable<BufferedImage> currentImage;
    public final Observable<BufferedImage> CurrentImage;
    private String defaultTemplateName;
    private final MyObservable<Template> _defaultTemplate;
    public final Observable<Template> DefaultTemplate;
    private final TaskSource<Image> taskSourceIcon;
    public final Task<Image> Icon;
    public final Set<File> DeletedFiles;
    private String language;
    private PropDB propDBSettings;
    private boolean loaded;
    private File currentImageFile;
    private final VTaskSource taskLoadedSource;
    private final File folderSettings;
    private final File fileSettings;
    public final File TemplatesFolder;
    private final Localizer localizer;
    private VTask taskShutDown;

    public DataModel(Localizer localizer) {
        this.DoingIO = this.doingIO.Getter;
        this.dirty = new MyBoolObservable(false);
        this.Dirty = this.dirty.Getter;
        this.currentImage = new MyObservable<Object>(null);
        this.CurrentImage = this.currentImage.Getter;
        this.defaultTemplateName = "";
        this._defaultTemplate = new MyObservable<Object>(null);
        this.DefaultTemplate = this._defaultTemplate.Getter;
        this.taskSourceIcon = new TaskSource();
        this.Icon = (Task)this.taskSourceIcon.getTask();
        this.DeletedFiles = new HashSet<File>();
        this.loaded = false;
        this.taskLoadedSource = new VTaskSource();
        this.folderSettings = new File(".", "Watermarker_data");
        this.fileSettings = new File(this.folderSettings, "settings.dat");
        this.TemplatesFolder = new File(this.folderSettings, "Templates");
        this.localizer = Misc.notNull(localizer);
        MiscAWT.bind(this.Templates, () -> this.dirty.set(true));
        this.dirty.set(false);
    }

    public VTask loadAsync(boolean loadUI, String onlyLoadThisTemplate) {
        this.doingIO.set(true);
        VTask task = VTask.COMPLETED_TASK;
        if (loadUI) {
            task = Async.runAsyncEnforced(() -> {
                ImageCollection imgFlags = new ImageCollection(MiscImg.loadImagePrepared("/res/flags.png", 1), 1, 2);
                BufferedImage imgIcon = MiscImg.loadImage("/res/icon.png");
                return () -> {
                    this.localizer.getOrCreateLanguage("german").setProperty("flagIcon", new ImageIcon(imageCollection.Images[0]));
                    this.localizer.getOrCreateLanguage("english").setProperty("flagIcon", new ImageIcon(imageCollection.Images[1]));
                    this.taskSourceIcon.setResult(imgIcon);
                };
            }).awaitAndContinue(Runnable::run);
        }
        return task.awaitAndContinueTask(() -> Task.runAsync(this.folderSettings::exists)).awaitAndContinueVTask(rootFolderExists -> {
            if (!rootFolderExists.booleanValue()) {
                this.propDBSettings = new PropDB();
                this.load(this.propDBSettings.getRoot());
                return VTask.COMPLETED_TASK;
            }
            return PropDB.loadSourceAsync(new FileSource(this.fileSettings)).awaitAndContinueTask(result -> {
                if (result.Exception == null) {
                    this.propDBSettings = (PropDB)result.Value;
                    this.load(((PropDB)result.Value).getRoot());
                } else {
                    this.addException((Throwable)result.Exception);
                }
                return Async.runAsyncWrap(() -> MiscLINQ.toList(MiscLINQ.filter(new File(this.folderSettings, "Templates").listFiles(), File::isDirectory)));
            }).awaitAndContinueVTask(folders -> {
                if (folders.Exception != null) {
                    this.addException((Throwable)folders.Exception);
                    return VTask.COMPLETED_TASK;
                }
                String onlyLoadThisTemplate2 = !loadUI && onlyLoadThisTemplate == null ? this.defaultTemplateName : onlyLoadThisTemplate;
                return Async.forEach((Iterable)folders.Value, x -> Template.loadAsync(this, x, onlyLoadThisTemplate2), template -> {
                    if (template != null) {
                        this.Templates.addElement((Template)template);
                    }
                });
            });
        }).awaitAndContinue(() -> {
            this._defaultTemplate.set(this.getTemplate(this.defaultTemplateName));
            this.loaded = true;
            this.doingIO.set(false);
            this.taskLoadedSource.setFulfilled();
            this.dirty.set(false);
        });
    }

    private void load(PropDB.Node node) {
        this.defaultTemplateName = node.get("DefaultTemplate", this.defaultTemplateName);
        this.language = node.get("Language", this.language);
        Language selectedLanguage = this.localizer.tryGetLanguage(this.language);
        if (selectedLanguage != null) {
            this.localizer.setDefaultLanguage(selectedLanguage);
        }
    }

    private void save(PropDB.Node node) {
        Template defaultTemplate = this.DefaultTemplate.get();
        node.set("DefaultTemplate", defaultTemplate == null ? "" : defaultTemplate.Name.get());
        node.set("Language", this.language);
    }

    public VTask saveSettingsAsync() {
        if (this.DoingIO.get()) {
            return null;
        }
        try {
            this.doingIO.set(true);
            this.save(this.propDBSettings.getRoot());
            ArrayList<Supplier<Task<IOException>>> tasks = new ArrayList<Supplier<Task<IOException>>>();
            tasks.add(() -> this.propDBSettings.saveAsync(this.fileSettings));
            for (Template template : MiscLINQ.toIterable(this.Templates.elements())) {
                template.save(tasks);
                this.DeletedFiles.remove(template.getFolder());
            }
            for (File file : this.DeletedFiles) {
                tasks.add(() -> Async.runAsyncWrap(() -> MiscIO.forceDelete(file)));
            }
            this.DeletedFiles.clear();
            return Async.forEach(tasks, Supplier::get, exception -> {
                if (exception != null) {
                    this.addException((Throwable)exception);
                }
            }).awaitAndContinue(() -> {
                this.dirty.set(false);
                this.doingIO.set(false);
            });
        }
        catch (RuntimeException e) {
            this.doingIO.set(false);
            throw e;
        }
    }

    public Task<Boolean> createWatermarkedImageAsync(File fileInput, String templateToUse) {
        Template template;
        if (templateToUse == null) {
            template = this.DefaultTemplate.get();
            if (template == null) {
                this.addException(new Exception("No default template '" + this.defaultTemplateName + "' found"));
                return new Task<Object>(null);
            }
        } else {
            template = this.getTemplate(templateToUse);
            if (template == null) {
                this.addException(new Exception("Template '" + templateToUse + "' was not found"));
                return new Task<Object>(null);
            }
        }
        return MiscImg.loadImageAsync(fileInput).awaitAndContinueTask(result -> {
            if (result.Exception != null) {
                this.addException((Throwable)result.Exception);
                return new Task<Boolean>(false);
            }
            String extension = MiscIO.getExtension(fileInput);
            return this.watermarkAndWriteImageAsync((BufferedImage)result.Value, template, fileInput, null, new ExportFormat(extension.equals("JPG") || extension.equals("JPEG") ? Format.Jpg : Format.Png));
        });
    }

    public Task<Boolean> export(Template template, File fileOutput, ExportFormat format) {
        return this.watermarkAndWriteImageAsync(this.CurrentImage.get(), template, this.currentImageFile, fileOutput, format);
    }

    private Task<Boolean> watermarkAndWriteImageAsync(BufferedImage imgSource, Template template, File fileInput, File fileOutputMaybe, ExportFormat format) {
        BufferedImage imgResult = template.watermarkImage(imgSource);
        imgSource.flush();
        Float jpgQuality = template.getJPEGQuality();
        return Async.runAsyncWrap(() -> {
            File fileOutput;
            File folder = fileInput.getParentFile();
            if (fileOutputMaybe != null) {
                fileOutput = fileOutputMaybe;
            } else {
                int indexFileExtensionDot = fileInput.getName().lastIndexOf(46);
                String fileName = (indexFileExtensionDot == -1 ? fileInput : fileInput.getName().substring(0, indexFileExtensionDot)) + "_wm." + format.getExtension();
                fileOutput = new File(folder, fileName);
            }
            if (exportFormat.RealFormat == Format.Jpg && jpgQuality != null) {
                MiscImg.writeJPEG(fileOutput, imgResult, jpgQuality.floatValue());
            } else {
                ImageIO.write((RenderedImage)imgResult, format.getExportFormat(), fileOutput);
            }
        }).awaitAndTranslate(exception -> {
            if (exception != null) {
                this.addException((Throwable)exception);
                return false;
            }
            return true;
        });
    }

    public VTask shutDownAsync() {
        if (this.taskShutDown == null) {
            this.startShutDown();
        }
        return this.taskShutDown;
    }

    private void startShutDown() {
        if (!this.loaded || !this.DoingIO.get()) {
            this.taskShutDown = VTask.COMPLETED_TASK;
        } else {
            VTaskSource taskSource = new VTaskSource();
            this.DoingIO.await(x -> !x, taskSource::setFulfilled);
            this.taskShutDown = (VTask)taskSource.getTask();
        }
    }

    private Template getTemplate(String name) {
        return MiscLINQ.firstOrDefault(this.Templates.elements(), x -> x.Name.get().equals(name));
    }

    public void setDefaultTemplate(Template template) {
        if (template != this.DefaultTemplate.get()) {
            this._defaultTemplate.set(template);
            this.setDirty();
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public VTask waitForLoadedAsync() {
        return (VTask)this.taskLoadedSource.getTask();
    }

    public ListModel<ErrorEntry> getErrorList() {
        return this.exceptions;
    }

    public void addException(Throwable throwable) {
        this.exceptions.addElement(new ErrorEntry(throwable));
    }

    public void openImage(File file) {
        this.currentImageFile = file;
        try {
            this.currentImage.set(file == null ? null : MiscImg.loadImage(file));
        }
        catch (IOException e) {
            this.addException(e);
        }
    }

    public void setDirty() {
        this.dirty.set(true);
    }

    public File getCurrentImageFile() {
        return this.currentImageFile;
    }

    public void setLanguage(Language language) {
        String newLanguage = language.Name;
        if (!newLanguage.equals(this.language)) {
            this.language = language.Name;
            this.setDirty();
        }
    }

    public class TemplatesListModel
    extends DefaultListModel<Template> {
        private static final long serialVersionUID = 1L;

        public boolean update(Template template) {
            int index = this.indexOf(template);
            if (index == -1) {
                return false;
            }
            this.fireContentsChanged(this, index, index);
            return true;
        }

        @Override
        public void addElement(Template element) {
            super.addElement(element);
            DataModel.this.setDirty();
        }

        public boolean removeElement(Template obj) {
            File templateFolder;
            DataModel.this.setDirty();
            if (obj == DataModel.this.DefaultTemplate.get()) {
                DataModel.this.setDefaultTemplate(null);
            }
            if ((templateFolder = obj.getFolder()) != null) {
                for (Layer layer : obj.Objects) {
                    File imageFile = layer.getImageFile();
                    if (imageFile == null) continue;
                    DataModel.this.DeletedFiles.add(imageFile);
                }
                DataModel.this.DeletedFiles.add(templateFolder);
            }
            return super.removeElement(obj);
        }
    }
}

