/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.watermarker;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.WrapException;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Compatibility {
    private static final Method mtdGetMenuShortcutKeyMaskEx;

    static {
        Method method = null;
        try {
            method = Toolkit.class.getMethod("getMenuShortcutKeyMaskEx", new Class[0]);
            Log.Developer.info("Java 10+ detected");
        }
        catch (NoSuchMethodException | SecurityException e) {
            Log.Developer.info("Java 8/9 detected");
        }
        mtdGetMenuShortcutKeyMaskEx = method;
    }

    private Compatibility() {
    }

    public static int getMenuShortcutKeyMaskEx(Toolkit toolkit) throws HeadlessException {
        if (mtdGetMenuShortcutKeyMaskEx == null) {
            return toolkit.getMenuShortcutKeyMask();
        }
        try {
            return (Integer)mtdGetMenuShortcutKeyMaskEx.invoke((Object)toolkit, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof HeadlessException) {
                throw (HeadlessException)cause;
            }
            throw new WrapException(e);
        }
    }
}

