/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.propdb;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.datasource.MemorySource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.math.Vector2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class PropDB {
    private Node root = new Node("Root");
    private boolean echo = false;

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public static PropDB loadSource(IDataSource source) throws IOException {
        Misc.notNull(source);
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = source.openBufferedStream();){
            return PropDB.loadStream(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Task<FailableResult<PropDB, IOException>> loadSourceAsync(IDataSource source) {
        Misc.notNull(source);
        return source.loadAsync(false).awaitAndContinueTask(result -> {
            if (result.Exception != null) {
                return new Task(new FailableResult((IOException)result.Exception));
            }
            return Async.runAsyncWrap(() -> PropDB.loadSource(new MemorySource((byte[])failableResult.Value)));
        });
    }

    public static PropDB loadStream(InputStream in) throws IOException {
        return PropDB.loadStream(in, false);
    }

    /*
     * Loose catch block
     */
    public static PropDB loadStream(InputStream in, boolean tolerant) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);){
            PropDB propDB;
            BufferedReader br;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var6_9 = null;
                br = new BufferedReader(isr);
                propDB = PropDB.loadReader(br, tolerant);
                if (br == null) break block19;
                br.close();
            }
            return propDB;
            {
                catch (Throwable throwable3) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static PropDB loadReader(BufferedReader reader, boolean tolerant) throws IOException {
        PropDB propDB = new PropDB();
        propDB._loadReader(reader, tolerant);
        return propDB;
    }

    private void _loadReader(BufferedReader reader, boolean tolerant) throws IOException {
        Mode mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
        Node node = null;
        StringBuilder buffer = new StringBuilder();
        boolean lastWasSlash = false;
        boolean canOpen = false;
        boolean nl = false;
        this.root = null;
        try {
            block18: while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    throw new EOFException("end of stream reached");
                }
                if (nl) {
                    line = "\n" + line;
                } else {
                    nl = true;
                }
                int i = 0;
                while (true) {
                    if (i >= line.length()) continue block18;
                    char c = line.charAt(i);
                    block1 : switch (mode) {
                        case FIND_NODE_OR_OPEN_OR_CLOSE: {
                            if (PropDB.isValidNameChar(c)) {
                                if (canOpen) {
                                    canOpen = false;
                                    node = node.getParentNode();
                                }
                                buffer.append(c);
                                mode = Mode.FIND_OPEN_OR_EQUALS_OR_CLOSE;
                                break;
                            }
                            if (c == '{') {
                                if (!canOpen) break;
                                canOpen = false;
                                mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                                break;
                            }
                            if (c != '}') break;
                            if (canOpen) {
                                canOpen = false;
                                node = node.getParentNode();
                            }
                            if (node == null) {
                                throw new IOException("closing node although node == null");
                            }
                            Node temp = node;
                            node = node.getParentNode();
                            mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                            if (node != null) break;
                            if (temp.getName().equals("Root") || tolerant) {
                                this.root = temp;
                            }
                            throw new EOFException("root closed");
                        }
                        case FIND_OPEN_OR_EQUALS_OR_CLOSE: {
                            Node temp;
                            if (PropDB.isValidNameChar(c)) {
                                if (buffer.length() == 0) {
                                    if (this.echo) {
                                        System.out.println("Back from " + node.nodeName + "...");
                                    }
                                    node = node.getParentNode();
                                }
                                buffer.append(c);
                                break;
                            }
                            if (buffer.length() > 0) {
                                if (node == null) {
                                    if (this.echo) {
                                        System.out.println("add2null " + buffer.toString() + "...");
                                    }
                                    node = new Node(buffer.toString());
                                } else {
                                    if (this.echo) {
                                        System.out.println("add2" + node.nodeName + " " + buffer.toString() + "...");
                                    }
                                    node = node.addSameName(buffer.toString());
                                }
                                buffer.setLength(0);
                            }
                            switch (c) {
                                case '=': {
                                    mode = Mode.FIND_QUOTES_OPEN;
                                    break block1;
                                }
                                case '{': {
                                    mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                                    break block1;
                                }
                                case '}': {
                                    node = node.getParentNode();
                                    if (node == null) {
                                        throw new IOException("closing node although node == null");
                                    }
                                    temp = node;
                                    node = node.getParentNode();
                                    mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                                    if (node != null) break block1;
                                    if (temp.getName().equals("Root") || tolerant) {
                                        this.root = temp;
                                    }
                                    throw new EOFException("root closed");
                                }
                            }
                            break;
                        }
                        case FIND_QUOTES_OPEN: {
                            if (c != '\'') break;
                            mode = Mode.FIND_QUOTES_CLOSE;
                            break;
                        }
                        case FIND_QUOTES_CLOSE: {
                            switch (c) {
                                case '\\': {
                                    if (lastWasSlash) {
                                        lastWasSlash = false;
                                        buffer.append('\\');
                                        break block1;
                                    }
                                    lastWasSlash = true;
                                    break block1;
                                }
                                case '\'': {
                                    if (lastWasSlash) {
                                        lastWasSlash = false;
                                        buffer.append('\'');
                                        break block1;
                                    }
                                    node.setValue(buffer.toString());
                                    buffer.setLength(0);
                                    mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                                    canOpen = true;
                                    break block1;
                                }
                                case 'n': {
                                    if (lastWasSlash) {
                                        lastWasSlash = false;
                                        buffer.append('\n');
                                        break block1;
                                    }
                                    buffer.append(c);
                                    break block1;
                                }
                            }
                            buffer.append(c);
                            lastWasSlash = false;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (EOFException e) {
            if (node != null || this.root == null) {
                throw new IOException("PropDB incomplete");
            }
            return;
        }
    }

    public void clear() {
        this.root = new Node("Root");
    }

    public void listFromRoot() {
        if (this.root != null) {
            this.root.listTree("");
        } else if (this.echo) {
            System.out.println("PropDB error: PropDB not loaded! -> No listing available");
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void save(File file) throws IOException {
        this.save(file, this.serialize());
    }

    private void save(File file, String text) throws IOException {
        Misc.notNull(file, "file");
        Misc.notNull(text, "text");
        File parent = file.getParentFile();
        if (parent != null) {
            MiscIO.mkdirs(parent);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter bw = MiscIO.openUTF8Writer(file);){
            bw.write(text);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.echo) {
            System.out.println("PropDB: '" + file.getAbsolutePath() + "' saved!");
        }
    }

    public Task<IOException> saveAsync(File file) {
        Misc.notNull(file);
        String serialized = this.serialize();
        return Task.runAsync(() -> {
            try {
                this.save(file, serialized);
                return null;
            }
            catch (IOException e) {
                return e;
            }
        });
    }

    /*
     * Loose catch block
     */
    public static PropDB deserialize(String input, boolean tolerant) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (StringReader stringReader = new StringReader(input);){
            PropDB propDB;
            BufferedReader bufferedReader;
            Throwable throwable2;
            block19: {
                throwable2 = null;
                Object var6_9 = null;
                bufferedReader = new BufferedReader(stringReader);
                propDB = PropDB.loadReader(bufferedReader, tolerant);
                if (bufferedReader == null) break block19;
                bufferedReader.close();
            }
            return propDB;
            {
                catch (Throwable throwable3) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        this.root.save(sb, "", true);
        return sb.toString();
    }

    public byte[] pack() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.packStream(out);
                return out.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("PropDB::pack threw", e);
        }
    }

    public void packStream(OutputStream out) throws IOException {
        if (this.root != null) {
            this.root.pack(out);
        } else {
            new Node("Root").pack(out);
        }
    }

    public void savePacked(File file) throws IOException {
        this.savePacked(file, "");
    }

    public void savePacked(File file, String sig) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            MiscIO.writeCString(bos, sig);
            this.packStream(bos);
            if (this.echo) {
                System.out.println("PropDB packed: '" + file + "' saved!");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static PropDB unpack(byte[] data) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            return PropDB.unpackStream(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void unpack(File file) throws IOException {
        this.unpack(file, "");
    }

    public void unpack(File file, String sig) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            String s = MiscIO.readCString(bis, sig.length());
            if (!s.equals(sig)) {
                throw new IOException("Wrong sig! Should be: " + sig + " Is: " + s);
            }
            PropDB.unpackStream(bis);
            if (this.echo) {
                System.out.println("PropDB unpacked: '" + file + "' loaded!");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static PropDB unpackStream(InputStream in) throws IOException {
        PropDB propDB = new PropDB();
        propDB._unpackStream(in);
        return propDB;
    }

    private void _unpackStream(InputStream in) throws IOException {
        if (this.root == null) {
            this.clear();
        }
        this.root = Node.unpack(in);
    }

    public static boolean isValidNameChar(char c) {
        return c != '=' && !Character.isWhitespace(c) && c != '{' && c != '}';
    }

    private static enum Mode {
        FIND_NODE_OR_OPEN_OR_CLOSE,
        FIND_OPEN_OR_EQUALS_OR_CLOSE,
        FIND_QUOTES_OPEN,
        FIND_QUOTES_CLOSE;

    }

    public static class Node
    implements Iterable<Node> {
        private Type type;
        private Node parent;
        private String nodeName;
        private int valInt;
        private long valLong;
        private float valFloat;
        private double valDouble;
        private String valStr;
        private boolean valBool;
        private byte[] valBin = Misc.EMPTYBYTES;
        private final List<Node> nodes = new ArrayList<Node>();
        private final Map<String, Node> nodeMap = new HashMap<String, Node>();

        public Node(String name) {
            Misc.notNull(name);
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be empty");
            }
            this.type = Type.T_NULL;
            this.nodeName = name;
        }

        public String getName() {
            return this.nodeName;
        }

        public String getAsString() {
            switch (this.type) {
                case T_INT: {
                    return "" + this.valInt;
                }
                case T_LONG: {
                    return "" + this.valLong;
                }
                case T_FLOAT: {
                    return "" + this.valFloat;
                }
                case T_DOUBLE: {
                    return "" + this.valDouble;
                }
                case T_STR: {
                    return this.valStr;
                }
                case T_BOOL: {
                    return "" + (this.valBool ? 1 : 0);
                }
                case T_BIN: {
                    return Misc.base64encode(this.valBin);
                }
            }
            return "";
        }

        public boolean getAsBoolean() {
            return this.getAsBoolean(false);
        }

        public boolean getAsBoolean(boolean defVal) {
            switch (this.type) {
                case T_INT: {
                    return this.valInt == 1;
                }
                case T_LONG: {
                    return this.valLong == 1L;
                }
                case T_FLOAT: {
                    return this.valFloat == 0.0f;
                }
                case T_DOUBLE: {
                    return this.valDouble == 1.0;
                }
                case T_STR: {
                    return this.valStr.equals("1");
                }
                case T_BOOL: {
                    return this.valBool;
                }
                case T_BIN: {
                    return this.valBin != null && this.valBin.length > 0 && this.valBin[0] != 0;
                }
            }
            return defVal;
        }

        public int getAsInt() {
            return this.getAsInt(0);
        }

        public int getAsInt(int defVal) {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return (int)this.valLong;
                }
                case T_FLOAT: {
                    return (int)this.valFloat;
                }
                case T_DOUBLE: {
                    return (int)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsInt(this.valStr, defVal);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractInt(this.valBin, 0);
                }
            }
            return defVal;
        }

        public char getAsUShort() {
            return this.getAsUShort('\u0000');
        }

        public char getAsUShort(char value) {
            return (char)Misc.clamp(this.getAsInt(value), 0, 65535);
        }

        public long getAsLong() {
            return this.getAsLong(0L);
        }

        public long getAsLong(long defVal) {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return (long)this.valFloat;
                }
                case T_DOUBLE: {
                    return (long)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsLong(this.valStr, 0L);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractLong(this.valBin, 0);
                }
            }
            return defVal;
        }

        public float getAsFloat() {
            return this.getAsFloat(0.0f);
        }

        public float getAsFloat(float defVal) {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return this.valFloat;
                }
                case T_DOUBLE: {
                    return (float)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsFloat(this.valStr, 0.0f);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractFloat(this.valBin, 0);
                }
            }
            return defVal;
        }

        public double getAsDouble() {
            return this.getAsDouble(0.0);
        }

        public double getAsDouble(double defVal) {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return this.valFloat;
                }
                case T_DOUBLE: {
                    return this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsDouble(this.valStr, 0.0);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractDouble(this.valBin, 0);
                }
            }
            return defVal;
        }

        public String get(String childName, String defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsString();
        }

        public boolean get(String childName, boolean defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsBoolean();
        }

        public int get(String childName, int defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsInt();
        }

        public char get(String childName, char defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsUShort();
        }

        public long get(String childName, long defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsLong();
        }

        public float get(String childName, float defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsFloat();
        }

        public double get(String childName, double defaultValue) {
            Node node = this.tryGetChild(childName);
            if (node == null) {
                return defaultValue;
            }
            return node.getAsDouble();
        }

        public void get(String childName, Vector2D vector) {
            Node node = this.tryGetChild(childName);
            if (node != null) {
                String text = node.getAsString();
                int index = text.indexOf(124);
                if (index == -1) {
                    vector.X = Misc.getAsDouble(text, vector.X);
                } else {
                    vector.X = Misc.getAsDouble(text.substring(0, index), vector.X);
                    vector.Y = Misc.getAsDouble(text.substring(index + 1), vector.Y);
                }
            }
        }

        public void set(String childName, String value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, boolean value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, int value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, char value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, long value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, float value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, double value) {
            this.add(childName).setValue(value);
        }

        public void set(String childName, Vector2D vector) {
            this.set(childName, vector.X + "|" + vector.Y);
        }

        public void listTree(String treestr) {
            String name = String.valueOf(treestr) + (treestr.equals("") ? "" : ".") + this.getName();
            System.out.println(String.valueOf(name) + " = '" + this.getAsString() + "'");
            int i = 0;
            int size = this.nodes.size();
            while (i < size) {
                this.nodes.get(i).listTree(name);
                ++i;
            }
        }

        public boolean removeAllChildren(String childName) {
            boolean result = this.nodes.removeIf(x -> x.getName().equals(childName));
            this.nodeMap.remove(this.nodeName);
            return result;
        }

        public Node tryGetChild(String nodename) {
            return this.nodeMap.get(nodename);
        }

        public Node getChild(String nodename) {
            Node node = this.tryGetChild(nodename);
            if (node == null) {
                throw new IllegalArgumentException("Child '" + nodename + "' not found in '" + this.getName() + "'");
            }
            return node;
        }

        public Node getOrAddChild(String nodename, String value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node getOrAddChild(String nodename, boolean value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node getOrAddChild(String nodename, int value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node getOrAddChild(String nodename, long value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node getOrAddChild(String nodename, float value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node getOrAddChild(String nodename, double value) {
            Node node = this.tryGetChild(nodename);
            if (node != null) {
                return node;
            }
            Node newnode = new Node(nodename);
            newnode.setValue(value);
            return this.add(newnode);
        }

        public Node add(String name) {
            Node node = this.tryGetChild(name);
            return node == null ? this.add(new Node(name)) : node;
        }

        public Node add(Node node) {
            Node temp = this.tryGetChild(node.getName());
            node = temp == null ? this.addSameName(node) : temp;
            return node;
        }

        public Node addSameName(Node node) {
            node.setParentNode(this);
            this.nodes.add(node);
            this.nodeMap.putIfAbsent(node.getName(), node);
            return node;
        }

        public Node addSameName(String name) {
            Node node = new Node(name);
            return this.addSameName(node);
        }

        protected void checkNull(boolean save) {
            switch (this.type) {
                case T_INT: {
                    break;
                }
                case T_LONG: {
                    break;
                }
                case T_FLOAT: {
                    break;
                }
                case T_DOUBLE: {
                    break;
                }
                case T_STR: {
                    if (!this.valStr.equals("")) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_BOOL: {
                    break;
                }
                case T_BIN: {
                    if (this.valBin != null && this.valBin.length != 0) break;
                    this.type = Type.T_NULL;
                    break;
                }
            }
        }

        public void setValue(String val) {
            this.setValue(val, false);
        }

        public void setValue(String val, boolean check) {
            this.valStr = val;
            this.type = Type.T_STR;
            if (!check) {
                return;
            }
            boolean is1 = val.equals("1");
            if (is1 || val.equals("0")) {
                this.setValue(is1);
            } else if (("" + Misc.getAsLong(val)).equals(val)) {
                if (("" + Misc.getAsInt(val)).equals(val)) {
                    this.setValue(Misc.getAsInt(val));
                } else {
                    this.setValue(Misc.getAsLong(val));
                }
            } else if (("" + Misc.getAsDouble(val)).equals(val)) {
                if (("" + Misc.getAsFloat(val)).equals(val)) {
                    this.setValue(Misc.getAsFloat(val));
                } else {
                    this.setValue(Misc.getAsDouble(val));
                }
            }
        }

        public void setValue(boolean val) {
            this.valBool = val;
            this.type = Type.T_BOOL;
        }

        public void setValue(int val) {
            this.valInt = val;
            this.type = Type.T_INT;
        }

        public void setValue(long val) {
            this.valLong = val;
            this.type = Type.T_LONG;
        }

        public void setValue(float val) {
            this.valFloat = val;
            this.type = Type.T_FLOAT;
        }

        public void setValue(double val) {
            this.valDouble = val;
            this.type = Type.T_DOUBLE;
        }

        public void setValue(byte[] val) {
            this.valBin = Arrays.copyOf(val, val.length);
            this.type = Type.T_BIN;
        }

        public void setValue(Number val) {
            if (val instanceof Integer || val instanceof Short) {
                this.setValue(val.intValue());
            } else if (val instanceof Long) {
                this.setValue(val.longValue());
            } else if (val instanceof Double) {
                this.setValue(val.doubleValue());
            } else if (val instanceof Float) {
                this.setValue(val.floatValue());
            }
        }

        public Node getParentNode() {
            return this.parent;
        }

        private void setParentNode(Node newparent) {
            this.parent = newparent;
        }

        public String getFormattedValue() {
            return this.getAsString().replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n");
        }

        public void save(StringBuilder sb, String prefix, boolean isRoot) {
            sb.append(prefix);
            sb.append(this.nodeName);
            if (this.type != Type.T_NULL) {
                sb.append(" = '");
                sb.append(this.getFormattedValue());
                sb.append('\'');
            } else if (this.nodes.isEmpty() && !isRoot) {
                sb.append(" = ''");
            }
            int iC = this.nodes.size();
            if (iC > 0 || isRoot) {
                sb.append(" {\r\n");
                String newPrefix = String.valueOf(prefix) + "\t";
                for (Node node : this.nodes) {
                    node.save(sb, newPrefix, false);
                }
                sb.append(prefix);
                sb.append('}');
            }
            sb.append("\r\n");
        }

        public void pack(OutputStream out) throws IOException {
            this.checkNull(false);
            boolean[] bools = new boolean[8];
            int len = Math.min(31, this.nodeName.length());
            Misc.writeBitnumber(this.type.ordinal(), bools, 0, 3);
            Misc.writeBitnumber(len, bools, 3, 5);
            out.write(Byte.toUnsignedInt(Misc.buildByte(bools)));
            MiscIO.writeCString(out, this.nodeName, len);
            switch (this.type) {
                case T_INT: {
                    out.write(Misc.intToBytes(this.valInt));
                    break;
                }
                case T_LONG: {
                    out.write(Misc.longToBytes(this.valLong));
                    break;
                }
                case T_FLOAT: {
                    out.write(Misc.floatToBytes(this.valFloat));
                    break;
                }
                case T_DOUBLE: {
                    out.write(Misc.doubleToBytes(this.valDouble));
                    break;
                }
                case T_STR: {
                    byte[] buffer = this.valStr.getBytes(StandardCharsets.UTF_8);
                    int length = buffer.length + 1;
                    int maxLength = 65535;
                    if (length > 65535) {
                        length = 65535;
                        Log.Developer.warning("PropDB::pack: truncated a very long string (" + this.nodeName + ")");
                    }
                    out.write(Misc.intToBytes(length, 2));
                    out.write(0);
                    out.write(buffer, 0, length - 1);
                    break;
                }
                case T_BOOL: {
                    out.write(this.valBool ? 1 : 0);
                    break;
                }
                case T_BIN: {
                    out.write(Misc.intToBytes(this.valBin.length));
                    out.write(this.valBin);
                    break;
                }
            }
            out.write(Misc.intToBytes(this.nodes.size()));
            for (Node node : this.nodes) {
                node.pack(out);
            }
        }

        public static Node unpack(InputStream in) throws IOException {
            boolean[] bools = Misc.readByte((byte)MiscIO.read(in));
            int length = Misc.getBitnumber(bools, 3, 5);
            String name = MiscIO.readString(in, length);
            Node node = new Node(name);
            int typeId = Misc.getBitnumber(bools, 0, 3);
            if (typeId < 0 || typeId >= Type.VALUES.length) {
                throw new IOException("Invalid type '" + typeId + "'");
            }
            switch (Type.VALUES[typeId]) {
                case T_INT: {
                    node.setValue(MiscIO.getInt(in));
                    break;
                }
                case T_LONG: {
                    node.setValue(MiscIO.getLong(in));
                    break;
                }
                case T_FLOAT: {
                    node.setValue(MiscIO.getFloat(in));
                    break;
                }
                case T_DOUBLE: {
                    node.setValue(MiscIO.getDouble(in));
                    break;
                }
                case T_STR: {
                    length = MiscIO.getInt(in, 2);
                    if (length > 0) {
                        MiscIO.read(in);
                        node.setValue(new String(MiscIO.readFully(in, length - 1), StandardCharsets.UTF_8));
                        break;
                    }
                    length = MiscIO.getInt(in, 2);
                    node.setValue(MiscIO.readString(in, length));
                    break;
                }
                case T_BOOL: {
                    node.setValue(MiscIO.read(in) == 1);
                    break;
                }
                case T_BIN: {
                    node.setValue(MiscIO.readFully(in, MiscIO.getInt(in)));
                    break;
                }
            }
            int iC = MiscIO.getInt(in);
            int i = 0;
            while (i < iC) {
                node.addSameName(Node.unpack(in));
                ++i;
            }
            return node;
        }

        @Override
        public Iterator<Node> iterator() {
            final Iterator<Node> actualIterator = this.nodes.iterator();
            return new Iterator<Node>(){
                private Node lastNode;

                @Override
                public Node next() {
                    this.lastNode = (Node)actualIterator.next();
                    return this.lastNode;
                }

                @Override
                public boolean hasNext() {
                    return actualIterator.hasNext();
                }

                @Override
                public void remove() {
                    actualIterator.remove();
                    if (this.lastNode != null) {
                        Node newNode = MiscLINQ.firstOrDefault(nodes, x -> x.getName().equals(this.lastNode.getName()));
                        if (newNode == null) {
                            nodeMap.remove(this.lastNode.getName());
                        } else {
                            nodeMap.put(this.lastNode.getName(), newNode);
                        }
                    }
                }
            };
        }

        public Stream<Node> stream() {
            return this.nodes.stream();
        }

        public int size() {
            return this.nodes.size();
        }

        public void clear() {
            this.nodes.clear();
            this.nodeMap.clear();
        }

        public void sort(Comparator<Node> comparator) {
            this.nodes.sort(comparator);
        }

        private static enum Type {
            T_NULL,
            T_INT,
            T_LONG,
            T_FLOAT,
            T_DOUBLE,
            T_STR,
            T_BOOL,
            T_BIN;

            static final Type[] VALUES;

            static {
                VALUES = Type.values();
            }
        }
    }
}

