/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskWorker;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.web.BytesResponse;
import com.iosoft.helpers.web.BytesResponseReader;
import com.iosoft.helpers.web.CancelWrapper;
import com.iosoft.helpers.web.IResponseReader;
import com.iosoft.helpers.web.StringResponse;
import com.iosoft.helpers.web.StringResponseReader;
import com.iosoft.helpers.web.WebResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;

public final class MiscWeb {
    private static final Object _lockSslWarmup = new Object();
    private static boolean _sslWarmedUp;
    public static final double DEFAULT_TIMEOUT_SECONDS = 30.0;
    public static final double NO_TIMEOUT = 0.0;
    public static final int NO_LIMIT = -1;

    private MiscWeb() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureSSLWarmupIsDone() {
        Object object = _lockSslWarmup;
        synchronized (object) {
            if (_sslWarmedUp) {
                return;
            }
            _sslWarmedUp = true;
            Misc.runUninterruptable("Warmup SSL hack", () -> {
                block5: {
                    URLConnection connection = null;
                    try {
                        try {
                            Log.General.info("Warming up SSL");
                            connection = new URL("https://localhost").openConnection();
                            connection.setConnectTimeout(100);
                            connection.setReadTimeout(100);
                            connection.setUseCaches(false);
                        }
                        catch (IOException iOException) {
                            MiscWeb.tryClose(connection);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        MiscWeb.tryClose(connection);
                        throw throwable;
                    }
                    MiscWeb.tryClose(connection);
                }
            });
        }
    }

    public static StringResponse getFirstLine(String url) {
        return MiscWeb.getFirstLine(url, 30.0);
    }

    public static StringResponse getFirstLine(String url, double sec_timeout) {
        return MiscWeb.getFirstLine(url, sec_timeout, -1);
    }

    public static StringResponse getFirstLine(String url, double sec_timeout, int maxSize) {
        return MiscWeb.getText(url, sec_timeout, maxSize, 1);
    }

    public static Task<StringResponse> getFirstLineAsync(String url) {
        return MiscWeb.getFirstLineAsync(url, -1);
    }

    public static Task<StringResponse> getFirstLineAsync(String url, int maxSize) {
        return MiscWeb.getFirstLineAsync(url, 30.0, maxSize);
    }

    public static Task<StringResponse> getFirstLineAsync(String url, double sec_timeout, int maxSize) {
        return MiscWeb.getTextAsync(url, sec_timeout, maxSize, 1, false);
    }

    public static StringResponse getText(String url) {
        return MiscWeb.getText(url, 30.0);
    }

    public static StringResponse getText(String url, boolean allowError) {
        return MiscWeb.getText(url, 30.0, -1, -1, allowError);
    }

    public static StringResponse getText(String url, double sec_timeout) {
        return MiscWeb.getText(url, sec_timeout, -1);
    }

    public static StringResponse getText(String url, double sec_timeout, int maxSize) {
        return MiscWeb.getText(url, sec_timeout, maxSize, -1);
    }

    public static StringResponse getText(String url, double sec_timeout, int maxSize, int maxLines) {
        return MiscWeb.getText(url, sec_timeout, maxSize, maxLines, false);
    }

    public static StringResponse getText(String url, double sec_timeout, int maxSize, int maxLines, boolean allowError) {
        return MiscWeb.getText(url, maxSize, maxLines, sec_timeout, sec_timeout <= 0.0 ? null : reader -> Misc.createCloseTimeout(reader, sec_timeout, true)::interrupt, allowError);
    }

    public static StringResponse getText(String url, int maxChars, int maxLines, double sec_timeoutConnect, Function<IDisposable, IDisposable> autoCloser, boolean allowError) {
        return MiscWeb.get(url, sec_timeoutConnect, autoCloser, new StringResponseReader(maxChars, maxLines, allowError));
    }

    public static BytesResponse getBytes(String url, int maxSize, boolean mustBeComplete, boolean allowError, double sec_timeoutConnect, Function<IDisposable, IDisposable> autoCloser, DoubleConsumer progressUpdate) {
        return MiscWeb.get(url, sec_timeoutConnect, autoCloser, new BytesResponseReader(maxSize, mustBeComplete, allowError, progressUpdate));
    }

    public static <T extends WebResponse<?>> T get(String url, double sec_timeoutConnect, Function<IDisposable, IDisposable> autoCloser, IResponseReader<T> responseReader) {
        return MiscWeb.get(url, null, sec_timeoutConnect, autoCloser, responseReader);
    }

    public static <T extends WebResponse<?>> T get(URL url, double sec_timeoutConnect, Function<IDisposable, IDisposable> autoCloser, IResponseReader<T> responseReader) {
        return MiscWeb.get(null, url, sec_timeoutConnect, autoCloser, responseReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends WebResponse<?>> T get(String urlS, URL url, double sec_timeoutConnect, Function<IDisposable, IDisposable> autoCloser, IResponseReader<T> responseReader) {
        Mutable<TimeoutState> timeoutState;
        IOException error;
        block19: {
            responseReader.onStart();
            MiscWeb.ensureSSLWarmupIsDone();
            IDisposable autoCloserKiller = null;
            error = null;
            timeoutState = new Mutable<TimeoutState>(TimeoutState.NoTimeout);
            Consumer<TimeoutState> trySetTimeoutState = x -> {
                Mutable mutable2 = timeoutState;
                synchronized (mutable2) {
                    if (mutable.Value == TimeoutState.NoTimeout) {
                        mutable.Value = x;
                    }
                }
            };
            URLConnection connection = null;
            CancelWrapper cancelWrapper = new CancelWrapper();
            try {
                try {
                    connection = (url == null ? new URL(urlS) : url).openConnection();
                    if (sec_timeoutConnect > 0.0) {
                        int millis = Misc.secondsToMillis(sec_timeoutConnect);
                        connection.setConnectTimeout(millis);
                        connection.setReadTimeout(millis);
                    }
                    connection.setUseCaches(false);
                    connection.setRequestProperty("User-Agent", "Java");
                    connection.setRequestProperty("Accept", "*/*");
                    connection.setRequestProperty("Connection", "close");
                    URLConnection immutConnection = connection;
                    if (autoCloser != null) {
                        autoCloserKiller = autoCloser.apply(() -> {
                            IDisposable cancellor;
                            CancelWrapper cancelWrapper2 = cancelWrapper;
                            synchronized (cancelWrapper2) {
                                cancelWrapper.Canceled = true;
                                cancellor = cancelWrapper.Disposable;
                            }
                            MiscWeb.tryClose(immutConnection);
                            trySetTimeoutState.accept(TimeoutState.TimedOut);
                            Misc.forceClose(cancellor);
                        });
                    }
                    if (!cancelWrapper.wasCanceledSync()) {
                        connection.connect();
                        responseReader.read(connection, cancelWrapper);
                    }
                }
                catch (Exception ex) {
                    trySetTimeoutState.accept(ex instanceof SocketTimeoutException ? TimeoutState.TimedOut : TimeoutState.AlreadyFailed);
                    boolean wasCanceled = cancelWrapper.wasCanceledSync();
                    if (wasCanceled) {
                        Log.Developer.warning("Web get (canceled) threw " + ex);
                    } else {
                        Log.Developer.error("Web get threw " + ex);
                    }
                    if (ex instanceof IOException) {
                        error = (IOException)ex;
                    } else {
                        if (!wasCanceled) {
                            ex.printStackTrace();
                        }
                        error = new IOException("Internal error", ex);
                    }
                    MiscWeb.tryClose(connection);
                    if (autoCloserKiller != null) {
                        autoCloserKiller.dispose();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                MiscWeb.tryClose(connection);
                if (autoCloserKiller != null) {
                    autoCloserKiller.dispose();
                }
                throw throwable;
            }
            MiscWeb.tryClose(connection);
            if (autoCloserKiller != null) {
                autoCloserKiller.dispose();
            }
        }
        Mutable<TimeoutState> mutable = timeoutState;
        synchronized (mutable) {
            return responseReader.returnResult(error, timeoutState.Value == TimeoutState.TimedOut, false);
        }
    }

    public static boolean tryClose(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
            return true;
        }
        return false;
    }

    public static Task<StringResponse> getTextAsync(String url) {
        return MiscWeb.getTextAsync(url, 30.0);
    }

    public static Task<StringResponse> getTextAsync(String url, double sec_timeout) {
        return MiscWeb.getTextAsync(url, sec_timeout, -1);
    }

    public static Task<StringResponse> getTextAsync(String url, double sec_timeout, int maxChars) {
        return MiscWeb.getTextAsync(url, sec_timeout, maxChars, -1, false);
    }

    public static Task<StringResponse> getTextAsync(String url, double sec_timeout, int maxChars, int maxLines, boolean allowError) {
        return MiscWeb.getAsync(url, sec_timeout, new StringResponseReader(maxChars, maxLines, allowError));
    }

    public static Task<BytesResponse> getBytesAsync(String url) {
        return MiscWeb.getBytesAsync(url, 30.0, -1, false, false, null);
    }

    public static Task<BytesResponse> getBytesAsync(String url, double sec_timeout, int maxSize, boolean allowIncomplete, boolean allowError, final DoubleConsumer progressUpdate) {
        DoubleConsumer threadsafeProgressUpdate = null;
        final Mutable mutTask = new Mutable();
        if (progressUpdate != null) {
            final Dispatcher dispatcher = Dispatcher.getForCurrentThread();
            threadsafeProgressUpdate = new DoubleConsumer(){
                private double _progress;
                private boolean _dispatched;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(double newProgress) {
                    Mutable mutable = mutTask;
                    synchronized (mutable) {
                        this._progress = newProgress;
                        if (this._dispatched) {
                            return;
                        }
                        this._dispatched = true;
                    }
                    dispatcher.dispatch(() -> {
                        double progress;
                        if (!((Task)mutable.Value).isRunning()) {
                            return;
                        }
                        Mutable mutable2 = mutTask;
                        synchronized (mutable2) {
                            progress = this._progress;
                            this._dispatched = false;
                        }
                        progressUpdate.accept(progress);
                    });
                }
            };
        }
        mutTask.Value = MiscWeb.getAsync(url, sec_timeout, new BytesResponseReader(maxSize, allowIncomplete, allowError, threadsafeProgressUpdate));
        return (Task)mutTask.Value;
    }

    public static <T extends WebResponse<?>> Task<T> getAsync(final String url, final double sec_timeout, final IResponseReader<T> responseReader) {
        final Mutable myTask = new Mutable();
        myTask.Value = new TaskWorker<T>("Async web get"){
            VTask taskDelay;
            AutoCloseable autoCloseable;
            boolean cancelled;
            {
                super($anonymous0);
                this.cancelled = false;
                if (d <= 0.0) {
                    this.taskDelay = null;
                } else {
                    this.taskDelay = VTask.delay(d);
                    this.taskDelay.await(() -> {
                        this.taskDelay = null;
                        this.cancelDueToTimeout();
                    });
                }
            }

            private void cancelDueToTimeout() {
                this.cancelForWorker();
                this.onDone((T)responseReader.returnResult(null, true, true));
                this.asyncWorker.abort();
            }

            private void cancelDelay() {
                if (this.taskDelay != null) {
                    this.taskDelay.cancel();
                    this.taskDelay = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void cancelForWorker() {
                Mutable mutable = myTask;
                synchronized (mutable) {
                    this.cancelled = true;
                    if (this.autoCloseable != null) {
                        Misc.forceClose(this.autoCloseable);
                    }
                }
            }

            @Override
            protected T doWork() {
                return MiscWeb.get(url, sec_timeout, x -> {
                    if (!Thread.interrupted()) {
                        Mutable mutable2 = myTask;
                        synchronized (mutable2) {
                            if (!this.cancelled) {
                                this.autoCloseable = x;
                                return () -> {
                                    Mutable mutable2 = myTask;
                                    synchronized (mutable2) {
                                        this.autoCloseable = null;
                                    }
                                };
                            }
                        }
                    }
                    Misc.forceClose(x);
                    return IDisposable.DO_NOTHING;
                }, responseReader);
            }

            @Override
            protected void onAbort() {
                if (!this.cancelled) {
                    super.onAbort();
                    this.cancelDelay();
                    this.cancelForWorker();
                }
            }

            @Override
            protected void onDone(T result) {
                this.cancelDelay();
                if (((Task)myTask.Value).isRunning()) {
                    super.onDone(result);
                }
            }
        }.startTask();
        return (Task)myTask.Value;
    }

    private static enum TimeoutState {
        NoTimeout,
        AlreadyFailed,
        TimedOut;

    }
}

