/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.web;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.web.CancelWrapper;
import com.iosoft.helpers.web.IResponseReader;
import com.iosoft.helpers.web.WebResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public abstract class AbstractResponseReader<T extends WebResponse<?>>
implements IResponseReader<T> {
    protected final boolean _allowError;
    protected int _statusCode = -1;
    private boolean _used;

    public AbstractResponseReader(boolean allowError) {
        this._allowError = allowError;
    }

    @Override
    public void onStart() {
        if (this._used) {
            throw new IllegalStateException(String.valueOf(Misc.getClassName(this)) + " was already used");
        }
        this._used = true;
    }

    @Override
    public void read(URLConnection connection, CancelWrapper cancelWrapper) throws IOException {
        this._statusCode = connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
    }

    protected InputStream openStream(URLConnection connection) throws IOException {
        Misc.notNull(connection);
        try {
            try {
                return connection.getInputStream();
            }
            catch (IOException e) {
                if (this._allowError && connection instanceof HttpURLConnection) {
                    return ((HttpURLConnection)connection).getErrorStream();
                }
                throw e;
            }
        }
        catch (NullPointerException e) {
            throw new IOException("Cancellation weirdness", e);
        }
    }
}

