/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class UnexpandingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SizeDim sizeMin = new SizeDim();
    private final SizeDim sizeMax = new SizeDim();
    private final SizeDim sizePreferred = new SizeDim();

    public UnexpandingPanel() {
        super.setLayout(null);
        this.setOpaque(false);
    }

    public UnexpandingPanel(Component c) {
        this();
        this.add(c);
    }

    public UnexpandingPanel(Component c, Integer width, Integer height) {
        this();
        this.add(c);
        this.setOverrideSize(width, height);
    }

    @Override
    public void setLayout(LayoutManager m) {
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.relayout();
    }

    @Override
    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.relayout();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.relayout();
    }

    private void relayout() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            child.setBounds(0, 0, this.getWidth(), this.getHeight());
            ++n2;
        }
    }

    public void setPreferredSize(Integer width, Integer height) {
        this.sizePreferred.put(width, height);
        this.invalidate();
    }

    public void setMinimumSize(Integer width, Integer height) {
        this.sizeMin.put(width, height);
        this.invalidate();
    }

    public void setMaximumSize(Integer width, Integer height) {
        this.sizeMax.put(width, height);
        this.invalidate();
    }

    public void setOverrideSize(Integer width, Integer height) {
        this.setPreferredSize(width, height);
        this.setMinimumSize(width, height);
        this.setMaximumSize(width, height);
    }

    private static Dimension applySize(Dimension original, SizeDim override) {
        if (override.width != null) {
            original.width = override.width;
        }
        if (override.height != null) {
            original.height = override.height;
        }
        return original;
    }

    @Override
    public Dimension getPreferredSize() {
        return UnexpandingPanel.applySize(super.getPreferredSize(), this.sizePreferred);
    }

    @Override
    public Dimension getMinimumSize() {
        return UnexpandingPanel.applySize(super.getMinimumSize(), this.sizeMin);
    }

    @Override
    public Dimension getMaximumSize() {
        return UnexpandingPanel.applySize(super.getMaximumSize(), this.sizeMax);
    }

    private static final class SizeDim {
        Integer width;
        Integer height;

        private SizeDim() {
        }

        public void put(Integer w, Integer h) {
            this.width = w;
            this.height = h;
        }
    }
}

