/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;

public class TiledBorder
extends AbstractBorder {
    private final Image _image;
    private final boolean _transparent;
    private final double _insetScale;
    private double _scale;
    private int _widthLeft;
    private int _widthRight;
    private int _heightTop;
    private int _heightBottom;
    private int _imgWidthLeft;
    private int _imgWidthMiddle;
    private int _imgWidthRight;
    private int _imgHeightTop;
    private int _imgHeightMiddle;
    private int _imgHeightBottom;

    public static TiledBorder createFromImage(BufferedImage image, double scale) {
        return TiledBorder.createFromImage(image, scale, 1.0);
    }

    public static TiledBorder createFromImage(BufferedImage image, double scale, double insetScale) {
        return new TiledBorder(image, scale, image.getColorModel().hasAlpha(), insetScale);
    }

    protected TiledBorder(Image image, double scale, boolean transparent, double insetScale) {
        this._image = image;
        this._transparent = transparent;
        this._insetScale = insetScale;
        this.setScale(scale);
    }

    public void setScale(double scale) {
        this._scale = scale;
        int imgTotalWidth = this._image.getWidth(null);
        int imgTotalHeight = this._image.getHeight(null);
        this._imgWidthLeft = this._imgWidthRight = imgTotalWidth / 3;
        this._imgWidthMiddle = imgTotalWidth - this._imgWidthLeft - this._imgWidthRight;
        this._imgHeightTop = this._imgHeightBottom = imgTotalHeight / 3;
        this._imgHeightMiddle = imgTotalHeight - this._imgHeightTop - this._imgHeightBottom;
        int totalWidth = (int)Math.floor((double)imgTotalWidth * scale);
        this._widthLeft = this._widthRight = totalWidth / 3;
        int totalHeight = (int)Math.floor((double)imgTotalHeight * scale);
        this._heightTop = this._heightBottom = totalHeight / 3;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int middleWidth = width - this._widthLeft - this._widthRight;
        int middleHeight = height - this._heightTop - this._heightBottom;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this._widthLeft;
        insets.top = this._heightTop;
        insets.right = this._widthRight;
        insets.bottom = this._heightBottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this._transparent;
    }
}

