/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.awt.MiscImg;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JPanel;

public class Picture
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected Image _img;
    protected boolean _ownImage;
    protected boolean _scaled;
    protected boolean _forced;
    protected boolean _hqScaling;
    protected float _ratio;
    protected int imgW;
    protected int imgH;
    protected ActionListener _al;
    protected SizeRule _sizeRule;

    public Picture() {
        super(null);
        this.setOpaque(false);
        this._ownImage = false;
        this._scaled = false;
        this._forced = false;
        this.setSizeRule(SizeRule.STRETCH);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Picture.this._al != null && e.getButton() == 1) {
                    Picture.this._al.actionPerformed(new ActionEvent(Picture.this, 1001, "clicked"));
                }
            }
        };
        this.addMouseListener(ml);
        this.initImage();
    }

    public Picture(int x, int y, int width, int height) {
        this(x, y, width, height, (Image)null);
    }

    public Picture(int x, int y, int width, int height, Image img) {
        this(img);
        this.setBounds(x, y, width, height);
    }

    public Picture(int x, int y, int width, int height, String path) {
        this(path);
        this.setBounds(x, y, width, height);
    }

    public Picture(SizeRule sizeRule) {
        this();
        this.setSizeRule(sizeRule);
    }

    public Picture(Image img) {
        this();
        this.setImage(img);
    }

    public Picture(String path) {
        this();
        this.setImage(path);
    }

    public Picture(Image img, SizeRule sizeRule) {
        this(img);
        this.setSizeRule(sizeRule);
    }

    public Picture(String path, SizeRule sizeRule) {
        this(path);
        this.setSizeRule(sizeRule);
    }

    public Picture(int width, int height) {
        this();
        this.setForcedSize(width, height);
    }

    public void setHQScaling(boolean hqScaling) {
        this._hqScaling = hqScaling;
    }

    public void setSizeRule(SizeRule rule) {
        this._sizeRule = rule;
        this._scaled = rule != SizeRule.STATIC;
    }

    protected void cleanup() {
        if (this._ownImage && this._img != null) {
            this._img.flush();
            this._img = null;
            this._ownImage = false;
        }
    }

    protected void initImage() {
        if (!this._forced) {
            if (this._img == null) {
                this.imgW = 0;
                this.imgH = 0;
            } else {
                this.imgW = this._img.getWidth(null);
                this.imgH = this._img.getHeight(null);
            }
            if (this.imgH > 0 && this.imgW > 0) {
                this._ratio = (float)this.imgW / (float)this.imgH;
            }
        }
    }

    public void setImage(String path) {
        try {
            this.setImage(MiscImg.loadImage(path));
        }
        catch (IOException e) {
            throw new WrapException(e);
        }
        this._ownImage = true;
    }

    public void setImage(Image img) {
        if (img != this._img) {
            this.cleanup();
        }
        this._img = img;
        this.initImage();
    }

    public void unsetForcedSize() {
        this._forced = false;
    }

    public void setForcedSize(int forceWidth, int forceHeight) {
        this._scaled = true;
        this._forced = true;
        this.imgW = forceWidth;
        this.imgH = forceHeight;
        this.setSize(this.imgW, this.imgH);
    }

    public void setActionListener(ActionListener al) {
        this._al = al;
        MiscAWT.setCursor(this, al == null ? null : new Cursor(12));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._img != null) {
            if (this._sizeRule == SizeRule.STATIC) {
                g.drawImage(this._img, this.getWidth() / this.imgW / 2, this.getHeight() / this.imgH / 2, null);
            } else {
                if (this._hqScaling) {
                    MiscAWT.setBestQuality((Graphics2D)g);
                }
                if (this._sizeRule == SizeRule.STRETCH) {
                    g.drawImage(this._img, 0, 0, this.getWidth(), this.getHeight(), null);
                } else {
                    double imgWidth = this._img.getWidth(null);
                    double imgHeight = this._img.getHeight(null);
                    if (imgWidth == 0.0 || imgHeight == 0.0) {
                        return;
                    }
                    double ratio = imgWidth / imgHeight;
                    double width = this.getWidth();
                    double height = this.getHeight();
                    double heightForMaxWidth = width / ratio;
                    double widthForMaxHeight = height * ratio;
                    if (heightForMaxWidth > height != (this._sizeRule == SizeRule.STRETCH_UNIFORM_FILL)) {
                        imgWidth = widthForMaxHeight;
                        imgHeight = height;
                    } else {
                        imgWidth = width;
                        imgHeight = heightForMaxWidth;
                    }
                    int atX = (int)Math.round((width - imgWidth) * 0.5);
                    int atY = (int)Math.round((height - imgHeight) * 0.5);
                    int actualWidth = (int)Math.round(imgWidth);
                    int actualHeight = (int)Math.round(imgHeight);
                    g.drawImage(this._img, atX, atY, actualWidth, actualHeight, null);
                }
            }
        }
    }

    public static enum SizeRule {
        STATIC,
        STRETCH,
        STRETCH_UNIFORM,
        STRETCH_UNIFORM_FILL;

    }
}

