/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.binding.ListChangedArgs;
import com.iosoft.helpers.binding.ObservableList;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ObservableListModel<T>
implements ListModel<T>,
IDisposable {
    private final ObservableList<T> _list;
    private final IDisposable _binding;
    private ListDataListener[] _listeners = new ListDataListener[0];
    private boolean _isFiring;
    private ListDataListener[] _listenersNew;

    public ObservableListModel(ObservableList<T> list) {
        this._list = list;
        this._binding = list.Changed.registerHandler((ListChangedArgs<Consumer<ListChangedArgs>>)((Object)((Consumer<ListChangedArgs>)evt -> {
            if (this._listeners.length == 0) {
                return;
            }
            this._isFiring = true;
            try {
                int endIndex = evt.Index + evt.Length - 1;
                switch (evt.Type) {
                    case Added: 
                    case IntervalAdded: {
                        ListDataListener[] listDataListenerArray = this._listeners;
                        int n = this._listeners.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ListDataListener listener = listDataListenerArray[n2];
                            listener.intervalAdded(new ListDataEvent(this, 1, evt.Index, endIndex));
                            ++n2;
                        }
                        break;
                    }
                    case Removed: 
                    case IntervalRemoved: {
                        ListDataListener[] listDataListenerArray = this._listeners;
                        int n = this._listeners.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ListDataListener listener = listDataListenerArray[n3];
                            listener.intervalAdded(new ListDataEvent(this, 2, evt.Index, endIndex));
                            ++n3;
                        }
                        break;
                    }
                    case Changed: {
                        ListDataListener[] listDataListenerArray = this._listeners;
                        int n = this._listeners.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ListDataListener listener = listDataListenerArray[n4];
                            listener.intervalAdded(new ListDataEvent(this, 0, evt.Index, endIndex));
                            ++n4;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown case '" + (Object)((Object)evt.Type) + "'");
                    }
                }
            }
            finally {
                this._isFiring = false;
                if (this._listenersNew != null) {
                    this._listeners = this._listenersNew;
                    this._listenersNew = null;
                }
            }
        })));
    }

    @Override
    public void dispose() {
        this._binding.dispose();
    }

    @Override
    public int getSize() {
        return this._list.size();
    }

    @Override
    public T getElementAt(int index) {
        return this._list.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        ListDataListener[] array;
        ListDataListener[] listDataListenerArray = array = this._listenersNew == null ? this._listeners : this._listenersNew;
        if (Arrays.asList(array).contains(l)) {
            return;
        }
        array = Misc.arrayAddEnd(array, l);
        if (this._isFiring) {
            this._listenersNew = array;
        } else {
            this._listeners = array;
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        ListDataListener[] array = this._listenersNew == null ? this._listeners : this._listenersNew;
        int index = MiscLINQ.indexOf(array, l);
        if (index == -1) {
            return;
        }
        array = Misc.arrayRemoveIndex(array, index);
        if (this._isFiring) {
            this._listenersNew = array;
        } else {
            this._listeners = array;
        }
    }
}

