/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.Pair;
import com.iosoft.helpers.ui.awt.ScalingIcon;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;

public class ImagePair {
    public final Image Enabled;
    public final Image Disabled;

    public ImagePair(Image enabled, Image disabled) {
        this.Enabled = enabled;
        this.Disabled = disabled;
    }

    public ImagePair(Image enabled) {
        this.Enabled = enabled;
        this.Disabled = GrayFilter.createDisabledImage(enabled);
    }

    public Icon getScalingIcon(boolean enabled, double scale, double originalWidth, double originalHeight) {
        return new ScalingIcon(enabled ? this.Enabled : this.Disabled, (int)(originalWidth * scale), (int)(originalHeight * scale));
    }

    public void setIcons(AbstractButton button, double scale, double originalWidth, double originalHeight) {
        int width = (int)(originalWidth * scale);
        int height = (int)(originalHeight * scale);
        button.setIcon(new ScalingIcon(this.Enabled, width, height));
        button.setDisabledIcon(new ScalingIcon(this.Disabled, width, height));
    }

    public static void setIcons(AbstractButton button, Pair<Icon, Icon> icons) {
        button.setIcon((Icon)icons.V1);
        button.setDisabledIcon((Icon)icons.V2);
    }
}

