/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GameText
extends JTextField {
    private static final long serialVersionUID = 1L;
    public static final int NO_LIMIT = -1;
    private int maxChars = -1;

    public GameText() {
        this("", null, null);
    }

    public GameText(int x, int y, int width, int height, String text, Font font, Component base) {
        this(text, font, base);
        this.setBounds(x, y, width, height);
    }

    public GameText(String text, Font font, Component base) {
        if (base != null) {
            MiscAWT.doDefaults(this, base);
        }
        if (font != null) {
            this.setFont(font);
        }
        MiscAWT.enableAA(this);
        this.setHorizontalAlignment(2);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                if (GameText.this.maxChars > -1 && this.getLength() + str.length() > GameText.this.maxChars) {
                    if (this.getLength() > GameText.this.maxChars) {
                        this.remove(GameText.this.maxChars, this.getLength() - GameText.this.maxChars);
                        str = "";
                    } else {
                        str = Misc.limitLength(str, GameText.this.maxChars - this.getLength());
                    }
                }
                super.insertString(offset, str, a);
            }
        });
        this.setText(text);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        MiscAWT.setAA(g);
        super.paintComponent(g);
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public int getMaxChars() {
        return this.maxChars;
    }
}

