/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ui.awt.AntialiasedLabel;
import com.iosoft.helpers.ui.awt.GameButton;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GameSpinner<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GameButton buttonLeft;
    private final GameButton buttonRight;
    private final JLabel label;
    private int choice;
    private T[] choices;
    private boolean enabled = true;
    private boolean inited = true;
    private ActionListener[] als = new ActionListener[0];

    public GameSpinner(T[] choices, int idxDefaultChoice) {
        this.setLayout(null);
        this.choices = choices;
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        MyActionListener al = new MyActionListener();
        this.buttonLeft = this.createButton(true);
        this.buttonLeft.setText("<");
        this.buttonLeft.addActionListener(al);
        this.add(this.buttonLeft);
        this.buttonRight = this.createButton(false);
        this.buttonRight.setText(">");
        this.buttonRight.addActionListener(al);
        this.add(this.buttonRight);
        this.label = this.createLabel();
        this.label.setHorizontalAlignment(0);
        this.add(this.label);
        this.setChoices(choices, idxDefaultChoice);
    }

    public GameSpinner(int x, int y, int width, int height, T[] choices) {
        this(x, y, width, height, choices, null, 0);
    }

    public GameSpinner(int x, int y, int w, int h, T[] choices, Font font, int choice) {
        this(choices, choice);
        if (font != null) {
            this.setFont(font);
        }
        this.setChoice(choice);
        this.setBounds(x, y, w, h);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        int minWidth = width < height ? width : height;
        this.buttonLeft.setBounds(0, 0, minWidth, height);
        this.buttonRight.setBounds(width - minWidth, 0, minWidth, height);
        this.label.setBounds(minWidth, 0, Math.max(0, width - height * 2), height);
    }

    protected GameButton createButton(boolean left) {
        return new GameButton();
    }

    protected JLabel createLabel() {
        return new AntialiasedLabel();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.inited) {
            this.checkButtons();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int getChoiceIndex() {
        return this.choice;
    }

    public T getCurrentChoice() {
        return this.choices[this.choice];
    }

    public void setChoices(T[] newChoices, int newChoice) {
        Misc.notNull(newChoices);
        if (newChoice < 0) {
            newChoice = 0;
        } else if (newChoice >= newChoices.length) {
            newChoice = newChoices.length - 1;
        }
        this.choices = newChoices;
        this.choice = newChoice;
        this.checkButtons();
    }

    public void setChoice(int choice) {
        if (choice < 0) {
            choice = 0;
        }
        if (choice >= this.choices.length) {
            choice = this.choices.length - 1;
        }
        this.choice = choice;
        this.checkButtons();
    }

    public boolean setValue(T value) {
        if (this.choices != null) {
            int i = 0;
            while (i < this.choices.length) {
                if (this.choices[i].equals(value)) {
                    this.setChoice(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public T getValue() {
        return this.choices.length == 0 ? null : (T)this.choices[this.choice];
    }

    public void doClick(boolean button) {
        int iC = this.als.length;
        int i = 0;
        while (i < iC) {
            this.als[i].actionPerformed(new ActionEvent(this, 1001, button ? "buttonLeft" : "buttonRight"));
            ++i;
        }
    }

    public void addActionListener(ActionListener al) {
        int iC = this.als.length;
        ActionListener[] temp = new ActionListener[iC + 1];
        int i = 0;
        while (i < iC) {
            temp[i] = this.als[i];
            ++i;
        }
        temp[iC] = al;
        this.als = temp;
    }

    private void checkButtons() {
        this.buttonLeft.setEnabled(this.enabled);
        this.buttonRight.setEnabled(this.enabled);
        this.label.setEnabled(this.enabled);
        if (this.enabled) {
            if (this.choice == 0) {
                this.buttonLeft.setEnabled(false);
            } else {
                this.buttonLeft.setEnabled(true);
            }
            if (this.choice == this.choices.length - 1) {
                this.buttonRight.setEnabled(false);
            } else {
                this.buttonRight.setEnabled(true);
            }
        }
        this.label.setText(this.choices.length > 0 ? this.choices[this.choice].toString() : "?");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.inited) {
            this.buttonLeft.setFont(font);
            this.buttonRight.setFont(font);
            this.label.setFont(font);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameButton source = (GameButton)e.getSource();
            if (source == GameSpinner.this.buttonLeft) {
                if (GameSpinner.this.choice > 0) {
                    GameSpinner gameSpinner = GameSpinner.this;
                    gameSpinner.choice = gameSpinner.choice - 1;
                }
                GameSpinner.this.doClick(false);
            } else if (source == GameSpinner.this.buttonRight) {
                if (GameSpinner.this.choice < GameSpinner.this.choices.length - 1) {
                    GameSpinner gameSpinner = GameSpinner.this;
                    gameSpinner.choice = gameSpinner.choice + 1;
                }
                GameSpinner.this.doClick(true);
            }
            GameSpinner.this.checkButtons();
        }
    }
}

