/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.ui.awt;

import com.iosoft.helpers.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;

public class ErrorScreen
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea textBug;
    private JScrollPane scrollerBug;

    public static void showAndDump(Container container, Throwable error, String appName) {
        error.printStackTrace();
        ErrorScreen.show(container, error, appName);
    }

    public static void show(Container container, Throwable error, String appName) {
        ErrorScreen.show(container, "An unexpected error occured!\nPlease report this to the creator of the program!\n\n" + appName + "\n" + Misc.printException(error));
    }

    public static void show(Container container, Throwable error) {
        ErrorScreen.show(container, Misc.printException(error));
    }

    public static void show(Container container, String text) {
        ErrorScreen screen = new ErrorScreen();
        screen.setText(text);
        if (container instanceof RootPaneContainer) {
            RootPaneContainer frame = (RootPaneContainer)((Object)container);
            container.setVisible(true);
            container = frame.getContentPane();
        }
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add((Component)screen, "Center");
        screen.onInit();
        container.revalidate();
        container.repaint();
    }

    public ErrorScreen() {
        super(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.textBug = new JTextArea();
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.textBug.getActionMap().get("copy-to-clipboard"));
        popup.add(this.textBug.getActionMap().get("select-all"));
        this.textBug.setComponentPopupMenu(popup);
        this.textBug.setEditable(false);
        this.scrollerBug = new JScrollPane(this.textBug);
        this.add((Component)this.scrollerBug, "Center");
    }

    public void setText(String text) {
        this.textBug.setText(text);
    }

    public void onInit() {
    }
}

