/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.math;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.math.Pos2D;
import com.iosoft.helpers.math.Vector2D;

public final class Misc2D {
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final double HALFPI = 1.5707963267948966;
    public static final double TWOPI = Math.PI * 2;
    public static final double THIRDPI = 1.0471975511965976;
    public static final double QUARTPI = 0.7853981633974483;
    public static final double SIXTHPI = 0.5235987755982988;
    public static final double LOG2 = Math.log(2.0);
    private static final double byteToRotation = 0.02454369260617026;
    private static final double shortToRotation = 9.587379924285257E-5;

    private Misc2D() {
    }

    public static double getAngle(double angle1, double angle2) {
        return Misc2D.normalizeRotation(angle2 - angle1);
    }

    public static double rotateStep(double rotation, double target, double step) {
        double an2;
        boolean mode;
        double an1 = Misc2D.getAngle(rotation, target);
        boolean bl = mode = an1 < (an2 = Misc2D.getAngle(target, rotation));
        if (an1 < step || an2 < step) {
            step = mode ? an1 : an2;
        }
        return step *= (double)(mode ? 1.0f : -1.0f);
    }

    public static double rotateTo(double rotation, double target, double step) {
        double an1 = Misc2D.getAngle(rotation, target);
        double an2 = Misc2D.getAngle(target, rotation);
        rotation = an1 < step || an2 < step ? target : (rotation += (an1 < an2 ? 1.0 : -1.0) * step);
        return rotation;
    }

    public static boolean compareRotationsByDegrees(double rot1, double rot2) {
        int deg2;
        int deg1 = (int)Math.floor(Misc2D.normalizeRotation(rot1) * 57.29577951308232);
        return deg1 == (deg2 = (int)Math.floor(Misc2D.normalizeRotation(rot2) * 57.29577951308232));
    }

    public static double positionsToRotation(double x1, double y1, double x2, double y2) {
        return Math.atan2(y2 - y1, x2 - x1);
    }

    public static double randomRotation() {
        return Misc.random(Math.PI * 2);
    }

    public static double normalizeRotation(double rotation) {
        return Misc.modNegToPos(rotation, Math.PI * 2);
    }

    public static boolean isInInterval(double rotation, double start, double end) {
        rotation = Misc2D.normalizeRotation(rotation);
        return (start = Misc2D.normalizeRotation(start)) < (end = Misc2D.normalizeRotation(end)) ? rotation >= start && rotation <= end : rotation > start || rotation < end;
    }

    public static boolean isInAngle(double rotation, double baseRotation, double halfAngle) {
        return Misc2D.isInInterval(rotation, baseRotation - halfAngle, baseRotation + halfAngle);
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Misc2D.getDistanceSq(x1, y1, x2, y2));
    }

    public static double getDistanceSq(double x1, double y1, double x2, double y2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        return dX * dX + dY * dY;
    }

    public static int rotationNetworked1(double rotation) {
        return (int)Math.round(Misc2D.normalizeRotation(rotation) / 0.02454369260617026) % 256;
    }

    public static double rotationDenetworked1(int net) {
        return (double)net * 0.02454369260617026;
    }

    public static char rotationNetworked2(double rotation) {
        return (char)(Math.round(Misc2D.normalizeRotation(rotation) / 9.587379924285257E-5) % 65536L);
    }

    public static double rotationDenetworked2(char net) {
        return (double)net * 9.587379924285257E-5;
    }

    public static double interpolateRotation(double rot, double newRot, double progress) {
        double angle2;
        double angle = Misc2D.getAngle(rot, newRot);
        return rot + progress * (angle < (angle2 = Misc2D.getAngle(newRot, rot)) ? angle : -angle2);
    }

    public static double interpolateRotationSegment(double rot, double newRot) {
        double angle2;
        double angle = Misc2D.getAngle(rot, newRot);
        return angle < (angle2 = Misc2D.getAngle(newRot, rot)) ? angle : -angle2;
    }

    public static double convergeTo(double value, double target, double maxChange) {
        if (value < target) {
            if ((value += maxChange) > target) {
                value = target;
            }
        } else if (value > target && (value -= maxChange) < target) {
            value = target;
        }
        return value;
    }

    public static double getAimAngle(Vector2D pos1, Vector2D pos2, double baseRotation) {
        double angle2;
        double angle = pos1.getAngle(pos2);
        double angle1 = Misc2D.getAngle(angle, baseRotation);
        return angle1 < (angle2 = Misc2D.getAngle(baseRotation, angle)) ? -angle1 : angle2;
    }

    public static boolean isInFoV(Pos2D pos, Vector2D otherPos, double fov) {
        return Misc2D.isInFoV(pos.Position.X, pos.Position.Y, pos.Rotation, otherPos.X, otherPos.Y, fov);
    }

    public static boolean isInFoV(Vector2D pos, double rotation, Vector2D otherPos, double fov) {
        return Misc2D.isInFoV(pos.X, pos.Y, rotation, otherPos.X, otherPos.Y, fov);
    }

    public static boolean isInFoV(double baseX, double baseY, double rotation, double x, double y, double fov) {
        double angle2;
        double angle = Misc2D.positionsToRotation(baseX, baseY, x, y);
        double angle1 = Misc2D.getAngle(angle, rotation);
        return angle1 < (angle2 = Misc2D.getAngle(rotation, angle)) ? angle1 <= fov : angle2 <= fov;
    }

    public static boolean getLineCrossing(Vector2D pos1, Vector2D pos2, Vector2D dir1, Vector2D dir2, Vector2D results) {
        return Misc2D.getLineCrossing(pos1.X, pos1.Y, pos2.X, pos2.Y, dir1.X, dir1.Y, dir2.X, dir2.Y, results);
    }

    public static boolean getLineCrossing(double pos1x, double pos1y, double pos2x, double pos2y, double dir1x, double dir1y, double dir2x, double dir2y, Vector2D results) {
        pos1x = pos2x - pos1x;
        pos2x = dir1y * dir2x - dir2y * dir1x;
        if (pos2x == 0.0) {
            return false;
        }
        pos1y = pos2y - pos1y;
        results.X = (pos1y * dir2x - pos1x * dir2y) / pos2x;
        results.Y = dir2x == 0.0 ? (dir1y * results.X - pos1y) / dir2y : (dir1x * results.X - pos1x) / dir2x;
        return true;
    }

    public static boolean getLineCrossingPoint(Vector2D pos1, Vector2D pos2, Vector2D dir1, Vector2D dir2, Vector2D results) {
        if (!Misc2D.getLineCrossing(pos1, pos2, dir1, dir2, results)) {
            return false;
        }
        if (results.X < 0.0 || results.Y < 0.0 || results.X > 1.0 || results.Y > 1.0) {
            return false;
        }
        double a = results.X;
        results.put(dir1);
        results.mulSelf(a);
        results.addSelf(pos1);
        return true;
    }

    public static double simpleLeadTarget(Vector2D posMe, Vector2D posTarget, Vector2D velMe, Vector2D velTarget, double bulletSpeed) {
        return Misc2D.simpleLeadTarget(posTarget.X - posMe.X, posTarget.Y - posMe.Y, velTarget.X - velMe.X, velTarget.Y - velMe.Y, bulletSpeed, 10);
    }

    public static double simpleLeadTarget(double offsetX, double offsetY, double velX, double velY, double bulletSpeed, int maxIterations) {
        double tarX = offsetX;
        double tarY = offsetY;
        if (bulletSpeed > 0.0) {
            int iterations = 0;
            while (iterations < maxIterations) {
                double prevTarY;
                double prevTarX;
                ++iterations;
                double dist = Misc2D.getDistance(0.0, 0.0, tarX, tarY);
                double time = dist / bulletSpeed;
                if (Misc2D.getDistanceSq(tarX = offsetX + velX * time, tarY = offsetY + velY * time, prevTarX = tarX, prevTarY = tarY) < 1.0) break;
            }
        }
        return Math.atan2(tarY, tarX);
    }

    public static int taxiDistance(int x1, int y1, int x2, int y2) {
        return Math.abs(x2 - x1) + Math.abs(y2 - y1);
    }

    public static void lerp(Vector2D start, Vector2D end, double progress, Vector2D out_between) {
        out_between.X = start.X + (end.X - start.X) * progress;
        out_between.Y = start.Y + (end.Y - start.Y) * progress;
    }
}

