/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer;

import com.iosoft.helpers.FormatException;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.DataSourceUtil;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.datasource.ISubableDataSource;
import com.iosoft.helpers.localizer.Language;
import com.iosoft.helpers.localizer.Localizer;
import com.iosoft.helpers.localizer.source.AbstractLocalizationFile;
import com.iosoft.helpers.localizer.source.JSONLocalizationFile;
import com.iosoft.json.JSON;
import com.iosoft.json.LanguagesJSONFile;
import com.iosoft.propdb.PropDB;
import com.iosoft.propdb.PropDBLocalizationFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class LocalizationParser {
    private final Localizer localizer;
    private final ArrayList<MetaInfo> metaInfos = new ArrayList();
    private boolean started;

    public LocalizationParser(Localizer localizer) {
        this.localizer = localizer;
    }

    public void addTextsPropDB(ISubableDataSource source) {
        this.addTextsPropDB(source, "languages.txt");
    }

    public void addTextsPropDB(ISubableDataSource source, String filename) {
        this.addTexts(source, filename, false);
    }

    public void addTextsJSON(ISubableDataSource source) {
        this.addTextsJSON(source, "languages.json");
    }

    public void addTextsJSON(ISubableDataSource source, String filename) {
        this.addTexts(source, filename, true);
    }

    public void addTexts(ISubableDataSource source, String filename, boolean json) {
        this.ensureNotStarted();
        this.metaInfos.add(new MetaInfo(source, filename, json));
    }

    private void start() {
        this.ensureNotStarted();
        this.started = true;
        this.metaInfos.trimToSize();
    }

    private void ensureNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
    }

    public void loadTexts() throws IOException {
        this.start();
        for (MetaInfo metaInfo : this.metaInfos) {
            ISubableDataSource dataSource = metaInfo.Source.sub(metaInfo.Filename);
            try {
                if (metaInfo.JSON) {
                    this.loadLanguageDef(metaInfo.Source, (LanguagesJSONFile)JSON.deserialize((String)DataSourceUtil.loadAsString(dataSource), LanguagesJSONFile.class));
                    continue;
                }
                this.loadLanguageDef(metaInfo.Source, PropDB.loadSource(dataSource));
            }
            catch (FormatException | IOException e) {
                throw new IOException("Could not load texts from '" + dataSource + "'", e);
            }
        }
    }

    public Task<IOException> loadTextsAsync() {
        this.start();
        return Async.forEachEx(this.metaInfos, metaInfo -> {
            ISubableDataSource dataSource = metaInfo.Source.sub(metaInfo.Filename);
            if (metaInfo.Filename.endsWith(".json")) {
                return Async.runAsyncWrap(() -> (LanguagesJSONFile)JSON.deserialize((String)DataSourceUtil.loadAsString(dataSource), LanguagesJSONFile.class)).awaitAndTranslate(result -> new MetaLoadResult((Exception)result.Exception, null, (LanguagesJSONFile)result.Value, (MetaInfo)metaInfo, dataSource));
            }
            return PropDB.loadSourceAsync(dataSource).awaitAndTranslate(result -> new MetaLoadResult((Exception)result.Exception, (PropDB)result.Value, null, (MetaInfo)metaInfo, dataSource));
        }, result -> {
            if (result.Error != null) {
                return new IOException("Could not load texts from '" + result.PropDBSource + "'", result.Error);
            }
            if (result.PropDB != null) {
                this.loadLanguageDef(result.MetaInfo.Source, result.PropDB);
            } else {
                this.loadLanguageDef(result.MetaInfo.Source, result.Json);
            }
            return null;
        });
    }

    private void loadLanguageDef(ISubableDataSource source, PropDB propDB) {
        PropDB.Node root = propDB.getRoot();
        for (PropDB.Node node : root) {
            PropDB.Node files;
            Language language;
            block10: {
                language = this.localizer.getOrCreateLanguage(node.getName());
                PropDB.Node properties = node.tryGetChild("Properties");
                if (properties == null) break block10;
                for (PropDB.Node property : properties) {
                    String propertyName = property.getName();
                    switch (propertyName) {
                        case "flagID": {
                            language.setProperty(propertyName, property.getAsInt());
                            break;
                        }
                        default: {
                            language.setProperty(propertyName, property.getAsString());
                        }
                    }
                }
            }
            if ((files = node.tryGetChild("Files")) == null) continue;
            String prefix = files.getAsString();
            for (PropDB.Node file : files) {
                String name = file.getName();
                int index = name.indexOf(124);
                int priority = index != -1 ? Integer.parseInt(name.substring(index + 1)) : 0;
                String fileName = file.getAsString();
                LocalizationParser.addSource(language, fileName, source.sub(String.valueOf(prefix) + fileName), priority);
            }
        }
        this.localizer.refreshLocalizations();
    }

    private void loadLanguageDef(ISubableDataSource source, LanguagesJSONFile jsonFile) {
        for (Map.Entry<String, LanguagesJSONFile.LanguageJSONDto> entry : jsonFile.JSON.entrySet()) {
            LanguagesJSONFile.LanguageJSONDto languageDto = entry.getValue();
            Language language = this.localizer.getOrCreateLanguage(entry.getKey());
            LocalizationParser.trySetProperty(language, "uiName", languageDto.uiName);
            if (languageDto.flagID != -1) {
                language.setProperty("flagID", languageDto.flagID);
            }
            LocalizationParser.trySetProperty(language, "code", languageDto.code);
            LocalizationParser.trySetProperty(language, "authors", languageDto.authors);
            LocalizationParser.trySetProperty(language, "dateFormat", languageDto.dateFormat);
            if (languageDto.properties != null) {
                for (Map.Entry<String, String> property : languageDto.properties.entrySet()) {
                    language.setProperty(property.getKey(), property.getValue());
                }
            }
            if (languageDto.files == null) continue;
            String[] stringArray = languageDto.files;
            int n = languageDto.files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                int index = file.indexOf(124);
                int priority = index != -1 ? Integer.parseInt(file.substring(index + 1)) : 0;
                LocalizationParser.addSource(language, file, source.sub(file), priority);
                ++n2;
            }
        }
        this.localizer.refreshLocalizations();
    }

    private static void addSource(Language language, String name, IDataSource dataSource, int priority) {
        AbstractLocalizationFile localizationSource = name.endsWith(".json") ? new JSONLocalizationFile(dataSource) : new PropDBLocalizationFile(dataSource);
        language.addSource(localizationSource, priority);
    }

    private static void trySetProperty(Language language, String key, Object value) {
        if (value == null) {
            return;
        }
        language.setProperty(key, value);
    }

    private static class MetaInfo {
        public final ISubableDataSource Source;
        public final String Filename;
        public final boolean JSON;

        MetaInfo(ISubableDataSource source, String filename, boolean json) {
            this.Source = Misc.notNull(source);
            this.Filename = Misc.notNull(filename);
            this.JSON = json;
        }
    }

    private static final class MetaLoadResult {
        public final Exception Error;
        public final PropDB PropDB;
        public final LanguagesJSONFile Json;
        public final MetaInfo MetaInfo;
        public final IDataSource PropDBSource;

        MetaLoadResult(Exception error, PropDB propDB, LanguagesJSONFile json, MetaInfo metaInfo, IDataSource propDBSource) {
            this.Error = error;
            this.PropDB = propDB;
            this.Json = json;
            this.MetaInfo = metaInfo;
            this.PropDBSource = propDBSource;
        }
    }
}

