/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer;

import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.localizer.source.LocalizationSource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Language {
    public static final String KEY_UINAME = "uiName";
    public static final String KEY_CODE = "code";
    public static final String KEY_AUTHORS = "authors";
    public static final String KEY_MSG_RESTART = "restartNeeded";
    public static final String KEY_FLAGID = "flagID";
    public static final String KEY_FLAGICON = "flagIcon";
    public static final String KEY_FLAGIMG = "flagImg";
    public static final String KEY_DATE_FORMAT = "dateFormat";
    public static final String DATE_GERMAN = "de";
    public static final String DATE_ENGLISH = "";
    public static final int PRIORITY_IOENGINE = -100;
    public static final int PRIORITY_STANDARD = 0;
    public final String Name;
    protected final Map<LocalizationSource, Integer> localizationSources = new HashMap<LocalizationSource, Integer>();
    public final Map<String, String> Localization = new HashMap<String, String>();
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected boolean loaded = false;
    private Locale locale;

    public Language(String name) {
        this.Name = name;
        this.locale = Locale.getDefault();
    }

    public <T> T getProperty(String key, T defaultValue) {
        Object value = this.properties.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
        if (key.equals(KEY_CODE)) {
            this.locale = new Locale((String)value);
        }
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public String getUiName() {
        return this.getProperty(KEY_UINAME, this.Name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addSource(LocalizationSource source, int priority) {
        this.localizationSources.put(source, priority);
        this.loaded = false;
    }

    public void removeSource(LocalizationSource source) {
        this.localizationSources.remove(source);
        this.loaded = false;
    }

    public void load() {
        this.unload(false);
        ArrayList<Map.Entry<LocalizationSource, Integer>> list = new ArrayList<Map.Entry<LocalizationSource, Integer>>(this.localizationSources.entrySet());
        list.sort(Comparator.comparingInt(Map.Entry::getValue));
        for (Map.Entry entry : list) {
            LocalizationSource source = (LocalizationSource)entry.getKey();
            source.load();
            source.addToTranslation(this.Localization);
        }
        this.loaded = true;
    }

    public VTask loadAsync() {
        this.unload(false);
        ArrayList<Map.Entry<LocalizationSource, Integer>> list = new ArrayList<Map.Entry<LocalizationSource, Integer>>(this.localizationSources.entrySet());
        list.sort(Comparator.comparingInt(Map.Entry::getValue));
        return Async.forEach(list, entry -> {
            LocalizationSource source = (LocalizationSource)entry.getKey();
            return source.loadAsync().awaitAndContinue(() -> source);
        }, source -> source.addToTranslation(this.Localization)).awaitAndContinue(() -> {
            this.loaded = true;
        });
    }

    public void unload(boolean unloadSubs) {
        this.Localization.clear();
        if (unloadSubs) {
            for (LocalizationSource file : this.localizationSources.keySet()) {
                file.unload();
            }
        }
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

