/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.localizer;

import java.util.Locale;

public interface ITranslator {
    public String translateOrNull(String var1);

    public <T> T tryGetProperty(String var1);

    public Locale getLocale();

    default public <T> T getProperty(String name, T defaultValue) {
        T value = this.tryGetProperty(name);
        return value == null ? defaultValue : value;
    }

    default public String getDateFormat() {
        return this.getProperty("dateFormat", "");
    }

    default public String translateOrFallback(String localizeCode, String fallback) {
        String translation = this.translateOrNull(localizeCode);
        return translation == null ? fallback : translation;
    }

    default public String translateOrFallback(String localizeCode, String fallback, Object ... args) {
        return String.format(this.translateOrFallback(localizeCode, fallback), args);
    }

    default public String translate(String localizeCode) {
        return this.translateOrFallback(localizeCode, localizeCode);
    }

    default public String translate(String localizeCode, Object ... args) {
        String localized = this.translateOrNull(localizeCode);
        if (localized != null) {
            return String.format(localized, args);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(localizeCode);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(arg);
            ++n2;
        }
        return sb.toString();
    }
}

