/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.iter;

import com.iosoft.helpers.iter.SkippingIterator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public abstract class SkippingListIterator<E>
extends SkippingIterator<E> {
    private final List<E> list;
    private final int iC;
    private int i = 0;

    public static <E> SkippingListIterator<E> create(List<E> list, final Predicate<E> isOK) {
        return new SkippingListIterator<E>(list){

            @Override
            protected boolean isOK(E element) {
                return isOK.test(element);
            }
        };
    }

    public static <E> Iterable<E> createIterable(List<E> list, final Predicate<E> isOK) {
        return () -> new SkippingListIterator<E>(list){

            @Override
            protected boolean isOK(E element) {
                return isOK.test(element);
            }
        };
    }

    public static <E> Iterable<E> createIterable(E[] array, final Predicate<E> isOK) {
        return () -> new SkippingListIterator<E>(array){

            @Override
            protected boolean isOK(E element) {
                return isOK.test(element);
            }
        };
    }

    public SkippingListIterator(List<E> list) {
        this.list = list;
        this.iC = list.size();
    }

    public SkippingListIterator(E[] array) {
        this(Arrays.asList(array));
    }

    protected abstract boolean isOK(E var1);

    @Override
    protected E findNextElement() {
        E element;
        do {
            if (this.i != this.iC) continue;
            this.onEndReached();
            return null;
        } while (!this.isOK(element = this.list.get(this.i++)));
        return element;
    }
}

