/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.io;

import com.iosoft.helpers.io.BitDataOutput;
import com.iosoft.helpers.io.MiscIO;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitDataOutputStream
extends OutputStream
implements BitDataOutput {
    private final DataOutputStream _out;
    private int _buffer;
    private int _bitsUsed = 0;

    public BitDataOutputStream(DataOutputStream out) {
        this._out = out;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this._buffer <<= 1;
        if (value) {
            this._buffer |= 1;
        }
        ++this._bitsUsed;
        if (this._bitsUsed == 8) {
            this.writeBuffer();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeBits(int number, int numBits) throws IOException {
        if (numBits >= 0 && numBits <= 32) ** GOTO lbl19
        throw new IllegalArgumentException("Too many bits (" + numBits + ")");
lbl-1000:
        // 1 sources

        {
            if (numBits == 1) {
                this.writeBoolean(number != 0);
                return;
            }
            if (numBits >= 8 && this._bitsUsed == 0) {
                numBitsThisCycle = 8;
                bits = numBits == 8 ? number : number & 255;
                this._out.writeByte(bits);
            } else {
                numBitsThisCycle = Math.min(numBits, 8 - this._bitsUsed);
                bits = number & (1 << numBitsThisCycle) - 1;
                this._buffer = this._buffer << numBitsThisCycle | bits;
                number >>= numBitsThisCycle;
                this._bitsUsed += numBitsThisCycle;
                if (this._bitsUsed == 8) {
                    this.writeBuffer();
                }
            }
            numBits -= numBitsThisCycle;
lbl19:
            // 2 sources

            ** while (numBits > 0)
        }
lbl20:
        // 1 sources

    }

    @Override
    public void align() throws IOException {
        if (this._bitsUsed == 0) {
            return;
        }
        this.writeBuffer();
    }

    @Override
    public void ensureAligned() {
        if (this._bitsUsed != 0) {
            throw new IllegalStateException("Stream has uncommitted bits (" + this._bitsUsed + ")");
        }
    }

    @Override
    public void writePackedUInt(int number) throws IOException {
        this.align();
        MiscIO.writePackedUInt(this._out, number);
    }

    @Override
    public void writePackedInt(int number) throws IOException {
        this.align();
        MiscIO.writePackedInt(this._out, number);
    }

    @Override
    public void writePackedBits(int number) throws IOException {
        this.align();
        MiscIO.writePacked(this._out, number);
    }

    @Override
    public void writePackedBits(long number, int maxBits) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeBuffer() throws IOException {
        this._out.writeByte(this._buffer);
        this._buffer = 0;
        this._bitsUsed = 0;
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.align();
        this._out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.align();
        this._out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.align();
        this._out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.align();
        this._out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.align();
        this._out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.align();
        this._out.writeFloat(v);
    }

    @Override
    public void writeFiniteFloat(float v) throws IOException {
        this.align();
        MiscIO.writeFiniteFloat(this._out, v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.align();
        this._out.writeDouble(v);
    }

    @Override
    public void writeFiniteDouble(double v) throws IOException {
        this.align();
        MiscIO.writeFiniteDouble(this._out, v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.align();
        this._out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.align();
        this._out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.align();
        this._out.writeUTF(s);
    }

    @Override
    public void write(int b) throws IOException {
        this.align();
        this._out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.align();
        this._out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.align();
        this._out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }
}

