/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.io;

import com.iosoft.helpers.io.BitDataInput;
import com.iosoft.helpers.io.MiscIO;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitDataInputStream
extends InputStream
implements BitDataInput {
    private final DataInputStream _in;
    private int _buffer;
    private int _bitsRemaining;

    public BitDataInputStream(DataInputStream in) {
        this._in = in;
    }

    private void ensureHasBufferByte() throws IOException {
        if (this._bitsRemaining > 0) {
            return;
        }
        this._buffer = this._in.readUnsignedByte();
        this._bitsRemaining = 8;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.ensureHasBufferByte();
        --this._bitsRemaining;
        boolean bool = (this._buffer & 1) == 1;
        this._buffer >>= 1;
        return bool;
    }

    @Override
    public int readBits(int numBits) throws IOException {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Too many bits (" + numBits + ")");
        }
        int number = 0;
        while (numBits > 0) {
            int bits;
            int numBitsThisCycle;
            if (numBits == 1) {
                return this.readBoolean() ? 1 : 0;
            }
            if (numBits >= 8 && this._bitsRemaining == 0) {
                numBitsThisCycle = 8;
                bits = this._in.readUnsignedByte();
            } else {
                this.ensureHasBufferByte();
                numBitsThisCycle = Math.min(numBits, this._bitsRemaining);
                bits = this._buffer & (1 << numBitsThisCycle) - 1;
                this._bitsRemaining -= numBitsThisCycle;
            }
            number = number == 0 ? bits : number << numBitsThisCycle | bits;
            numBits -= numBitsThisCycle;
        }
        return number;
    }

    @Override
    public void align() {
        this._bitsRemaining = 0;
    }

    @Override
    public int readPackedUInt() throws IOException {
        this.align();
        return MiscIO.readPackedUInt(this._in);
    }

    @Override
    public int readPackedInt() throws IOException {
        this.align();
        return MiscIO.readPackedInt(this._in);
    }

    @Override
    public int readPackedBits() throws IOException {
        this.align();
        return MiscIO.readPacked(this._in);
    }

    @Override
    public long readPackedBits(int maxBits) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.align();
        this._in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.align();
        this._in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.align();
        return this._in.skipBytes(n);
    }

    @Override
    public long skip(long n) throws IOException {
        this.align();
        return this._in.skip(n);
    }

    public void skipFully(int n) throws IOException {
        this.align();
        MiscIO.skipBytes(this._in, n);
    }

    @Override
    public byte readByte() throws IOException {
        this.align();
        return this._in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.align();
        return this._in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.align();
        return this._in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.align();
        return this._in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.align();
        return this._in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.align();
        return this._in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.align();
        return this._in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.align();
        return this._in.readFloat();
    }

    @Override
    public float readFiniteFloat() throws IOException {
        this.align();
        return MiscIO.readFiniteFloat(this._in);
    }

    @Override
    public double readDouble() throws IOException {
        this.align();
        return this._in.readDouble();
    }

    @Override
    public double readFiniteDouble() throws IOException {
        this.align();
        return MiscIO.readFiniteDouble(this._in);
    }

    @Override
    public String readUTF() throws IOException {
        this.align();
        return this._in.readUTF();
    }

    @Override
    public int read() throws IOException {
        this.align();
        return this._in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.align();
        return this._in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.align();
        return this._in.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.align();
        this._in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._in.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.align();
        this._in.reset();
    }
}

