/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.io;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.io.MiscIO;
import java.awt.Point;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public interface BitDataInput
extends DataInput {
    public int readBits(int var1) throws IOException;

    public int readPackedUInt() throws IOException;

    public int readPackedInt() throws IOException;

    public int readPackedBits() throws IOException;

    public long readPackedBits(int var1) throws IOException;

    public void align() throws IOException;

    public double readFiniteDouble() throws IOException;

    public float readFiniteFloat() throws IOException;

    @Override
    default public String readLine() throws IOException {
        throw new IOException("readLine() is not supported");
    }

    default public String readChars(int length) throws IOException {
        return MiscIO.readChars(this, length);
    }

    default public String readString(int length) throws IOException {
        return new String(MiscIO.readFully(this, length), StandardCharsets.ISO_8859_1);
    }

    default public String readUTFString() throws IOException {
        int length = this.readUnsignedByte();
        return new String(MiscIO.readFully(this, length), StandardCharsets.UTF_8);
    }

    default public String readCString(int maxChars) throws IOException {
        return Misc.bytesToString(MiscIO.readFully(this, maxChars));
    }

    default public <T> T readNotNull(T[] values) throws IOException {
        int index = this.readPackedUInt();
        if (index >= values.length) {
            throw new IOException("Value out of expected range (" + index + ", max " + values.length + ")");
        }
        return values[index];
    }

    default public <T> T readNullable(T[] values) throws IOException {
        int index = this.readPackedUInt();
        if (index > values.length) {
            throw new IOException("Value out of expected range (" + index + ", max " + (values.length + 1) + ")");
        }
        if (--index < 0) {
            return null;
        }
        return values[index];
    }

    default public Point readPointShort() throws IOException {
        return MiscIO.readPointShort(this);
    }

    default public void readPointShort(Point p) throws IOException {
        MiscIO.readPointShort(this, p);
    }
}

