/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.event;

import com.iosoft.helpers.event.BaseEvent;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseEventSource<T, S extends BaseEvent<T>> {
    private final List<T> handlers = new LinkedList<T>();
    private final List<Runnable> toDoAfterFiring = new LinkedList<Runnable>();
    private boolean firing = false;
    public final S Event = this.createEvent();

    void register(T handler) {
        if (this.firing) {
            this.toDoAfterFiring.add(() -> this.register(handler));
        } else if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    protected abstract S createEvent();

    void unregister(T handler) {
        if (this.firing) {
            this.toDoAfterFiring.add(() -> this.unregister(handler));
        } else {
            this.handlers.remove(handler);
        }
    }

    public boolean isUsed() {
        return !this.handlers.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    protected void fireEvent() {
        if (this.firing) {
            throw new IllegalStateException("Cannot fire an event while it is being fired");
        }
        this.firing = true;
        try {
            for (T handler : this.handlers) {
                this.fireHandler(handler);
            }
        }
        finally {
            this.firing = false;
            ** for (toDo : this.toDoAfterFiring)
        }
lbl-1000:
        // 1 sources

        {
            toDo.run();
            continue;
        }
lbl14:
        // 1 sources

        this.toDoAfterFiring.clear();
    }

    protected abstract void fireHandler(T var1);
}

