/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MemorySource
implements IDataSource {
    private final byte[] _data;

    public MemorySource(byte[] data) {
        this._data = data;
    }

    @Override
    public void preload() {
    }

    @Override
    public Task<IOException> preloadAsync() {
        return new Task<Object>(null);
    }

    @Override
    public byte[] load(boolean cache) {
        return this._data;
    }

    @Override
    public Task<FailableResult<byte[], IOException>> loadAsync(boolean cache) {
        return new Task<FailableResult<byte[], IOException>>(new FailableResult(this._data));
    }

    @Override
    public void unload() {
    }

    @Override
    public InputStream openBufferedStream() {
        return new ByteArrayInputStream(this._data);
    }

    @Override
    public InputStream openBufferedStream(int size) {
        return this.openBufferedStream();
    }

    @Override
    public InputStream tryOpenBufferedStream() {
        return this.openBufferedStream();
    }

    public String toString() {
        return "[Byte Source (size=" + this._data.length + ")]";
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean doesExistsOpenTheStream() {
        return false;
    }
}

