/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.datasource;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractDataSource
implements IDataSource {
    private volatile byte[] _buffer;
    private Task<FailableResult<byte[], IOException>> _currentAsyncLoader;

    protected abstract byte[] read() throws IOException;

    protected abstract InputStream openInputStream() throws FileNotFoundException;

    @Override
    public void preload() throws IOException {
        this._buffer = this.read();
    }

    @Override
    public Task<IOException> preloadAsync() {
        if (this._buffer == null) {
            return this.loadAsync(true).awaitAndTranslate(x -> (IOException)x.Exception);
        }
        return new Task<Object>(null);
    }

    @Override
    public byte[] load(boolean cache) throws IOException {
        byte[] buffer = this._buffer;
        if (buffer != null) {
            return buffer;
        }
        buffer = this.read();
        if (cache) {
            this._buffer = buffer;
        }
        return buffer;
    }

    @Override
    public Task<FailableResult<byte[], IOException>> loadAsync(boolean cache) {
        if (this._buffer != null) {
            return new Task<FailableResult<byte[], IOException>>(new FailableResult(this._buffer));
        }
        if (this._currentAsyncLoader != null && this._currentAsyncLoader.isCancelled()) {
            this._currentAsyncLoader = null;
        }
        if (this._currentAsyncLoader == null) {
            this._currentAsyncLoader = Async.runAsyncWrap(this::read).awaitAndTranslate(x -> {
                this._currentAsyncLoader = null;
                return x;
            });
        }
        return this._currentAsyncLoader.awaitAndTranslate(result -> {
            if (cache && result.Value != null) {
                this._buffer = (byte[])result.Value;
            }
            return result;
        });
    }

    @Override
    public void unload() {
        this._buffer = null;
    }

    protected InputStream tryGetBufferStream() {
        byte[] buffer = this._buffer;
        return buffer == null ? null : new ByteArrayInputStream(buffer);
    }

    @Override
    public InputStream openBufferedStream() throws FileNotFoundException {
        InputStream in = this.tryGetBufferStream();
        return in != null ? in : new BufferedInputStream(this.openInputStream());
    }

    @Override
    public InputStream openBufferedStream(int size) throws FileNotFoundException {
        InputStream in = this.tryGetBufferStream();
        return in != null ? in : new BufferedInputStream(this.openInputStream(), size);
    }

    @Override
    public InputStream tryOpenBufferedStream() {
        InputStream in = this.tryGetBufferStream();
        if (in != null) {
            return in;
        }
        if (!this.doesExistsOpenTheStream() && !this.exists()) {
            return null;
        }
        try {
            return new BufferedInputStream(this.openInputStream());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

