/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.console;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.console.ConsoleReader;
import com.iosoft.helpers.console.IConsoleListener;
import com.iosoft.helpers.event.ArgEvent;
import com.iosoft.helpers.event.ArgEventSource;
import java.io.IOException;
import java.util.function.Consumer;

public class ConsoleMultiplexer
implements IDisposable {
    private final ArgEventSource<String> _lineRead = new ArgEventSource();
    public final ArgEvent<String> LineRead;
    private final ArgEventSource<IOException> _error;
    public final ArgEvent<IOException> Error;
    private Task<IOException> _consoleReader;
    private final IConsoleRegistrar _registrar;
    private final Dispatcher _dispatcher;
    private static ConsoleMultiplexer _currentGlobalMultiplexer;
    private static final Object _lock;

    static {
        _lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleMultiplexer(IConsoleRegistrar registrar) {
        this.LineRead = (ArgEvent)this._lineRead.Event;
        this._error = new ArgEventSource();
        this.Error = (ArgEvent)this._error.Event;
        this._dispatcher = Dispatcher.getForCurrentThread();
        this._registrar = Misc.notNull(registrar);
        Object object = _lock;
        synchronized (object) {
            this._consoleReader = ConsoleReader.readAsync(this::onReceiveConsole);
            this._consoleReader.await((IOException)((Object)((Consumer<IOException>)this::onConsoleError)));
            if (_currentGlobalMultiplexer == null) {
                _currentGlobalMultiplexer = this;
            }
        }
    }

    private void onReceiveConsole(String line) {
        this._lineRead.fire(line);
    }

    private void onConsoleError(IOException e) {
        this._consoleReader = null;
        this._error.fire(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = _lock;
        synchronized (object) {
            if (_currentGlobalMultiplexer == this) {
                _currentGlobalMultiplexer = null;
            }
        }
        if (this._consoleReader != null) {
            this._consoleReader.cancel();
            this._consoleReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<IDisposable> tryConnectToGlobalMultiplexerAsync(IConsoleListener listener) {
        ConsoleMultiplexer multiplexer;
        Object object = _lock;
        synchronized (object) {
            multiplexer = _currentGlobalMultiplexer;
        }
        if (multiplexer == null) {
            return null;
        }
        return multiplexer._dispatcher.dispatchAsync(() -> consoleMultiplexer._registrar.onConsoleConnect(listener)).awaitAndContinue(() -> () -> consoleMultiplexer._dispatcher.dispatch(() -> consoleMultiplexer._registrar.onConsoleDisconnect(listener)));
    }

    public static interface IConsoleRegistrar {
        public void onConsoleConnect(IConsoleListener var1);

        public void onConsoleDisconnect(IConsoleListener var1);
    }
}

