/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.binding;

import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.binding.ListChangedArgs;
import com.iosoft.helpers.event.ArgEvent;
import com.iosoft.helpers.event.ArgEventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ObservableList<T>
implements Iterable<T> {
    private final List<T> _list = new ArrayList<T>();
    private final ArgEventSource<ListChangedArgs<T>> _source = new ArgEventSource();
    public final ArgEvent<ListChangedArgs<T>> Changed;

    public ObservableList() {
        this.Changed = (ArgEvent)this._source.Event;
    }

    public void add(T item) {
        this._list.add(item);
        this.fire(ListChangedArgs.ChangeType.Added, this._list.size() - 1, 1, item);
    }

    public boolean remove(T item) {
        int index = this._list.indexOf(item);
        if (index == -1) {
            return false;
        }
        this._list.remove(index);
        this.fire(ListChangedArgs.ChangeType.Removed, index, 1, item);
        return true;
    }

    public void clear() {
        int num = this._list.size();
        if (num == 0) {
            return;
        }
        this._list.clear();
        this.fire(ListChangedArgs.ChangeType.IntervalRemoved, 0, num, null);
    }

    public void addAll(Collection<T> source) {
        int num = source.size();
        if (num == 0) {
            return;
        }
        if (num == 1) {
            this.add(MiscLINQ.first(source));
            return;
        }
        int start = this._list.size();
        this._list.addAll(source);
        this.fire(ListChangedArgs.ChangeType.IntervalAdded, start, num, null);
    }

    public int size() {
        return this._list.size();
    }

    public T get(int index) {
        return this._list.get(index);
    }

    protected void fire(ListChangedArgs.ChangeType type, int index, int length, T obj) {
        if (this._source.isUsed()) {
            this._source.fire(new ListChangedArgs<T>(this, type, index, length, obj));
        }
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> listIterator = this._list.iterator();
        return new Iterator<T>(){
            int index = -1;
            T lastElement;

            @Override
            public boolean hasNext() {
                return listIterator.hasNext();
            }

            @Override
            public T next() {
                ++this.index;
                this.lastElement = listIterator.next();
                return this.lastElement;
            }

            @Override
            public void remove() {
                listIterator.remove();
                ObservableList.this.fire(ListChangedArgs.ChangeType.Removed, this.index, 1, this.lastElement);
                --this.index;
            }
        };
    }
}

