/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.binding;

import com.iosoft.helpers.BoolConsumer;
import com.iosoft.helpers.BoolPredicate;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.binding.BaseObservable;
import com.iosoft.helpers.binding.BoolBinding;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.event.BoolEvent;
import com.iosoft.helpers.event.BoolEventSource;

public class BoolObservable
extends BaseObservable<BoolConsumer, BoolPredicate, BoolEventSource, BoolEvent> {
    public static final BoolObservable AlwaysTrue = new MyBoolObservable((boolean)true).Getter;
    public static final BoolObservable AlwaysFalse = new MyBoolObservable((boolean)false).Getter;
    private boolean value;

    void set(boolean val, boolean forceUpdate) {
        if (forceUpdate || val != this.value) {
            this.value = val;
            if (((BoolEventSource)this.source).isUsed()) {
                ((BoolEventSource)this.source).fire(val);
            }
        }
    }

    public BoolBinding bind(BoolConsumer consumer) {
        return new BoolBinding(this, consumer);
    }

    @Override
    protected BoolEventSource createEventSource() {
        return new BoolEventSource();
    }

    @Override
    protected IDisposable createChangedHandler(Runnable run) {
        return ((BoolEvent)this.Changed).registerHandler(x -> run.run());
    }

    @Override
    protected boolean test(BoolPredicate checker) {
        return checker.test(this.value);
    }

    public boolean get() {
        return this.value;
    }
}

