/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async.dispatcher;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.dispatcher.BufferedDispatcher;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class EDTDispatcher
extends BufferedDispatcher {
    private static EDTDispatcher instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EDTDispatcher initialize() {
        Class<EDTDispatcher> clazz = EDTDispatcher.class;
        synchronized (EDTDispatcher.class) {
            EDTDispatcher dispatcher;
            if (instance != null) {
                throw new IllegalStateException("EDTDispatcher already initialized");
            }
            instance = dispatcher = new EDTDispatcher();
            // ** MonitorExit[var1] (shouldn't be in output)
            if (SwingUtilities.isEventDispatchThread()) {
                dispatcher.initializeInEDT();
            } else {
                dispatcher.dispatch(dispatcher::initializeInEDT);
            }
            return dispatcher;
        }
    }

    private void initializeInEDT() {
        ThreadDispatcher.set(this);
    }

    @Override
    public void setUnhandledExceptionHandler(Consumer<Throwable> handler) {
        super.setUnhandledExceptionHandler(handler);
        EDTDispatcher.setCurrentThreadUnhandledExceptionHandler(handler);
    }

    private EDTDispatcher() {
    }

    @Override
    protected void startDispatching(Runnable dispatchMe) {
        SwingUtilities.invokeLater(dispatchMe);
    }

    private Pair<Timer, IDisposable> createTimer(double timeInSeconds, Runnable onDone) {
        MutableBool active = new MutableBool(true);
        Timer timer = new Timer(Misc.secondsToMillis(timeInSeconds), evt -> {
            if (mutableBool.Value) {
                ThreadDispatcher.set(this);
                this.runSafe(onDone);
            }
        });
        return new Pair<Timer, IDisposable>(timer, () -> {
            mutableBool.Value = false;
            timer.stop();
        });
    }

    @Override
    public IDisposable delay(double timeInSeconds, Runnable runner) {
        Pair<Timer, IDisposable> pair = this.createTimer(timeInSeconds, runner);
        ((Timer)pair.V1).setRepeats(false);
        ((Timer)pair.V1).start();
        return (IDisposable)pair.V2;
    }

    @Override
    public IDisposable repeat(double secondsBetween, Runnable runner) {
        Pair<Timer, IDisposable> pair = this.createTimer(secondsBetween, runner);
        ((Timer)pair.V1).setInitialDelay(0);
        ((Timer)pair.V1).start();
        return (IDisposable)pair.V2;
    }
}

