/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async.dispatcher;

import com.iosoft.helpers.Blocker;
import com.iosoft.helpers.DisposableWrapper;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.VWaiter;
import com.iosoft.helpers.Waiter;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskBase;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.TaskSourceBase;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.async.dispatcher.DaemonThreadWorkDistributor;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;
import com.iosoft.helpers.async.dispatcher.WorkDistributor;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Dispatcher {
    protected WorkDistributor _workDistributor = new DaemonThreadWorkDistributor(this);
    private Consumer<Throwable> _unhandledExceptionHandler;
    protected int _numKeepAliveTokens = 0;
    protected static final ThreadLocal<Dispatcher> ThreadDispatcher = new ThreadLocal();

    public static Dispatcher getForCurrentThread() {
        Dispatcher dispatcher = ThreadDispatcher.get();
        if (dispatcher == null) {
            throw new IllegalStateException("No dispatcher set for this thread");
        }
        return dispatcher;
    }

    public void dispatch(Runnable run) {
        this.dispatchImpl(() -> this.runSafe(run));
    }

    protected abstract void dispatchImpl(Runnable var1);

    public void handleUnhandledException(Throwable e) {
        if (this._unhandledExceptionHandler != null) {
            this._unhandledExceptionHandler.accept(e);
        } else {
            Thread myThread = Thread.currentThread();
            Thread.UncaughtExceptionHandler handler = myThread.getUncaughtExceptionHandler();
            if (handler == null) {
                handler = Thread.getDefaultUncaughtExceptionHandler();
            }
            if (handler == null) {
                e.printStackTrace();
            } else {
                handler.uncaughtException(myThread, e);
            }
        }
    }

    protected void runSafe(Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            this.handleUnhandledException(t);
        }
    }

    public abstract IDisposable delay(double var1, Runnable var3);

    public IDisposable repeat(final Supplier<Double> doAndRepeat) {
        final DisposableWrapper wrapper = new DisposableWrapper();
        final MutableBool stopped = new MutableBool(false);
        new Runnable(){

            @Override
            public void run() {
                wrapper.Object = null;
                Double time = (Double)doAndRepeat.get();
                if (time != null && !stopped.Value) {
                    wrapper.Object = Dispatcher.this.delay(time, this);
                }
            }
        }.run();
        return () -> {
            mutableBool.Value = true;
            wrapper.dispose();
        };
    }

    public IDisposable repeat(double secondsBetween, Runnable runner) {
        MutableBool stopped = new MutableBool(false);
        MutableBool firstRun = new MutableBool(true);
        this.repeat(() -> {
            if (mutableBool.Value) {
                return null;
            }
            if (mutableBool2.Value) {
                mutableBool2.Value = false;
            } else {
                runner.run();
            }
            return secondsBetween;
        });
        return () -> {
            boolean bl = mutableBool.Value = true;
        };
    }

    public VWaiter dispatchCreateWaiter(Runnable action) {
        return this.dispatchCreateWaiter((Runnable x) -> {
            try {
                action.run();
            }
            finally {
                x.run();
            }
        });
    }

    public VWaiter dispatchCreateWaiter(Consumer<Runnable> action) {
        final Blocker blocker = new Blocker();
        Runnable invokeWhenDone = new Runnable(){
            boolean called = false;

            @Override
            public void run() {
                if (this.called) {
                    throw new IllegalStateException("Continuer already called");
                }
                this.called = true;
                blocker.fulfill();
            }
        };
        this.dispatch(() -> action.accept(invokeWhenDone));
        return blocker;
    }

    public <T> Waiter<T> dispatchCreateGetWaiter(Supplier<T> run) {
        Mutable result = new Mutable();
        return this.dispatchCreateWaiter(() -> {
            mutable.Value = run.get();
            Object t = mutable.Value;
        }).withResult(() -> mutable.Value);
    }

    public <T> Waiter<T> dispatchCreateGetWaiter(Consumer<Consumer<T>> run) {
        Mutable result = new Mutable();
        return this.dispatchCreateWaiter((Runnable continuer) -> run.accept(x -> {
            mutable.Value = x;
            continuer.run();
        })).withResult(() -> mutable.Value);
    }

    public VTask dispatchAsync(Runnable runner) {
        return this.dispatchAsync2(x -> {
            runner.run();
            x.run();
        });
    }

    public <T> Task<T> dispatchAsync(Supplier<T> runner) {
        return this.dispatchAsync((Consumer<T> x) -> x.accept(runner.get()));
    }

    public <T> Task<T> dispatchAsync(Consumer<Consumer<T>> runner) {
        TaskSource taskSource = new TaskSource();
        return (Task)this.dispatchAsync(doneSignaler -> runner.accept(result -> doneSignaler.accept(() -> taskSource.setResult(result))), taskSource);
    }

    private <T extends TaskBase<S>, S, V> T dispatchAsync(Consumer<Consumer<Runnable>> runner, TaskSourceBase<T, S> taskSource) {
        Object task = taskSource.getTask();
        Dispatcher currentDispatcher = Dispatcher.getForCurrentThread();
        Consumer<Runnable> doneSignaler = x -> currentDispatcher.dispatch(() -> {
            if (!task.isCancelled()) {
                x.run();
            }
        });
        this.dispatch(() -> runner.accept(doneSignaler));
        return task;
    }

    public VTask dispatchAsync2(Consumer<Runnable> runner) {
        VTaskSource taskSource = new VTaskSource();
        return this.dispatchAsync(doneSignaller -> runner.accept(() -> doneSignaller.accept(taskSource::setFulfilled)), taskSource);
    }

    public final <T> Runnable runWorker(Supplier<T> work, Consumer<T> onDone, String activity, float secondsUntilAsync) {
        return this.runWorker(work, onDone, null, activity, secondsUntilAsync);
    }

    public final <T> Runnable runWorker(Supplier<T> work, Consumer<T> onDone, Consumer<T> handleCancelled, String activity, float secondsUntilAsync) {
        return this._workDistributor.runWorker(work, onDone, handleCancelled, activity, secondsUntilAsync);
    }

    public final <T, V> Runnable runWorkerWithInterimResults(Function<Consumer<V>, T> work, Consumer<List<V>> onInterimResult, Consumer<T> onDone, String activity, float secondsUntilAsync) {
        return this._workDistributor.runWorkerWithInterimResults(work, onInterimResult, onDone, activity, secondsUntilAsync);
    }

    public void setMainUnhandledExceptionHandler(Consumer<Throwable> handler) {
        this.setUnhandledExceptionHandler(handler);
        if (handler != null) {
            Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> this.dispatch(() -> this.handleUnhandledException(new WrapException("Unhandled exception in thread " + thread.getName(), ex))));
        } else {
            Thread.setDefaultUncaughtExceptionHandler(null);
        }
    }

    public void setUnhandledExceptionHandler(Consumer<Throwable> handler) {
        this._unhandledExceptionHandler = handler;
    }

    protected static void setCurrentThreadUnhandledExceptionHandler(Consumer<Throwable> handler) {
        Thread.UncaughtExceptionHandler ueh = handler != null ? (thread, ex) -> handler.accept(ex) : null;
        Thread.currentThread().setUncaughtExceptionHandler(ueh);
    }

    public DispatcherKeepAliveToken createKeepAliveToken() {
        DispatcherKeepAliveToken token = new DispatcherKeepAliveToken(this);
        ++this._numKeepAliveTokens;
        return token;
    }

    protected void unregisterKeepaliveToken() {
        if (this._numKeepAliveTokens == 0) {
            throw new IllegalStateException("Something went horribly wrong");
        }
        --this._numKeepAliveTokens;
    }

    void unregisterKeepaliveToken(DispatcherKeepAliveToken a) {
        this.unregisterKeepaliveToken();
    }
}

