/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskBase;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class VTask
extends TaskBase<Runnable> {
    public static final VTask COMPLETED_TASK = new VTask();

    public VTask(Runnable cancelHandler, Consumer<Runnable> resultSetter) {
        super(cancelHandler, resultSetter);
    }

    public VTask() {
    }

    @Override
    protected Runnable getCompleter(Runnable complete) {
        return complete;
    }

    @Override
    protected void call(Runnable runner) {
        runner.run();
    }

    public static VTask yield() {
        return VTask.delay(0.0);
    }

    public static VTask runAsync(Runnable runner) {
        return VTask.runHybridAsync(runner, 0.0f);
    }

    public static VTask runHybridAsync(Runnable runner, float secondsBeforeAsync) {
        VTaskSource taskSource = new VTaskSource();
        taskSource.CancelHandler = Dispatcher.getForCurrentThread().runWorker(() -> {
            runner.run();
            return null;
        }, x -> taskSource.setFulfilled(), null, secondsBeforeAsync);
        return (VTask)taskSource.getTask();
    }

    public static VTask delay(double seconds) {
        VTaskSource taskSource = new VTaskSource();
        VTask task = (VTask)taskSource.getTask();
        taskSource.CancelHandler = Dispatcher.getForCurrentThread().delay(seconds, taskSource::setFulfilled)::dispose;
        return task;
    }

    public static VTask delay(Duration duration) {
        return VTask.delay((double)duration.toMillis() / 1000.0);
    }

    public <S> Task<S> awaitAndContinue(Supplier<S> handler) {
        TaskSource taskSource = new TaskSource(this::cancelIfRunning);
        this.await(() -> taskSource.setResult(handler.get()));
        return (Task)taskSource.getTask();
    }

    public VTask awaitAndContinue(Runnable handler) {
        VTaskSource taskSource = new VTaskSource(this::cancelIfRunning);
        this.await(() -> {
            vTaskSource.CancelHandler = null;
            handler.run();
            if (!((VTask)taskSource.getTask()).isCancelled()) {
                taskSource.setFulfilled();
            }
        });
        return (VTask)taskSource.getTask();
    }

    public <S> Task<S> awaitAndContinueTask(Supplier<Task<S>> handler) {
        TaskSource taskSource = new TaskSource(this::cancelIfRunning);
        this.await(() -> {
            taskSource.CancelHandler = null;
            Task task = (Task)handler.get();
            taskSource.CancelHandler = task::cancelIfRunning;
            task.await(taskSource::setResult);
        });
        return (Task)taskSource.getTask();
    }

    public VTask awaitAndContinueVTask(Supplier<VTask> handler) {
        VTaskSource taskSource = new VTaskSource(this::cancelIfRunning);
        this.await(() -> {
            VTask task = (VTask)handler.get();
            vTaskSource.CancelHandler = task::cancelIfRunning;
            task.await(() -> {
                Runnable runnable = vTaskSource.CancelHandler = null;
            });
            task.await(taskSource::setFulfilled);
        });
        return (VTask)taskSource.getTask();
    }
}

