/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;

public final class Ticker {
    private final String name;
    private final Object lock = new Object();
    private final Runnable clientMethod;
    private final Runnable invokeDispatcher;
    private final Dispatcher dispatcher;
    private volatile Worker lastWorker;
    private long currentSyncNumber;
    private long workerSyncNumber;
    private double _tps;
    private long timeLastCall;
    public boolean Daemon = false;
    public double AutoSyncSeconds = 1.0;
    public boolean ShouldYield = false;

    public Ticker(String name, double tps, Runnable runner) {
        this.name = name;
        this._tps = tps;
        this.dispatcher = Dispatcher.getForCurrentThread();
        this.clientMethod = runner;
        this.invokeDispatcher = this::onDispatchedTick;
    }

    private void onTickWaitBlocking() {
        this.dispatcher.dispatchCreateWaiter(this.invokeDispatcher).waitBlocking();
    }

    private void onDispatchedTick() {
        if (this.lastWorker == null || this.workerSyncNumber != this.currentSyncNumber) {
            return;
        }
        if (this.AutoSyncSeconds > 0.0) {
            long now = Stopwatch.start();
            if (Stopwatch.getSeconds(this.timeLastCall, now) >= this.AutoSyncSeconds) {
                this.sync();
                Log.General.warning("Ticker '" + this.name + "' is dropping ticks! Missing interval: " + Stopwatch.getMillis(this.timeLastCall, now) + " ms");
            }
            this.timeLastCall = now;
        }
        this.clientMethod.run();
    }

    private void onSync_inLock() {
        long knownSyncNumber = this.currentSyncNumber;
        this.dispatcher.dispatch(() -> {
            long l2 = this.workerSyncNumber = knownSyncNumber;
        });
    }

    public void setTicksPerSecond(double tps) {
        this.setTicksPerSecond(tps, 1.0 / tps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicksPerSecond(double tps, double sec_initialDelay) {
        this._tps = tps;
        Object object = this.lock;
        synchronized (object) {
            if (this.lastWorker != null) {
                this.lastWorker.resync(tps, sec_initialDelay, false);
            }
        }
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean compensate) {
        this.start(compensate, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean compensate, double sec_initialDelay) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastWorker != null) {
                throw new IllegalStateException("Already running");
            }
            this.timeLastCall = Stopwatch.start();
            this.workerSyncNumber = this.currentSyncNumber;
            this.lastWorker = new Worker(compensate, this._tps, sec_initialDelay, this.Daemon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastWorker != null) {
                this.lastWorker.stop();
                this.lastWorker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Object object = this.lock;
        synchronized (object) {
            ++this.currentSyncNumber;
            if (this.lastWorker != null) {
                this.lastWorker.resync();
            }
        }
    }

    private final class SyncInfo {
        public final double TicksPerSecond;
        public final double Sec_InitialDelay;
        public final boolean DroppedTicks;

        SyncInfo(double tps, double sec_initialDelay, boolean droppedTicks) {
            this.TicksPerSecond = tps;
            this.Sec_InitialDelay = sec_initialDelay;
            this.DroppedTicks = droppedTicks;
        }
    }

    private class Worker {
        private volatile boolean _running = true;
        private volatile SyncInfo _syncInfo;
        private final boolean _compensate;
        private final boolean _yields;
        private final DispatcherKeepAliveToken keepAliveToken;
        private final Thread _thread;

        Worker(boolean compensate, double tps, double sec_initialDelay, boolean daemon) {
            this.keepAliveToken = Ticker.this.dispatcher.createKeepAliveToken();
            this._yields = Ticker.this.ShouldYield;
            this._compensate = compensate;
            this._syncInfo = new SyncInfo(tps, sec_initialDelay, true);
            this._thread = new Thread(this::run, Ticker.this.name == null ? "Ticker" : Ticker.this.name);
            this._thread.setDaemon(daemon);
            this._thread.start();
        }

        public void resync() {
            this.resync(Ticker.this._tps, 0.0, true);
        }

        private void resync(double tps, double sec_initialDelay, boolean droppedTicks) {
            this._syncInfo = new SyncInfo(tps, sec_initialDelay, droppedTicks);
            this._thread.interrupt();
        }

        public void stop() {
            this._running = false;
            this._thread.interrupt();
        }

        private void onEnded() {
            this.keepAliveToken.dispose();
        }

        private void run() {
            try {
                if (this._compensate) {
                    this.runCompensated();
                } else {
                    this.runUncompensated();
                }
            }
            finally {
                Ticker.this.dispatcher.dispatch(this::onEnded);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCompensated() {
            long sw_start;
            long sw_lastTick = sw_start = Stopwatch.start();
            long ticksProcessed = 0L;
            double tps = 1.0;
            boolean sleptLastTime = false;
            while (this._running) {
                long sw_nextTick;
                long nanosToSleep;
                long msToSleep;
                long sw_now = Stopwatch.start();
                if (this._syncInfo != null) {
                    Object object = Ticker.this.lock;
                    synchronized (object) {
                        tps = this._syncInfo.TicksPerSecond;
                        sw_start = (this._syncInfo.DroppedTicks ? sw_now : sw_lastTick) + Stopwatch.fromSeconds(this._syncInfo.Sec_InitialDelay);
                        ticksProcessed = 0L;
                        this._syncInfo = null;
                        Ticker.this.onSync_inLock();
                    }
                }
                if ((msToSleep = Stopwatch.toMillis(nanosToSleep = (sw_nextTick = sw_start + Stopwatch.fromSeconds((double)ticksProcessed / tps)) - sw_now)) <= 0L) {
                    sw_lastTick = sw_nextTick;
                    if (sleptLastTime) {
                        sleptLastTime = false;
                    } else if (this._yields) {
                        Thread.yield();
                    }
                    Ticker.this.onTickWaitBlocking();
                    if (ticksProcessed == Integer.MAX_VALUE) {
                        ticksProcessed = 0L;
                        sw_start = sw_now;
                    }
                    ++ticksProcessed;
                    continue;
                }
                sleptLastTime = true;
                try {
                    Thread.sleep(msToSleep, (int)(nanosToSleep % 1000000L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runUncompensated() {
            long nanosMaxTimeBetweenFrames = 0L;
            long nanoBuffer = 0L;
            long swAfterSleep = Stopwatch.start();
            while (this._running) {
                long swBeforeSleep;
                long nanoSleep;
                Thread.interrupted();
                Ticker.this.onTickWaitBlocking();
                if (this._syncInfo != null) {
                    Object object = Ticker.this.lock;
                    synchronized (object) {
                        nanosMaxTimeBetweenFrames = Stopwatch.fromSeconds(1.0 / this._syncInfo.TicksPerSecond);
                        this._syncInfo = null;
                        Ticker.this.onSync_inLock();
                    }
                }
                if ((nanoSleep = nanoBuffer + nanosMaxTimeBetweenFrames - ((swBeforeSleep = Stopwatch.start()) - swAfterSleep)) < 0L) {
                    nanoSleep = 0L;
                }
                long msSleep = nanoSleep / 1000000L;
                nanoBuffer = nanoSleep % 1000000L;
                Thread.interrupted();
                if (!this._running) break;
                try {
                    if (msSleep > 0L) {
                        Thread.sleep(msSleep);
                    } else if (this._yields) {
                        Thread.yield();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                swAfterSleep = Stopwatch.start();
                nanoBuffer += msSleep * 1000000L - (swAfterSleep - swBeforeSleep);
            }
        }
    }
}

