/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.async.AsyncWorker;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSource;

public abstract class TaskWorker<T> {
    protected final TaskSource<T> taskSource;
    protected final AsyncWorker<T> asyncWorker;

    public TaskWorker(String threadName) {
        this.asyncWorker = new AsyncWorker<T>(threadName){

            @Override
            protected T doWork() {
                return TaskWorker.this.doWork();
            }

            @Override
            protected void onDone(T result) {
                TaskWorker.this.onDone(result);
            }

            @Override
            protected void onAbort() {
                super.onAbort();
                TaskWorker.this.onAbort();
            }

            @Override
            protected void handleCancelled(T result) {
                TaskWorker.this.handleCancelled(result);
            }
        };
        this.taskSource = new TaskSource(this.asyncWorker::abort);
    }

    public TaskWorker() {
        this(null);
    }

    protected abstract T doWork();

    protected void handleCancelled(T result) {
    }

    protected void onAbort() {
    }

    protected void onDone(T result) {
        this.taskSource.setResult(result);
    }

    public Task<T> startTask() {
        this.asyncWorker.execute();
        return (Task)this.taskSource.getTask();
    }
}

