/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AsyncWorker<T> {
    protected final Dispatcher dispatcher = Dispatcher.getForCurrentThread();
    protected final String threadName;
    private boolean started;
    private Runnable aborter;

    public AsyncWorker(String threadName) {
        this.threadName = threadName;
    }

    public void abort() {
        if (this.aborter == null) {
            throw new IllegalStateException("Cannot abort a worker that is not working");
        }
        this.onAbort();
    }

    protected void onAbort() {
        this.aborter.run();
        this.aborter = null;
    }

    protected void post(Runnable action) {
        this.post(action, null);
    }

    protected void post(Runnable action, Runnable onCancelled) {
        Misc.notNull(action, "action");
        this.dispatcher.dispatch(() -> {
            if (this.aborter != null) {
                action.run();
            } else if (onCancelled != null) {
                onCancelled.run();
            }
        });
    }

    protected void postBlocking(Consumer<Runnable> action) throws InterruptedException {
        this.postBlocking(action, null);
    }

    protected void postBlocking(Consumer<Runnable> action, Consumer<Runnable> onCancelled) throws InterruptedException {
        Misc.notNull(action, "action");
        this.dispatcher.dispatchCreateWaiter(continuer -> {
            if (this.aborter != null) {
                action.accept((Runnable)continuer);
            } else if (onCancelled != null) {
                onCancelled.accept((Runnable)continuer);
            }
        }).waitBlockingInterruptible();
    }

    protected void postBlocking(Supplier<VTask> action) throws InterruptedException {
        Misc.notNull(action);
        this.dispatcher.dispatchCreateWaiter(continuer -> {
            if (this.aborter != null) {
                ((VTask)action.get()).await(continuer);
            }
        }).waitBlockingInterruptible();
    }

    protected <V> V postBlockingGet(Supplier<V> supplier) throws InterruptedException {
        Mutable wrapper = new Mutable();
        this.postBlocking((Runnable x) -> {
            mutable.Value = supplier.get();
            x.run();
        });
        return (V)wrapper.Value;
    }

    public boolean isRunning() {
        return this.aborter != null;
    }

    protected abstract T doWork();

    protected abstract void onDone(T var1);

    protected void handleCancelled(T result) {
    }

    public void execute() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        this.aborter = this.executeImpl(x -> {
            this.aborter = null;
            this.onDone(x);
        });
    }

    protected Runnable executeImpl(Consumer<T> onDone) {
        return this.dispatcher.runWorker(this::doWork, onDone, this::handleCancelled, this.threadName, 0.0f);
    }
}

