/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.MutableInt;
import com.iosoft.helpers.ThrowingRunnable;
import com.iosoft.helpers.ThrowingSupplier;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.TaskSourceBase;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Async {
    private Async() {
    }

    public static VTask whileDo(Supplier<VTask> supplier) {
        return Async.loop(() -> {
            VTask task = (VTask)supplier.get();
            if (task == null) {
                return null;
            }
            return task.awaitAndContinue(() -> null);
        }, x -> null).awaitAndContinue(x -> {});
    }

    public static VTask whileTrue(Supplier<Task<Boolean>> supplier) {
        MutableBool isRunning = new MutableBool(true);
        return Async.whileDo(() -> {
            if (!mutableBool.Value) {
                return null;
            }
            return ((Task)supplier.get()).awaitAndContinue(x -> {
                boolean bl = mutableBool.Value = x.booleanValue();
            });
        });
    }

    public static <D, V> VTask forEach(D[] enumeration, Function<D, Task<V>> taskMaker, Consumer<V> delegate) {
        return Async.forEach(Arrays.asList(enumeration), taskMaker, delegate);
    }

    public static <D, V> VTask forEach(Iterable<D> enumeration, Function<D, Task<V>> taskMaker, Consumer<V> delegate) {
        Misc.notNull(enumeration);
        Misc.notNull(taskMaker);
        Misc.notNull(delegate);
        return Async.forEachEx(enumeration, taskMaker, (V x) -> {
            delegate.accept(x);
            return null;
        }).awaitAndContinue(x -> {});
    }

    public static <D> VTask forEach(Iterable<D> enumeration, Function<D, VTask> taskMaker) {
        return Async.forEach(enumeration, (D x) -> ((VTask)taskMaker.apply(x)).awaitAndContinue(() -> x), (V x) -> {});
    }

    public static <D> VTask forEach(D[] enumeration, Function<D, VTask> taskMaker) {
        return Async.forEach(enumeration, (D x) -> ((VTask)taskMaker.apply(x)).awaitAndContinue(() -> x), (V x) -> {});
    }

    public static <D, V, T> Task<T> forEachEx(Iterable<D> enumeration, Function<D, Task<V>> taskMaker, Function<V, T> delegate) {
        Iterator iterator = enumeration.iterator();
        return Async.loop(() -> {
            if (iterator.hasNext()) {
                return (Task)taskMaker.apply(iterator.next());
            }
            return null;
        }, delegate);
    }

    public static <D, V, T> Task<T> forEachEx(D[] enumeration, Function<D, Task<V>> taskMaker, Function<V, T> delegate) {
        return Async.forEachEx(Arrays.asList(enumeration), taskMaker, delegate);
    }

    private static <V, T> Task<T> loop(final Supplier<Task<V>> taskMaker, final Function<V, T> delegate) {
        final TaskSource taskSource = new TaskSource();
        final Task myTask = (Task)taskSource.getTask();
        new Runnable(){
            private V lastResult;
            private RunState runState = RunState.NOT_RUNNING;

            @Override
            public void run() {
                Task task;
                while ((task = (Task)taskMaker.get()) != null) {
                    taskSource.CancelHandler = task::cancelIfRunning;
                    this.runState = RunState.RUNNING;
                    task.await(result -> {
                        if (this.runState == RunState.RUNNING) {
                            this.runState = RunState.AWAITED;
                            this.lastResult = result;
                            return;
                        }
                        if (myTask.isCancelled()) {
                            return;
                        }
                        Object earlyResult = delegate.apply(result);
                        if (earlyResult != null && !myTask.isCancelled()) {
                            taskSource.setResult(earlyResult);
                        } else {
                            this.run();
                        }
                    });
                    if (this.runState != RunState.AWAITED) {
                        this.runState = RunState.NOT_RUNNING;
                        return;
                    }
                    if (myTask.isCancelled()) {
                        return;
                    }
                    Object earlyResult = delegate.apply(this.lastResult);
                    if (earlyResult == null || myTask.isCancelled()) continue;
                    taskSource.setResult(earlyResult);
                    return;
                }
                if (!myTask.isCancelled()) {
                    taskSource.setResult(null);
                }
            }
        }.run();
        return (Task)taskSource.getTask();
    }

    public static <R, E extends Exception> FailableResult<R, E> wrapException(ThrowingSupplier<R, E> action) {
        try {
            return new FailableResult<R, Object>(action.get(), null);
        }
        catch (Exception ex) {
            return new FailableResult<Object, Exception>(null, ex);
        }
    }

    public static <E extends Exception> E wrapException(ThrowingRunnable<E> action) {
        try {
            action.run();
        }
        catch (Exception ex) {
            return (E)ex;
        }
        return null;
    }

    public static <R, E extends Exception> Task<FailableResult<R, E>> runAsyncWrap(ThrowingSupplier<R, E> action) {
        return Task.runAsync(() -> Async.wrapException(action));
    }

    public static <E extends Exception> Task<E> runAsyncWrap(ThrowingRunnable<E> action) {
        return Task.runAsync(() -> Async.wrapException(action));
    }

    public static <R, E extends Exception> Task<R> runAsyncEnforced(ThrowingSupplier<R, E> action) {
        return Async.enforce(Task.runAsync(() -> Async.wrapException(action)));
    }

    public static <E extends Exception> VTask runAsyncEnforced(ThrowingRunnable<E> action) {
        return Task.runAsync(() -> Async.wrapException(action)).awaitAndContinue(WrapException::throwIfNotNull);
    }

    public static <R, E extends Throwable> Task<R> enforce(Task<FailableResult<R, E>> task) {
        return task.awaitAndTranslate(x -> {
            WrapException.throwIfNotNull(x.Exception);
            return x.Value;
        });
    }

    public static <E extends Throwable> VTask enforceV(Task<E> task) {
        return task.awaitAndContinue(WrapException::throwIfNotNull);
    }

    public static VTask awaitAll(boolean cancelUnderlying, VTask ... tasks) {
        return Async.awaitAll(cancelUnderlying, Arrays.asList(tasks));
    }

    public static VTask awaitAll(boolean cancelUnderlying, List<VTask> tasks) {
        VTaskSource taskSource = Async.setupMultiSource(cancelUnderlying, tasks);
        VTask myTask = (VTask)taskSource.getTask();
        MutableInt numReady = new MutableInt(0);
        for (VTask task : tasks) {
            task.await(() -> {
                if (myTask.isRunning() && ++mutableInt.Value == tasks.size()) {
                    taskSource.setFulfilled();
                }
            });
        }
        return myTask;
    }

    public static VTask awaitAny(boolean cancelUnderlying, VTask ... tasks) {
        return Async.awaitAny(cancelUnderlying, Arrays.asList(tasks));
    }

    public static VTask awaitAny(boolean cancelUnderlying, List<VTask> tasks) {
        VTaskSource taskSource = Async.setupMultiSource(cancelUnderlying, tasks);
        VTask myTask = (VTask)taskSource.getTask();
        for (VTask task : tasks) {
            task.await(() -> {
                if (myTask.isRunning()) {
                    taskSource.setFulfilled();
                }
            });
        }
        return myTask;
    }

    private static VTaskSource setupMultiSource(boolean cancelUnderlying, List<VTask> tasks) {
        VTaskSource taskSource = new VTaskSource();
        if (cancelUnderlying) {
            taskSource.CancelHandler = () -> {
                for (VTask task : tasks) {
                    task.cancelIfRunning();
                }
            };
        }
        return taskSource;
    }

    public static <T> Task<T> fromFuture(CompletableFuture<T> future) {
        return Async.fromFuture(future, (result, exception) -> {
            if (exception == null) {
                return result;
            }
            throw new RuntimeException("Error occured when awaiting a future", (Throwable)exception);
        });
    }

    private static <T, R> Task<T> fromFuture(CompletableFuture<R> future, BiFunction<R, Throwable, T> mapResult) {
        TaskSource taskSource = new TaskSource(() -> {
            boolean bl = future.cancel(true);
        });
        Dispatcher dispatcher = Dispatcher.getForCurrentThread();
        DispatcherKeepAliveToken token = dispatcher.createKeepAliveToken();
        Task task = (Task)taskSource.getTask();
        future.whenCompleteAsync((result, exception) -> {
            if (exception instanceof CancellationException) {
                dispatcher.dispatch(() -> {
                    try {
                        task.cancelIfRunning();
                    }
                    finally {
                        token.dispose();
                    }
                });
            } else {
                dispatcher.dispatch(() -> {
                    try {
                        taskSource.setResult(mapResult.apply((Object)result, (Throwable)exception));
                    }
                    finally {
                        token.dispose();
                    }
                });
            }
        });
        return task;
    }

    public static <T, E extends Throwable> Task<FailableResult<T, E>> fromFailableFuture(CompletableFuture<T> future) {
        return Async.fromFuture(future, (result, exception) -> new FailableResult<Object, Throwable>(result, (Throwable)exception));
    }

    public static <T> CompletableFuture<T> toFuture(Task<T> task) {
        CompletableFuture future = new CompletableFuture();
        task.await(future::complete);
        return future;
    }

    public static <T> CompletableFuture<T> toFailableFuture(Task<? extends FailableResult<T, ? extends Throwable>> task) {
        CompletableFuture future = new CompletableFuture();
        task.await((FailableResult<Consumer<FailableResult>, Throwable>)((Object)((Consumer<FailableResult>)result -> {
            if (result.Exception == null) {
                future.complete(result.Value);
            } else {
                future.completeExceptionally((Throwable)result.Exception);
            }
        })));
        return future;
    }

    public static VTask waitForEndAsync(Thread thread, boolean interruptible) {
        return Async.waitForEndAsync(thread, 0.1, interruptible);
    }

    public static VTask waitForEndAsync(Thread thread, double checkIntervalSeconds, boolean interruptible) {
        VTaskSource taskSource = new VTaskSource();
        IDisposable repeater = Dispatcher.getForCurrentThread().repeat(() -> {
            if (thread.isAlive()) {
                return checkIntervalSeconds;
            }
            vTaskSource.CancelHandler = TaskSourceBase.CANNOT_CANCEL;
            taskSource.setFulfilled();
            return null;
        });
        if (((VTask)taskSource.getTask()).isRunning()) {
            taskSource.CancelHandler = interruptible ? () -> {
                thread.interrupt();
                repeater.dispose();
            } : repeater::dispose;
        }
        return (VTask)taskSource.getTask();
    }

    public static Task<Integer> waitForExitAsync(Process process) {
        return Task.runAsync(() -> {
            try {
                return process.waitFor();
            }
            catch (InterruptedException e) {
                return -583453;
            }
        });
    }

    private static enum RunState {
        NOT_RUNNING,
        RUNNING,
        AWAITED;

    }
}

