/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import java.time.Duration;

public final class Stopwatch {
    public static final long NanosInSecond = 1000000000L;
    public static final long NanosInMillisecond = 1000000L;

    private Stopwatch() {
    }

    public static long start() {
        return System.nanoTime();
    }

    public static long getMillis(long start) {
        return Stopwatch.getMillis(start, Stopwatch.start());
    }

    public static long getMillis(long start, long now) {
        return Stopwatch.toMillis(now - start);
    }

    public static long toMillis(long durationNanos) {
        return durationNanos / 1000000L;
    }

    public static long getNanos(long start) {
        return Stopwatch.start() - start;
    }

    public static Duration getDuration(long start) {
        return Duration.ofNanos(Stopwatch.start() - start);
    }

    public static Duration getDuration(long start, long now) {
        return Duration.ofNanos(now - start);
    }

    public static double getSeconds(long start) {
        return Stopwatch.getSeconds(start, Stopwatch.start());
    }

    public static double getSeconds(long start, long now) {
        return Stopwatch.toSeconds(now - start);
    }

    public static double toSeconds(long durationNanos) {
        return (double)durationNanos / 1.0E9;
    }

    public static long fromSeconds(double seconds) {
        return (long)(seconds * 1.0E9);
    }
}

