/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.FormatException;
import com.iosoft.helpers.Misc;

public abstract class Parser {
    protected final String input;
    protected char lookaheadChar;
    protected int pos = -1;
    protected boolean endReached;

    public Parser(String input) throws FormatException {
        Misc.notNull(input);
        this.input = input.trim();
        this.nextChar();
    }

    protected boolean setPos(int to) throws FormatException {
        this.pos = to - 1;
        this.lookaheadChar = this.input.charAt(this.pos);
        return this.nextChar();
    }

    protected boolean nextChar() throws FormatException {
        if (this.input.length() == this.pos) {
            throw new FormatException("Unexpected end of string");
        }
        ++this.pos;
        if (this.input.length() == this.pos) {
            this.endReached = true;
            return false;
        }
        this.lookaheadChar = this.input.charAt(this.pos);
        return true;
    }

    protected boolean askToken(char token) throws FormatException {
        this.skipWhitespace();
        return this.lookaheadChar == token;
    }

    protected boolean tryToken(char token) throws FormatException {
        if (this.askToken(token)) {
            this.nextChar();
            return true;
        }
        return false;
    }

    protected boolean tryTokens(String tokens) throws FormatException {
        this.skipWhitespace();
        if (this.input.startsWith(tokens, this.pos)) {
            this.setPos(this.pos + tokens.length());
            return true;
        }
        return false;
    }

    protected void reqToken(char token) throws FormatException {
        this.skipWhitespace();
        this.reqNextChar(token);
    }

    protected void reqNextChar(char token) throws FormatException {
        this.reqNotEnd();
        if (this.lookaheadChar != token) {
            throw new FormatException("Expected token '" + token + "', got '" + this.lookaheadChar + "'");
        }
        this.nextChar();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean skipWhitespace() throws FormatException {
        if (!this.endReached) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.nextChar()) continue;
            return false;
lbl5:
            // 2 sources

            ** while (Character.isWhitespace((char)this.lookaheadChar))
        }
lbl6:
        // 1 sources

        return true;
    }

    protected void reqNotEnd() throws FormatException {
        if (this.endReached) {
            throw new FormatException("End reached early");
        }
    }

    protected void reqEnd() throws FormatException {
        if (this.skipWhitespace()) {
            throw new FormatException("End not reached");
        }
    }
}

