/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Blocker;
import com.iosoft.helpers.FormatException;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.helpers.MutableInt;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.io.MiscIO;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Misc {
    public static final byte[] EMPTYBYTES = new byte[0];
    public static final int[] EMPTYINTS = new int[0];
    public static final String[] EMPTYSTRINGS = new String[0];
    public static final Object[] EMPTYOBJS = new Object[0];
    public static final int UShortMax = 65535;
    public static final boolean IsOnWindows = Misc.toUpper(System.getProperty("os.name")).contains("WINDOWS");
    private static String _tempdir;
    private static final char[] ALPHABET;
    private static final int[] toInt;
    private static final Object _systemOutLock;
    private static boolean _systemOutSetToUtf8;
    public static final Set<Integer> AllowedCodePoints;

    static {
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        toInt = new int[128];
        int i = 0;
        while (i < ALPHABET.length) {
            Misc.toInt[Misc.ALPHABET[i]] = i;
            ++i;
        }
        _systemOutLock = new Object();
        AllowedCodePoints = "abcdefghijklmnopqrstuvwxyz_0123456789".chars().mapToObj(Integer::valueOf).collect(Collectors.toSet());
    }

    private Misc() {
    }

    public static File getAppdataDir() {
        if (IsOnWindows) {
            return new File(System.getenv("APPDATA"));
        }
        return new File(System.getProperty("user.home"));
    }

    public static File getSubAppdataDir(String nameOnWindows, String nameElse) {
        File appdataDir = Misc.getAppdataDir();
        if (IsOnWindows) {
            return new File(appdataDir, nameOnWindows);
        }
        return new File(appdataDir, nameElse);
    }

    public static File getIosoftDir() {
        return Misc.getSubAppdataDir("IoSoftware", ".iosoft");
    }

    public static File getTempFolder(boolean persistent) {
        if (IsOnWindows) {
            String tempdir = _tempdir;
            if (tempdir == null) {
                tempdir = System.getProperty("java.io.tmpdir");
                if (Misc.isNullOrEmpty(tempdir) && Misc.isNullOrEmpty(tempdir = System.getenv("TEMP"))) {
                    tempdir = "C:/Temp";
                }
                _tempdir = tempdir;
            }
            return new File(tempdir);
        }
        return new File(persistent ? "/var/tmp" : "/tmp");
    }

    public static String padRight(String str, int size, char c) {
        StringBuilder sb = new StringBuilder(str);
        int s = str.length();
        while (s < size) {
            sb.append(c);
            ++s;
        }
        return sb.toString();
    }

    public static String padLeft(String str, int size, char c) {
        int toPad = size - str.length();
        StringBuilder sb = new StringBuilder();
        while (toPad > 0) {
            sb.append(c);
            --toPad;
        }
        sb.append(str);
        return sb.toString();
    }

    public static <T> T notNull(T value) {
        if (value == null) {
            throw new IllegalArgumentException("argument may not be null");
        }
        return value;
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " may not be null");
        }
        return value;
    }

    public static InetAddress getLocalInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    public static String getComputerName() {
        return Misc.getLocalInetAddress().getHostName();
    }

    public static String getUserName(String defVal) {
        return System.getProperty("user.name", defVal);
    }

    public static byte intToByte(int val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("Can't convert " + val + " to a byte (must be 0-255)");
        }
        return (byte)val;
    }

    public static double smoothstep(double zero, double max, double val) {
        return Misc.smoothstep(max - zero, val - zero);
    }

    public static double smoothstep(double max, double val) {
        return Misc.smoothstep(val / max);
    }

    public static double smoothstep(double x) {
        return x * x * (3.0 - 2.0 * x);
    }

    public static double smootherstep(double zero, double max, double val) {
        return Misc.smootherstep(max - zero, val - zero);
    }

    public static double smootherstep(double wert, double max) {
        return Misc.smootherstep(wert / max);
    }

    public static double smootherstep(double x) {
        return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
    }

    public static double calculateEffectiveness(double is, double max) {
        return Math.sin(1.5707963267948966 * (is / max));
    }

    public static String limitLength(String input, int maxChars) {
        return Misc.limitLength(input, maxChars, true);
    }

    public static String limitLength(String input, int maxChars, boolean keepLeft) {
        int length = input.length();
        if (length <= maxChars) {
            return input;
        }
        int offset = keepLeft ? 0 : length - maxChars;
        return input.substring(offset, offset + maxChars);
    }

    public static void sleep(long ms_time) {
        try {
            Thread.sleep(ms_time);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean trySleep(long ms_time) {
        try {
            Thread.sleep(ms_time);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static boolean charIsDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static int getAsInt(String str) {
        return Misc.getAsInt(str, -1);
    }

    public static int getAsInt(String str, int d) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static short getAsShort(String str) {
        return Misc.getAsShort(str, (short)-1);
    }

    public static short getAsShort(String str, short d) {
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static char getAsUShort(String str) {
        return Misc.getAsUShort(str, '\u0000');
    }

    public static char getAsUShort(String str, char d) {
        try {
            int val = Integer.parseUnsignedInt(str);
            return val > 65535 ? d : (char)val;
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static Character tryGetAsUShort(String str) {
        try {
            int val = Integer.parseUnsignedInt(str);
            return val > 65535 ? null : Character.valueOf((char)val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer tryGetAsInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long tryGetAsLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer tryGetAsUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float tryGetAsFloat(String str) {
        try {
            float value = Float.parseFloat(str);
            if (Float.isFinite(value)) {
                return Float.valueOf(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Float tryGetAsFloat(String str, float min, float max) {
        try {
            float value = Float.parseFloat(str);
            if (Float.isFinite(value) && value >= min && value <= max) {
                return Float.valueOf(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double tryGetAsDouble(String str) {
        try {
            double value = Double.parseDouble(str);
            if (Double.isFinite(value)) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double tryGetAsDouble(String str, double min, double max) {
        try {
            double value = Double.parseDouble(str);
            if (Double.isFinite(value) && value >= min && value <= max) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static long getAsLong(String str) {
        return Misc.getAsLong(str, -1L);
    }

    public static long getAsLong(String str, long d) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static float getAsFloat(String str) {
        return Misc.getAsFloat(str, -1.0f);
    }

    public static float getAsFloat(String str, float d) {
        try {
            float value = Float.parseFloat(str);
            if (Float.isFinite(value)) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static double getAsDouble(String str) {
        return Misc.getAsDouble(str, -1.0);
    }

    public static double getAsDouble(String str, double d) {
        try {
            double value = Double.parseDouble(str);
            if (Double.isFinite(value)) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static byte getAsByte(String str) {
        return Misc.getAsByte(str, (byte)-1);
    }

    public static byte getAsByte(String str, byte d) {
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static byte[] cutBytes(byte[] bytes, int length, int offset) {
        if (bytes.length < length + offset || offset < 0 || length < 0) {
            return EMPTYBYTES;
        }
        byte[] newbytes = new byte[length];
        System.arraycopy(bytes, offset, newbytes, 0, length);
        return newbytes;
    }

    public static <T> T tryGetRandom(List<T> list) {
        int iC = list.size();
        if (iC == 0) {
            return null;
        }
        if (iC == 1) {
            return list.get(0);
        }
        return list.get(Misc.getRandomInt(iC));
    }

    public static <T> T tryGetRandom(T[] array) {
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        return array[Misc.getRandomInt(array.length)];
    }

    public static <T> T tryGetRandom(T[] iterable, ToDoubleFunction<T> probabilityGetter) {
        return Misc.tryGetRandom(Arrays.asList(iterable), iterable.length, probabilityGetter);
    }

    public static <T> T tryGetRandom(Collection<T> list, ToDoubleFunction<T> probabilityGetter) {
        return Misc.tryGetRandom(list, list.size(), probabilityGetter);
    }

    public static <T> T tryGetRandom(Iterable<T> iterable, int count, ToDoubleFunction<T> probabilityGetter) {
        double fullProbability = 0.0;
        class Entry {
            final T Item;
            final double Probability;

            Entry(T item, double probability) {
                this.Item = item;
                this.Probability = probability;
            }
        }
        Entry[] probabilities = new Entry[count];
        int index = 0;
        for (T item : iterable) {
            double probability = probabilityGetter.applyAsDouble(item);
            if (probability < 0.0) {
                throw new IllegalArgumentException("Probably <0 is not allowed");
            }
            if (!(probability > 0.0)) continue;
            probabilities[index] = new Entry(item, fullProbability += probability);
            ++index;
        }
        count = index;
        if (fullProbability > 0.0) {
            double result = Misc.random(fullProbability);
            int i = 0;
            while (i < count) {
                Entry entry = probabilities[i];
                if (i == count - 1 || entry.Probability > result) {
                    return entry.Item;
                }
                ++i;
            }
        }
        return null;
    }

    public static int getRandom(int[] array) {
        return array[Misc.getRandomInt(array.length)];
    }

    public static char getRandom(char[] array) {
        return array[Misc.getRandomInt(array.length)];
    }

    public static <T> T getRandom(List<T> list) {
        int iC = list.size();
        if (iC == 0) {
            throw new IllegalArgumentException("Empty list");
        }
        if (iC == 1) {
            return list.get(0);
        }
        return list.get(Misc.getRandomInt(iC));
    }

    public static <T> T getRandom(T[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        if (array.length == 1) {
            return array[0];
        }
        return array[Misc.getRandomInt(array.length)];
    }

    public static <T> T getRandom(T[] array, ToDoubleFunction<T> probabilityGetter) {
        if (array.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        if (array.length == 1) {
            return array[0];
        }
        return Misc.tryGetRandom(array, probabilityGetter);
    }

    public static <T> T getRandom(List<T> array, ToDoubleFunction<T> probabilityGetter) {
        if (array.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        if (array.size() == 1) {
            return array.get(0);
        }
        return Misc.tryGetRandom(array, probabilityGetter);
    }

    public static <T> T getRandomLowest(List<T> list, ToDoubleFunction<T> probabilityGetter) {
        int iC = list.size();
        if (iC == 0) {
            throw new IllegalArgumentException("Empty list");
        }
        if (iC == 1) {
            return list.get(0);
        }
        return Misc.tryGetRandomLowest(list, probabilityGetter);
    }

    public static <T> T getRandomLowest(T[] list, ToDoubleFunction<T> probabilityGetter) {
        int iC = list.length;
        if (iC == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        if (iC == 1) {
            return list[0];
        }
        return Misc.tryGetRandomLowest(list, probabilityGetter);
    }

    public static <T> T tryGetRandomLowest(T[] iterable, ToDoubleFunction<T> probabilityGetter) {
        return Misc.tryGetRandomLowest(Arrays.asList(iterable), probabilityGetter);
    }

    public static <T> T tryGetRandomLowest(Iterable<T> iterable, ToDoubleFunction<T> probabilityGetter) {
        class Entry {
            final T Item;
            final double Value;

            Entry(T var2_2) {
                this.Item = item;
                this.Value = var2_2.applyAsDouble(item);
            }
        }
        LinkedList entries = MiscLINQ.stream(iterable).map(t -> new Entry(t, probabilityGetter)).collect(Collectors.toCollection(LinkedList::new));
        while (entries.size() > 1) {
            entries.remove(Misc.getRandom(entries, (T x) -> x.Value));
        }
        return entries.isEmpty() ? null : (T)((Entry)entries.getFirst()).Item;
    }

    public static <T> T tryRemoveRandom(List<T> list) {
        return Misc.removeRandom(list, null);
    }

    public static <T> T removeRandom(List<T> list, T noneFoundValue) {
        int iC = list.size();
        if (iC == 0) {
            return noneFoundValue;
        }
        return list.remove(Misc.getRandomInt(iC));
    }

    public static <T> T removeRandom(List<T> list) {
        int iC = list.size();
        if (iC == 0) {
            throw new IllegalArgumentException("Empty list");
        }
        return list.remove(Misc.getRandomInt(iC));
    }

    public static int getRandomInt(int bound) {
        return bound > 0 ? ThreadLocalRandom.current().nextInt(0, bound) : (bound < 0 ? -ThreadLocalRandom.current().nextInt(0, -bound) : 0);
    }

    public static double random() {
        return ThreadLocalRandom.current().nextDouble(1.0);
    }

    public static double random(double max) {
        return max > 0.0 ? ThreadLocalRandom.current().nextDouble(max) : (max < 0.0 ? -ThreadLocalRandom.current().nextDouble(-max) : 0.0);
    }

    public static double randomCenterRange(double width) {
        return Misc.random(width) - width * 0.5;
    }

    public static double randomRange(double min, double max) {
        return min + Misc.random(max - min);
    }

    public static long getRandomLong(long maxlong) {
        return ThreadLocalRandom.current().nextLong(maxlong);
    }

    public static boolean randomBool() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static boolean randomBool(double of) {
        return Misc.random(of) < 1.0;
    }

    public static boolean randomPercentage(double probability) {
        return probability >= 1.0 || probability > 0.0 && Misc.random() < probability;
    }

    public static int extractInt(byte[] bytes, int pos) {
        return Misc.extractInt(bytes, pos, 4);
    }

    public static int extractInt(byte[] bytes, int pos, int len) {
        if (bytes.length < pos + len) {
            throw new IllegalArgumentException("extractInt failed (" + bytes.length + ", " + pos + ", " + len + ")");
        }
        int val = 0;
        int c = 0;
        if (len >= 4) {
            val += (0xFF & bytes[pos + c]) << 24;
            ++c;
        }
        if (len >= 3) {
            val += (0xFF & bytes[pos + c]) << 16;
            ++c;
        }
        if (len >= 2) {
            val += (0xFF & bytes[pos + c]) << 8;
            ++c;
        }
        if (len >= 1) {
            val += 0xFF & bytes[pos + c];
            ++c;
        }
        return val;
    }

    public static long extractLong(byte[] bytes, int pos) {
        return Misc.extractLong(bytes, pos, 8);
    }

    public static long extractLong(byte[] bytes, int pos, int len) {
        if (bytes.length < pos + len) {
            throw new IllegalArgumentException("extractLong failed (" + bytes.length + ", " + pos + ", " + len + ")");
        }
        long val = 0L;
        int c = 0;
        if (len >= 8) {
            val += (long)bytes[pos + c] << 56;
            ++c;
        }
        if (len >= 7) {
            val += (long)(bytes[pos + c] & 0xFF) << 48;
            ++c;
        }
        if (len >= 6) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 40;
            ++c;
        }
        if (len >= 5) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 32;
            ++c;
        }
        if (len >= 4) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 24;
            ++c;
        }
        if (len >= 3) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 16;
            ++c;
        }
        if (len >= 2) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 8;
            ++c;
        }
        if (len >= 1) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 0;
            ++c;
        }
        return val;
    }

    public static float extractFloat(byte[] bytes, int pos) {
        return Misc.extractFloat(bytes, pos, 4);
    }

    public static float extractFloat(byte[] bytes, int pos, int len) {
        int v = Misc.extractInt(bytes, pos, len);
        return Float.intBitsToFloat(v);
    }

    public static double extractDouble(byte[] bytes, int pos) {
        return Misc.extractDouble(bytes, pos, 8);
    }

    public static double extractDouble(byte[] bytes, int pos, int len) {
        long v = Misc.extractLong(bytes, pos, len);
        return Double.longBitsToDouble(v);
    }

    public static int convertByteArrayToInt(byte[] bytes) {
        return Misc.extractInt(bytes, 0, bytes.length);
    }

    public static byte[] convertLongToByteArray(long val) {
        byte[] bytes = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return bytes;
    }

    public static long convertByteArrayToLong(byte[] bytes) {
        if (bytes.length < 8) {
            return 0L;
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << (int)(40L + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0)));
    }

    public static byte[] insertInt(byte[] target, int pos, int intValue) {
        int tarLen = target.length;
        if (tarLen < 4 + pos) {
            throw new IllegalArgumentException("Can't insert Int! (Target: " + tarLen + " Insert int: " + intValue + " Pos: " + pos + ")");
        }
        int i = 0;
        while (i < 4) {
            target[i + pos] = (byte)(intValue >>> 24 - 8 * i);
            ++i;
        }
        return target;
    }

    public static byte[] insertLong(byte[] target, int pos, long longValue) {
        int tarLen = target.length;
        if (tarLen < 8 + pos) {
            throw new IllegalArgumentException("Can't insert Long! (Target: " + tarLen + " Insert long: " + longValue + " Pos: " + pos + ")");
        }
        int i = 0;
        while (i < 8) {
            target[i + pos] = (byte)(longValue >>> 56 - 8 * i);
            ++i;
        }
        return target;
    }

    public static byte[] cstringToBytes(String str) {
        return Misc.cstringToBytes(str, str.length());
    }

    public static byte[] cstringToBytes(String str, int maxchars) {
        byte[] result;
        if (str.length() > maxchars) {
            str = str.substring(0, maxchars);
        }
        if ((result = str.getBytes(StandardCharsets.ISO_8859_1)).length == maxchars) {
            return result;
        }
        return Arrays.copyOfRange(result, 0, maxchars);
    }

    public static byte[] intToBytes(int v) {
        return Misc.intToBytes(v, 4);
    }

    public static byte[] intToBytes(int v, int nr) {
        return Misc.longToBytes(v, nr);
    }

    public static byte[] longToBytes(long v) {
        return Misc.longToBytes(v, 8);
    }

    public static byte[] longToBytes(long v, int nr) {
        byte[] bytes = new byte[nr];
        int i = 0;
        while (i < nr) {
            bytes[i] = (byte)(v >>> 8 * (nr - i - 1));
            ++i;
        }
        return bytes;
    }

    public static byte[] floatToBytes(float v) {
        return Misc.floatToBytes(v, 4);
    }

    public static byte[] floatToBytes(float v, int nr) {
        int v2 = Float.floatToRawIntBits(v);
        return Misc.intToBytes(v2, nr);
    }

    public static byte[] doubleToBytes(double v) {
        return Misc.doubleToBytes(v, 8);
    }

    public static byte[] doubleToBytes(double v, int nr) {
        long v2 = Double.doubleToRawLongBits(v);
        return Misc.longToBytes(v2, nr);
    }

    public static int getBitnumber(boolean[] b, int start, int len) {
        return Misc.getBitnumber(b, start, len, true);
    }

    public static int getBitnumber(boolean[] b, int start, int len, boolean l) {
        int n = 0;
        int u = 1;
        int i = 0;
        while (i < len) {
            int d;
            int n2 = d = l ? start + len - 1 - i : start + i;
            if (b[d]) {
                n += u;
            }
            u *= 2;
            ++i;
        }
        return n;
    }

    public static boolean[] writeBitnumber(int num, int length) {
        boolean[] bs = new boolean[length];
        Misc.writeBitnumber(num, bs, 0, length);
        return bs;
    }

    public static void writeBitnumber(int num, boolean[] bs, int start, int length) {
        Misc.writeBitnumber(num, bs, start, length, true);
    }

    public static void writeBitnumber(int num, boolean[] bs, int start, int length, boolean l) {
        int i = 0;
        while (i < length) {
            bs[l ? start + length - i - 1 : start + i] = (num & 1) == 1;
            num /= 2;
            ++i;
        }
    }

    public static String bytesToString(byte[] bytes) {
        return Misc.getSubString(bytes, 0, bytes.length);
    }

    public static String getSubString(byte[] bytes, int start, int length) {
        if (start < 0 || length < 0 || bytes.length < start + length) {
            throw new IndexOutOfBoundsException("bounds error (len: " + bytes.length + ", start: " + start + ", length: " + length + ")");
        }
        int i = 0;
        while (i < length) {
            if (bytes[start + i] == 0) {
                length = i;
                break;
            }
            ++i;
        }
        return new String(bytes, start, length, StandardCharsets.ISO_8859_1);
    }

    public static int buildFlags(boolean ... flags) {
        int length = flags.length;
        if (length > 8) {
            throw new IllegalArgumentException("A byte can only have 8 bits (not " + length + ")");
        }
        int result = 0;
        int i = 0;
        while (i < length) {
            if (flags[i]) {
                result |= 1 << i;
            }
            ++i;
        }
        return result;
    }

    public static byte buildByte(boolean ... bools) {
        return Misc.buildByte(bools, 0, bools.length);
    }

    public static byte buildByte(boolean[] bools, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("A byte can only have up to 8 bits (not " + length + ")");
        }
        int bin = 0;
        int i = 0;
        while (i < 8) {
            if (length == i) break;
            if (bools[offset + i]) {
                bin |= 1 << i;
            }
            ++i;
        }
        return (byte)bin;
    }

    public static byte[] buildBytes(boolean[] values, int numBytes) {
        if (numBytes < -1) {
            return EMPTYBYTES;
        }
        if (values == null) {
            values = new boolean[]{};
        }
        int numValues = values.length;
        numBytes = numBytes == -1 ? numValues / 8 + (numValues % 8 == 0 ? 0 : 1) : numBytes;
        byte[] bytes = new byte[numBytes];
        int i = 0;
        while (i < numBytes) {
            int bin = 0;
            int i2 = 0;
            while (i2 < 8) {
                int valNr = i * 8 + i2;
                if (numValues > valNr && values[valNr]) {
                    bin |= 1 << i2;
                }
                ++i2;
            }
            bytes[i] = (byte)bin;
            ++i;
        }
        return bytes;
    }

    public static boolean[] readByte(DataInputStream in) throws IOException {
        return Misc.readByte(in.readByte());
    }

    public static boolean[] readByte(byte b) {
        boolean[] bools = new boolean[8];
        Misc.readByte(b, bools, 0);
        return bools;
    }

    public static void readByte(int byt, boolean[] into, int offset) {
        Misc.readByte(byt, into, offset, into.length);
    }

    public static void readByte(int byt, boolean[] into, int offset, int length) {
        int i = 0;
        while (i < length) {
            into[offset + i] = (byt & 1 << i) != 0;
            ++i;
        }
    }

    public static boolean[] readBytes(byte[] bytes) {
        return Misc.readBytes(bytes, 0, bytes.length, -1);
    }

    public static boolean[] readBytes(InputStream in, int numBytes, int numBools) throws IOException {
        if (numBytes < -1) {
            numBytes = 0;
        }
        if (numBools < -1) {
            numBools = 0;
        }
        if (numBytes == -1 && numBools == -1) {
            throw new IllegalArgumentException("Can't bydefault numBytes AND numBools!");
        }
        if (numBytes == -1) {
            numBytes = numBools / 8 + (numBools % 8 > 0 ? 1 : 0);
        }
        if (numBools == -1) {
            numBools = numBytes * 8;
        }
        return Misc.readBytes(MiscIO.readFully(in, numBytes), 0, numBytes, numBools);
    }

    public static boolean[] readBytes(byte[] bytes, int offset, int length, int numBools) {
        if (numBools < -1) {
            numBools = 0;
        }
        numBools = numBools == -1 ? length * 8 : numBools;
        boolean[] bools = new boolean[numBools];
        int i = 0;
        while (i < length) {
            if (numBools <= i * 8) break;
            boolean[] tempB = Misc.readByte(bytes[i + offset]);
            int i2 = 0;
            while (i2 < 8) {
                if (numBools <= i * 8 + i2) break;
                bools[i * 8 + i2] = tempB[i2];
                ++i2;
            }
            ++i;
        }
        return bools;
    }

    public static byte[] mergeBytes(List<byte[]> list) {
        int pos = 0;
        int i = list.size() - 1;
        while (i >= 0) {
            pos += list.get(i).length;
            --i;
        }
        byte[] bytes = new byte[pos];
        int i2 = list.size() - 1;
        while (i2 >= 0) {
            byte[] arr = list.get(i2);
            System.arraycopy(arr, 0, bytes, pos -= arr.length, arr.length);
            --i2;
        }
        return bytes;
    }

    public static <T> byte[] mergeBytes(byte ... bytes) {
        return bytes;
    }

    public static void dumpToFile(byte[] bytes, String filePath) {
        Misc.dumpToFile(bytes, new File(filePath));
    }

    public static void dumpToFile(byte[] bytes, File file) {
        try {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                MiscIO.mkdirs(parentFile);
            }
            Files.write(file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int modNegToPos(int num, int mod) {
        return (num % mod + mod) % mod;
    }

    public static long modNegToPos(long num, long mod) {
        return (num % mod + mod) % mod;
    }

    public static double modNegToPos(double num, double mod) {
        return (num % mod + mod) % mod;
    }

    public static boolean even(int num) {
        return Misc.modNegToPos(num, 2) == 0;
    }

    public static boolean even(long num) {
        return Misc.modNegToPos(num, 2L) == 0L;
    }

    public static String base64encode(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static byte[] base64decode(String s) throws FormatException {
        try {
            int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
            byte[] buffer = new byte[s.length() * 3 / 4 - delta];
            int mask = 255;
            int index = 0;
            int i = 0;
            while (i < s.length()) {
                int c0 = toInt[s.charAt(i)];
                int c1 = toInt[s.charAt(i + 1)];
                buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
                if (index >= buffer.length) {
                    return buffer;
                }
                int c2 = toInt[s.charAt(i + 2)];
                buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
                if (index >= buffer.length) {
                    return buffer;
                }
                int c3 = toInt[s.charAt(i + 3)];
                buffer[index++] = (byte)((c2 << 6 | c3) & mask);
                i += 4;
            }
            return buffer;
        }
        catch (Exception e) {
            throw new FormatException("Not a base64 string", e);
        }
    }

    public static int[] range(int end) {
        return Misc.range(0, end);
    }

    public static int[] range(int start, int end) {
        if (++end - start <= 0) {
            return new int[0];
        }
        int[] range = new int[end - start];
        int i = start;
        while (i < end) {
            range[i - start] = i;
            ++i;
        }
        return range;
    }

    public static String[] stringRange(int start, int end, String pre, String post) {
        int num;
        if ((num = ++end - start) <= 0) {
            return new String[0];
        }
        String[] range = new String[num];
        int i = 0;
        while (i < num) {
            range[i] = String.valueOf(pre) + (start + i) + post;
            ++i;
        }
        return range;
    }

    public static String[] intArrayToStringArray(int[] ints) {
        String[] strs = new String[ints.length];
        int i = 0;
        while (i < strs.length) {
            strs[i] = "" + ints[i];
            ++i;
        }
        return strs;
    }

    public static Integer[] boxIntArray(int[] ints) {
        Integer[] arr = new Integer[ints.length];
        int i = 0;
        while (i < arr.length) {
            arr[i] = ints[i];
            ++i;
        }
        return arr;
    }

    public static int[] toIntArray(List<Integer> list) {
        int iC = list.size();
        int[] arr = new int[iC];
        Iterator<Integer> iter = list.iterator();
        int i = 0;
        while (i < iC) {
            arr[i] = iter.next();
            ++i;
        }
        return arr;
    }

    public static long[] toLongArray(List<Long> list) {
        int iC = list.size();
        long[] arr = new long[iC];
        Iterator<Long> iter = list.iterator();
        int i = 0;
        while (i < iC) {
            arr[i] = iter.next();
            ++i;
        }
        return arr;
    }

    public static byte[] toByteArray(List<Byte> list) {
        int iC = list.size();
        byte[] arr = new byte[iC];
        Iterator<Byte> iter = list.iterator();
        int i = 0;
        while (i < iC) {
            arr[i] = iter.next();
            ++i;
        }
        return arr;
    }

    public static double[] toDoubleArray(List<Double> list) {
        int iC = list.size();
        double[] arr = new double[iC];
        Iterator<Double> iter = list.iterator();
        int i = 0;
        while (i < iC) {
            arr[i] = iter.next();
            ++i;
        }
        return arr;
    }

    public static boolean[] toBoolArray(List<Boolean> list) {
        int iC = list.size();
        boolean[] arr = new boolean[iC];
        Iterator<Boolean> iter = list.iterator();
        int i = 0;
        while (i < iC) {
            arr[i] = iter.next();
            ++i;
        }
        return arr;
    }

    public static int pow(int v, int c) {
        if (c < 0) {
            throw new IllegalArgumentException("c=" + c);
        }
        if (c == 0) {
            return 1;
        }
        int t = v;
        while (--c > 0) {
            t *= v;
        }
        return t;
    }

    public static void forceClose(AutoCloseable o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception ex) {
                Log.Developer.error("[ force close failed for " + Misc.getClassName(o) + ": " + ex.toString() + " ]");
            }
        }
    }

    public static VTask forceCloseAsync(AutoCloseable o, boolean forceExtraThread) {
        if (o == null) {
            return VTask.COMPLETED_TASK;
        }
        if (forceExtraThread) {
            Thread closerThread = Misc.createCloseTimeout(o, 0.0, true);
            return Async.waitForEndAsync(closerThread, true);
        }
        return VTask.runAsync(() -> Misc.forceClose(o));
    }

    public static Thread createCloseTimeout(AutoCloseable closeObj, double sec_timeout, boolean alwaysClose) {
        Misc.notNull(closeObj);
        return Misc.startDaemonThread(String.valueOf(closeObj.getClass().getSimpleName()) + " Timeout Thread", () -> {
            block2: {
                try {
                    Thread.sleep(Misc.secondsToMillis(sec_timeout));
                }
                catch (InterruptedException e) {
                    if (alwaysClose) break block2;
                    return;
                }
            }
            Misc.forceClose(closeObj);
        });
    }

    public static int secondsToMillis(double seconds) {
        return (int)Math.round(seconds * 1000.0);
    }

    public static boolean getFlag(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public static boolean getBit(int flags, int bitNr) {
        return Misc.getFlag(flags, 1 << bitNr);
    }

    public static int setFlag(int flags, int flag, boolean is) {
        return is ? flags | flag : flags & ~flag;
    }

    public static int setBit(int flags, int bitNr, boolean is) {
        return Misc.setFlag(flags, 1 << bitNr, is);
    }

    public static int bit(int bitNr, boolean is) {
        return is ? 1 << bitNr : 0;
    }

    public static String join(String concat, int[] ints) {
        return IntStream.of(ints).mapToObj(Integer::toString).collect(Collectors.joining(concat));
    }

    public static String join(String concat, Object[] strings) {
        return Arrays.stream(strings).map(Object::toString).collect(Collectors.joining(concat));
    }

    public static String getClassName(Object o) {
        String name;
        if (o == null) {
            return "null";
        }
        int numAnonymous = 0;
        Class<?> clazz = o.getClass();
        while (true) {
            name = clazz.getSimpleName();
            clazz = clazz.getSuperclass();
            if (!name.isEmpty()) break;
            ++numAnonymous;
        }
        return numAnonymous > 0 ? String.valueOf(name) + " (anon x" + numAnonymous + ")" : name;
    }

    public static void causeError() {
        throw new RuntimeException("Testing error");
    }

    public static void listThreads() {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            String name = t.getName();
            if (name.equals("Direct Clip")) continue;
            System.out.println(String.valueOf(name) + " " + (t.isDaemon() ? "(daemon)" : "") + " " + (Object)((Object)t.getState()));
        }
    }

    public static String printException(Throwable e) {
        StringWriter sw = new StringWriter();
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String printExceptionShort(Throwable e) {
        String[] fullStacktrace = Misc.printException(e).split("\n");
        String[] protoStacktrace = Misc.printException(new Exception("")).split("\n");
        int linesCut = 0;
        int index = fullStacktrace.length - 1;
        int protoIndex = protoStacktrace.length - 1;
        while (index >= 0) {
            if (protoIndex < 0 || !fullStacktrace[index].equals(protoStacktrace[protoIndex])) break;
            ++linesCut;
            --protoIndex;
            --index;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i <= index) {
            sb.append(fullStacktrace[i]);
            sb.append('\n');
            ++i;
        }
        if (linesCut > 0) {
            sb.append("\t[ ... (" + linesCut + " lines cut) ]\n");
        }
        return sb.toString();
    }

    public static int clamp(int val, int min, int max) {
        return Math.min(Math.max(min, val), max);
    }

    public static double clamp(double val, double min, double max) {
        return Math.min(Math.max(min, val), max);
    }

    public static float clamp(float val, float min, float max) {
        return Math.min(Math.max(min, val), max);
    }

    public static float clamp01(float val) {
        return Math.min(Math.max(0.0f, val), 1.0f);
    }

    public static double clamp01(double val) {
        return Math.min(Math.max(0.0, val), 1.0);
    }

    public static double clamp01Div(double val, double max) {
        if (val <= 0.0) {
            return 0.0;
        }
        if (val >= max) {
            return 1.0;
        }
        return val / max;
    }

    public static Thread startDaemonThread(String name, Runnable runner) {
        Thread thread = new Thread(runner, name);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static String formatHHmmss(long seconds) {
        return String.format("%d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String[] splitNoempty(String string, String delim) {
        return string.isEmpty() ? EMPTYSTRINGS : string.split(delim, -1);
    }

    public static String toLower(String str) {
        return str.toLowerCase(Locale.ROOT);
    }

    public static String toUpper(String str) {
        return str.toUpperCase(Locale.ROOT);
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        V value = map.get(key);
        if (value == null) {
            throw new NoSuchElementException("Cannot find '" + key + "'");
        }
        return value;
    }

    public static <K, V> void add(Map<K, V> map, K key, V value) {
        V oldValue = map.put(key, value);
        if (oldValue != null) {
            throw new IllegalArgumentException("Cannot replace '" + key + "'");
        }
    }

    public static <K, V> void remove(Map<K, V> map, K key) {
        if (!map.remove(key, key)) {
            throw new IllegalArgumentException("Cannot remove '" + key + "'");
        }
    }

    public static <K, V> List<V> getOrEmpty(Map<K, List<V>> map, K key) {
        List<V> value = map.get(key);
        if (value == null) {
            return new ArrayList();
        }
        return value;
    }

    public static String trimAll(String input) {
        return Misc.trim(input, 1);
    }

    public static String trim(String input, int maxMiddleSpaces) {
        StringBuilder bufferSafe = new StringBuilder();
        StringBuilder bufferUnsafe = new StringBuilder();
        boolean start = true;
        int spacesSoFar = 0;
        for (int c : Misc.iterCodePoints(input.trim())) {
            if (Character.isWhitespace(c)) {
                if (!start && spacesSoFar < maxMiddleSpaces) {
                    bufferUnsafe.appendCodePoint(c);
                }
                ++spacesSoFar;
                continue;
            }
            spacesSoFar = 0;
            start = false;
            bufferSafe.append((CharSequence)bufferUnsafe);
            bufferUnsafe.setLength(0);
            bufferSafe.appendCodePoint(c);
        }
        return bufferSafe.toString();
    }

    public static Iterable<Integer> iterCodePoints(String input) {
        return MiscLINQ.iter(input.codePoints().boxed());
    }

    public static void runUninterruptable(String threadName, Runnable warmupCode) {
        Blocker blocker = new Blocker();
        Misc.startDaemonThread(threadName, () -> {
            try {
                warmupCode.run();
            }
            finally {
                blocker.fulfill();
            }
        });
        blocker.waitBlocking();
    }

    public static <T> T parseEnum(Function<String, T> parse, String value, T defaultValue) {
        try {
            return parse.apply(value);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static <T> List<T> takeRandom(List<T> source, int max) {
        ArrayList result = new ArrayList();
        Misc.takeRandom(result, source, max);
        return result;
    }

    public static <T> int takeRandom(Collection<T> destination, List<T> source, int maxToTake) {
        int numTaken = 0;
        while (source.size() > 0 && maxToTake > 0) {
            destination.add(Misc.removeRandom(source));
            --maxToTake;
            ++numTaken;
        }
        return numTaken;
    }

    public static boolean inBounds(int x, int y, int width, int height) {
        return x >= 0 && y >= 0 && x < width && y < height;
    }

    public static int inBounds_getIndex(int x, int y, int totalLength, int height) {
        int index;
        if (x >= 0 && y >= 0 && y < height && (index = x * height + y) < totalLength) {
            return index;
        }
        return -1;
    }

    public static long packInts(int i1, int i2) {
        return (long)i1 & 0xFFFFFFFFL | ((long)i1 & 0xFFFFFFFFL) << 32;
    }

    public static void unpackInts(long l, MutableInt i1, MutableInt i2) {
        i1.Value = (int)(l & 0xFFFFFFFFL);
        i2.Value = (int)(l >> 32 & 0xFFFFFFFFL);
    }

    public static int packShorts(int s1, int s2) {
        return s1 & 0xFFFF | (s2 & 0xFFFF) << 16;
    }

    public static void unpackShorts(int i, MutableInt s1, MutableInt s2) {
        s1.Value = i & 0xFFFF;
        s2.Value = i >> 16 & 0xFFFF;
    }

    public static String sanitizeName(String name) {
        return Misc.sanitizeLine(name, false, 1, false);
    }

    public static String sanitizeVersion(String version) {
        return Misc.sanitizeLine(version, false, 3, true);
    }

    public static String sanitizeLine(String text, boolean allowTab, int maxSpacesInTheMiddle, boolean replaceControlCharsWithQuestionmark) {
        if (!allowTab) {
            text = text.replace("\t", "");
        }
        return Misc.trim(text.replaceAll("\\^[\\uFFF0-\\uFFFF]", replaceControlCharsWithQuestionmark ? "?" : "").replaceAll("\\p{Gc=Cf}", replaceControlCharsWithQuestionmark ? "?" : "").replace("\n", "").replace("\r", "").replaceAll("(^\\h*)|(\\h*$)", ""), maxSpacesInTheMiddle);
    }

    public static <T> T[] createArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] createArray(T[] oldArray, int length) {
        return Misc.createArray(Misc.getComponentType(oldArray), length);
    }

    public static <T> Class<T> getComponentType(T[] array) {
        return array.getClass().getComponentType();
    }

    public static <T> T[] arrayAddEnd(T[] arrOld, T item) {
        return Misc.arrayAddEnd(arrOld, item, Misc.createArray(arrOld, arrOld.length + 1));
    }

    public static <T> T[] arrayAddEnd(T[] arrOld, T item, T[] arrNew) {
        return Misc.arrayAddAt(arrOld, item, arrOld.length, arrNew);
    }

    public static <T> T[] arrayAddAt(T[] arrOld, T item, int index) {
        return Misc.arrayAddAt(arrOld, item, index, Misc.createArray(arrOld, arrOld.length + 1));
    }

    public static <T> T[] arrayAddAt(T[] arrOld, T item, int index, T[] arrNew) {
        int sizeOld = arrOld.length;
        if (sizeOld + 1 != arrNew.length) {
            throw new IllegalArgumentException("Wrong length for new array (" + arrNew.length + " vs " + sizeOld + ", must be exactly 1 more)");
        }
        if (index < 0 || index > sizeOld) {
            throw new IllegalArgumentException("Bad index (" + index + " from [0;" + sizeOld + "])");
        }
        int offset = 0;
        int i = 0;
        while (i < sizeOld) {
            if (offset == 0 && i == index) {
                ++offset;
            }
            arrNew[i + offset] = arrOld[i];
            ++i;
        }
        arrNew[index] = item;
        return arrNew;
    }

    public static <T> T[] arrayRemoveIndex(T[] arrOld, int index) {
        return Misc.arrayRemoveIndex(arrOld, index, Misc.createArray(arrOld, arrOld.length - 1));
    }

    public static <T> T[] arrayRemoveIndex(T[] arrOld, int index, T[] arrNew) {
        if (arrOld.length - 1 != arrNew.length) {
            throw new IllegalArgumentException("Wrong length for new array (must be exactly 1 less)");
        }
        int size = arrNew.length;
        int offset = 0;
        int i = 0;
        while (i < size) {
            if (offset == 0 && i == index) {
                ++offset;
            }
            arrNew[i] = arrOld[i + offset];
            ++i;
        }
        return arrNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemOutToUtf8(boolean ignoreFailure) {
        Object object = _systemOutLock;
        synchronized (object) {
            if (_systemOutSetToUtf8) {
                return;
            }
            _systemOutSetToUtf8 = true;
            try {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException | SecurityException e) {
                String error = "Setting System.out to UTF-8 is not supported";
                if (!ignoreFailure) {
                    throw new WrapException(error, e);
                }
                Log.General.warning(error);
            }
        }
    }

    public static boolean isSafe(String string) {
        return string.codePoints().allMatch(x -> AllowedCodePoints.contains(x));
    }

    public static String tryGetNextCmdArg(List<String> args, String prefix) {
        int idx = args.indexOf(prefix);
        if (idx == -1 || idx >= args.size() - 1) {
            return null;
        }
        return args.get(idx + 1);
    }

    @SafeVarargs
    public static <T extends Enum<?>> Optional<T> getFromName(String text, T ... values) {
        String lowerText = Misc.toUpper(text);
        return Stream.of(values).filter(x -> Misc.toUpper(x.name()).equals(lowerText)).findFirst();
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static double lerp01(double scale, double at0, double at1) {
        if (scale <= 0.0) {
            return at0;
        }
        if (scale >= 1.0) {
            return at1;
        }
        return at0 + scale * (at1 - at0);
    }

    public static float lerp01(float scale, float at0, float at1) {
        if (scale <= 0.0f) {
            return at0;
        }
        if (scale >= 1.0f) {
            return at1;
        }
        return at0 + scale * (at1 - at0);
    }

    public static byte[] hash(byte[] content, String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.valueOf(algorithm) + " wasn't found??", e);
        }
        return md.digest(content);
    }

    public static byte[] sha256(byte[] content) {
        return Misc.hash(content, "SHA-256");
    }

    public static byte[] md5(byte[] content) {
        return Misc.hash(content, "MD5");
    }

    public static <T> void split(T[] source, T[][] destination, boolean leftToRight) {
        int x = 0;
        while (x < destination.length) {
            T[] dest = destination[x];
            int y = 0;
            while (y < dest.length) {
                dest[y] = source[leftToRight ? x + y * destination.length : x * dest.length + y];
                ++y;
            }
            ++x;
        }
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static void breakpoint() {
        System.out.println("WEIRD STUFF IS HAPPENING");
    }

    public static String replaceLoop(String input, String search, String replacement) {
        String output;
        while (!(output = input.replace(search, replacement)).equals(input)) {
            input = output;
        }
        return output;
    }
}

