/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.server;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.game.server.Player;
import com.iosoft.secag.TurnState;
import com.iosoft.secag.server.AI;
import com.iosoft.secag.server.Agent;
import com.iosoft.secag.server.Client;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgData;

public class SecAgPlayer
extends Player<SecAgData, GameServer, Client, AI> {
    protected boolean inGameOver;
    protected int[] thinkAgents;
    protected Agent agent;

    @Override
    protected void initPlayer() {
        this.inGameOver = false;
        this.thinkAgents = null;
    }

    public void setAgent(Agent a) {
        this.agent = a;
        this.agent.setPlayer(this);
    }

    @Override
    protected void setupPlayer() {
        SecAgData data = (SecAgData)this.getData();
        data.unreadyAll();
        if (data.isGameInProgress()) {
            this.setAgent(data.getRandomFreeAgent());
        }
    }

    @Override
    protected void postSetupPlayer() {
    }

    @Override
    protected void discardPlayer(TextWithArguments reason) {
        SecAgData data;
        super.discardPlayer(reason);
        if (this.agent != null) {
            this.agent.setPlayer(null);
            this.agent = null;
        }
        if (!(data = (SecAgData)this.getData()).isGameInProgress()) {
            data.unreadyAll();
        }
        if (!data.isGameInProgress() || data.isGameOver()) {
            return;
        }
        if (data.getTurnState() == TurnState.SubmitSecretPaper) {
            data.setNextThink(2.0f);
            return;
        }
        if (this.getNr() != data.playerTurn) {
            return;
        }
        switch (data.getTurnState()) {
            case ChooseSafePos: {
                data.placeSafeRandomly();
                break;
            }
            case RollTheDice: 
            case Turn: {
                data.nextPlayer();
                break;
            }
        }
    }

    @Override
    protected int buildFlags() {
        int flags = super.buildFlags();
        flags = Misc.setFlag(flags, 64, this.inGameOver());
        return flags;
    }

    public void setThinkAgents(int[] thinkAgents) {
        this.thinkAgents = thinkAgents;
    }

    public int[] getThinkAgents() {
        return this.thinkAgents;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void onGameOver() {
        if (this.isAI()) {
            ((AI)this._ai).onGameOver();
        } else {
            this.inGameOver = true;
            this.sendFlags();
        }
    }

    public boolean inGameOver() {
        return this.inGameOver;
    }

    public void onReplay() {
        this.inGameOver = false;
        this.sendFlags();
    }

    @Override
    protected AI createAI() {
        return new AI();
    }

    public boolean submitSecretPaper(int[] newThinkAgents) {
        SecAgData data = (SecAgData)this.getData();
        if (this.getThinkAgents() != null || newThinkAgents.length != data.getMaxPlayers() || !data.validateSecretPaper(this, newThinkAgents)) {
            return false;
        }
        this.setThinkAgents(newThinkAgents);
        data.setNextThink(2.0f);
        return true;
    }
}

