/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.server;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.MiscLINQ;
import com.iosoft.ioengine.game.server.GameData;
import com.iosoft.ioengine.game.server.Player;
import com.iosoft.ioengine.game.server.PlayerSlot;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.TurnState;
import com.iosoft.secag.dtos.InProgressGameState;
import com.iosoft.secag.dtos.S_ChooseSafePos;
import com.iosoft.secag.dtos.S_GameOver;
import com.iosoft.secag.dtos.S_GameState;
import com.iosoft.secag.dtos.S_Moved;
import com.iosoft.secag.dtos.S_RollTheDice;
import com.iosoft.secag.dtos.S_SafePlaced;
import com.iosoft.secag.dtos.S_Status;
import com.iosoft.secag.dtos.S_Turn;
import com.iosoft.secag.server.AI;
import com.iosoft.secag.server.Agent;
import com.iosoft.secag.server.Client;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgPlayer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SecAgData
extends GameData<SecAgPlayer, GameServer, Client> {
    protected boolean useSecretPaper;
    protected boolean restarting;
    protected boolean starting;
    protected boolean instawin;
    protected int pointsForGameover;
    protected int pointsForSecretPaper;
    protected int playerTurn;
    protected int dice;
    protected int safePos;
    protected int startTick;
    protected Agent[] agents;
    protected float secretPaperQuota;
    private int nextThinkTick;
    private boolean secretPapersSubmitted;
    private TurnState turnState = TurnState.RollTheDice;

    @Override
    protected void initialize() {
        super.initialize();
        this.instawin = false;
        this.restarting = false;
        this.secretPapersSubmitted = false;
    }

    @Override
    protected void onServerStarted() {
    }

    @Override
    protected void fillAINames(List<String> names) {
        AI.fillNames(names);
    }

    private void tryAbortStarting() {
        if (this.starting) {
            this.starting = false;
            ((GameServer)this.server).broadcast(((SecretAgents)((GameServer)this.server).Game).getLocalizer().translate("_Chat_Server_AbortStart"));
        }
    }

    @Override
    public void tick() {
        if (!this.isGameInProgress() && this.starting) {
            if (!this.startIsOK()) {
                this.tryAbortStarting();
            } else {
                --this.startTick;
                if (this.startTick == 0) {
                    this.startGame();
                } else {
                    int ticksPerSecond = (int)Math.max(1.0, Math.ceil(((GameServer)this.server).getTicksPerSecond()));
                    if (this.startTick % ticksPerSecond == 0) {
                        ((GameServer)this.server).broadcast(((SecretAgents)((GameServer)this.server).Game).getLocalizer().translate("_Chat_Server_StartIn", this.startTick / ticksPerSecond));
                    }
                }
            }
        }
        super.tick();
        if (!this.isGameInProgress() || this.isGameOver()) {
            return;
        }
        if (this.nextThinkTick > 0) {
            --this.nextThinkTick;
            return;
        }
        if (this.nextThinkTick < 0) {
            return;
        }
        switch (this.turnState) {
            case TurnWait: {
                this.afterMove();
                return;
            }
            case SafePlaced: {
                this.checkAgentPoints();
                return;
            }
            case SubmitSecretPaper: {
                this.checkIfAllPlayersHaveSubmittedTheirSecretPaper();
                return;
            }
        }
        SecAgPlayer p = (SecAgPlayer)this.getPlayer(this.playerTurn);
        if (!p.isAI()) {
            this.disableThink();
            return;
        }
        switch (this.turnState) {
            case RollTheDice: {
                this.rollTheDice();
                break;
            }
            case Turn: {
                this.doTurn(((AI)p.getAI()).makeMovement());
                break;
            }
            case ChooseSafePos: {
                this.placeSafe(((AI)p.getAI()).getSafePlacement());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state (" + (Object)((Object)this.turnState) + ")");
            }
        }
    }

    @Override
    protected void writeStartInfo(DataOutputStream dos, Client c) throws IOException {
        super.writeStartInfo(dos, c);
        this.getGameState((SecAgPlayer)c.getPrimaryPlayer()).write(dos);
    }

    private S_GameState getGameState(SecAgPlayer me) {
        S_GameState msg = new S_GameState();
        if (!this.isGameInProgress()) {
            return msg;
        }
        InProgressGameState gs = msg.GameState = new InProgressGameState();
        gs.Agents = (InProgressGameState.Agent[])Stream.of(this.agents).map(x -> {
            InProgressGameState.Agent agent = new InProgressGameState.Agent();
            agent.Color = x.Color;
            agent.Points = x.getPoints();
            agent.House = x.getHouse();
            agent.Position = x.getPos();
            return agent;
        }).toArray(InProgressGameState.Agent[]::new);
        gs.MyAgent = me.getAgent().Nr;
        gs.State = this.turnState;
        gs.PlayerAtTurn = this.playerTurn;
        gs.Dice = this.dice;
        gs.SafePos = this.safePos;
        return msg;
    }

    public void restartGame() {
        this.instawin = false;
        this.turnState = TurnState.RollTheDice;
        this.starting = false;
        this.setGameInProgress(false, true);
        this.secretPapersSubmitted = false;
        this.sendGameState();
        ((GameServer)this.server).broadcast(((SecretAgents)((GameServer)this.server).Game).getLocalizer().translate("_Chat_Server_Restarted"));
    }

    public void completelyRestartGame() {
        if (this.restarting) {
            return;
        }
        this.restarting = true;
        int i = 0;
        while (i < this.maxPlayers) {
            SecAgPlayer p = (SecAgPlayer)this.tryGetPlayer(i);
            if (p != null && p.isAI()) {
                p.kick(false);
            }
            ++i;
        }
        this.restartGame();
        this.restarting = false;
    }

    @Override
    public void setMaxPlayers(int newMax) {
        super.setMaxPlayers(newMax);
        this.onSettingChanged();
    }

    @Override
    public void setOpenGame(boolean val) {
        super.setOpenGame(val);
        this.onSettingChanged();
    }

    public void setUseSecretPaper(boolean use) {
        this.useSecretPaper = use;
        ((GameServer)this.server).updateFlags();
        this.onSettingChanged();
    }

    public void setLimit(int iLimit, float fSecretPaperQuota) {
        boolean recalc = false;
        if (iLimit != -1) {
            this.pointsForGameover = iLimit;
            recalc = true;
        }
        if (fSecretPaperQuota != -1.0f) {
            this.secretPaperQuota = fSecretPaperQuota;
            recalc = true;
        }
        if (recalc) {
            this.pointsForSecretPaper = Math.round((float)this.pointsForGameover * this.secretPaperQuota);
        }
        ((GameServer)this.server).update(7);
        this.onSettingChanged();
    }

    @Override
    public void doSlotCheck() {
        if (this.restarting) {
            return;
        }
        if (this.isSingleplayer()) {
            int i = 1;
            while (i < this.maxPlayers) {
                PlayerSlot s = this.slots[i];
                if (s.isOpen()) {
                    this.addPlayer(s);
                }
                ++i;
            }
        }
        if (((GameServer)this.server).isDedicated() && !this.hasAdmin()) {
            boolean noPlayers = true;
            int i = 0;
            while (i < this.maxPlayers) {
                SecAgPlayer p = (SecAgPlayer)this.tryGetPlayer(i);
                if (p != null && !p.isAI()) {
                    noPlayers = false;
                    if (!p.inGameOver()) {
                        ((Client)p.getClient()).setAdmin(true);
                        break;
                    }
                }
                ++i;
            }
            if (noPlayers) {
                this.completelyRestartGame();
            }
        }
    }

    public boolean isStarting() {
        return this.starting;
    }

    public void startStarting() {
        if (this.starting) {
            this.tryAbortStarting();
        } else if (this.startIsOK()) {
            this.starting = true;
            this.startTick = this.isSingleplayer() || ((SecretAgents)((GameServer)this.server).Game).isDevmode() ? 1 : ((GameServer)this.server).getSecondsInTicks(5.0) + 1;
        }
    }

    public boolean startIsOK() {
        int numHumans = 0;
        int i = 0;
        while (i < this.maxPlayers) {
            SecAgPlayer p = (SecAgPlayer)this.tryGetPlayer(i);
            if (this.slots[i].isOpen() && !this.isOpenGame() || p != null && (!p.isReady() || !p.isConnected())) {
                return false;
            }
            if (p != null && !p.isAI()) {
                ++numHumans;
            }
            ++i;
        }
        return numHumans >= 2 || this.isSingleplayer();
    }

    private void startGame() {
        this.starting = false;
        this.secretPapersSubmitted = false;
        this.safePos = 7;
        this.turnState = TurnState.RollTheDice;
        this.playerTurn = Misc.getRandomInt(this.maxPlayers);
        int numAgents = Math.min(this.maxPlayers + 2, 7);
        this.agents = new Agent[numAgents];
        List colors = IntStream.range(0, 7).boxed().collect(Collectors.toList());
        Collections.shuffle(colors);
        int i = 0;
        while (i < this.agents.length) {
            this.agents[i] = new Agent(this, i, (Integer)colors.get(i));
            ++i;
        }
        for (SecAgPlayer player : this.enumerateConnectedPlayers()) {
            player.setThinkAgents(null);
            player.setAgent(this.getRandomFreeAgent());
        }
        this.setNextThink(1.0f);
        this.onSettingChanged();
        this.onStartGame(true);
        this.sendGameState();
        if (this.instawin) {
            this.checkAgentPoints();
        }
    }

    private void sendGameState() {
        for (SecAgPlayer player : this.enumerateConnectedPlayers()) {
            Client client = (Client)player.getClient();
            if (client == null) continue;
            client.send(this.getGameState(player));
        }
    }

    public void doInstawin() {
        this.instawin = true;
    }

    @Override
    protected boolean canAddAI() {
        return !this.isGameInProgress();
    }

    public void unreadyAll() {
        for (SecAgPlayer player : this.enumerateConnectedPlayers()) {
            player.setReady(player.isAdmin());
        }
        this.tryAbortStarting();
    }

    public void onSettingChanged() {
        this.unreadyAll();
        this.checkSlots();
    }

    public boolean isGameOver() {
        return this.isGameInProgress() && this.turnState == TurnState.GameOver;
    }

    public Agent getRandomFreeAgent() {
        return Misc.getRandom(MiscLINQ.toList(MiscLINQ.filter(this.agents, x -> x.getPlayer() == null)));
    }

    public int getLimit() {
        return this.pointsForGameover;
    }

    public void nextPlayer() {
        this.turnState = TurnState.RollTheDice;
        if (this.countConnectedPlayers() == 0) {
            this.playerTurn = 0;
        } else {
            do {
                ++this.playerTurn;
                if (this.playerTurn < this.maxPlayers) continue;
                this.playerTurn = 0;
            } while (this.slots[this.playerTurn].getPlayer() == null);
        }
        S_RollTheDice msg = new S_RollTheDice();
        msg.PlayerAtTurn = this.playerTurn;
        ((GameServer)this.server).sendToAll(msg);
        this.setNextThink(1.0f);
    }

    public int getHighestScore() {
        if (!this.isGameInProgress()) {
            return 0;
        }
        return Arrays.stream(this.agents).mapToInt(Agent::getPoints).max().getAsInt();
    }

    private void sendStatus() {
        S_Status msg = new S_Status();
        msg.State = this.turnState;
        ((GameServer)this.server).sendToAll(msg);
    }

    private void checkAgentPoints() {
        SecAgPlayer p;
        boolean overSecPap = false;
        boolean overGoal = this.instawin;
        int i = 0;
        while (i < this.agents.length) {
            Agent a = this.agents[i];
            if (a.getPoints() >= this.pointsForSecretPaper) {
                overSecPap = true;
            }
            if (a.getPoints() >= this.pointsForGameover) {
                overGoal = true;
            }
            ++i;
        }
        if (overGoal) {
            overSecPap = true;
        }
        if (this.useSecretPaper && !this.secretPapersSubmitted && overSecPap) {
            this.secretPapersSubmitted = true;
            this.turnState = TurnState.SubmitSecretPaper;
            this.sendStatus();
            i = 0;
            while (i < this.slots.length) {
                SecAgPlayer p2 = (SecAgPlayer)this.tryGetPlayer(i);
                if (p2 != null && p2.isAI() && !p2.submitSecretPaper(((AI)p2.getAI()).getSecretPaperDecision())) {
                    throw new IllegalStateException("AI submitted a Secret Paper that was invalid!?");
                }
                ++i;
            }
            this.setNextThink(2.0f);
            return;
        }
        if (!overGoal) {
            this.nextPlayer();
            return;
        }
        S_GameOver msg = new S_GameOver();
        int i2 = 0;
        while (i2 < this.maxPlayers) {
            p = (SecAgPlayer)this.tryGetPlayer(i2);
            if (p != null) {
                S_GameOver.Player msgPlayer = new S_GameOver.Player();
                msgPlayer.PlayerId = p.getNr();
                msgPlayer.OwnAgent = p.getAgent().Nr;
                if (this.useSecretPaper) {
                    int[] thinkAgents = p.getThinkAgents();
                    int iPlayer = 0;
                    while (iPlayer < thinkAgents.length) {
                        SecAgPlayer otherPlayer;
                        if (iPlayer != i2 && (otherPlayer = (SecAgPlayer)this.tryGetPlayer(iPlayer)) != null) {
                            int iAgent = thinkAgents[iPlayer];
                            S_GameOver.PlayerGuess guess = new S_GameOver.PlayerGuess();
                            guess.PlayerId = iPlayer;
                            guess.AgentId = iAgent;
                            msgPlayer.ThinkAgents.add(guess);
                        }
                        ++iPlayer;
                    }
                }
                msg.Players.add(msgPlayer);
                p.onGameOver();
            }
            ++i2;
        }
        this.turnState = TurnState.GameOver;
        ((GameServer)this.server).sendToAll(msg);
        if (((GameServer)this.server).isDedicated()) {
            i2 = 0;
            while (i2 < this.maxPlayers) {
                p = (SecAgPlayer)this.tryGetPlayer(i2);
                if (p != null && !p.isAI()) {
                    ((Client)p.getClient()).setAdmin(false);
                }
                ++i2;
            }
            this.restartGame();
        }
    }

    private void checkIfAllPlayersHaveSubmittedTheirSecretPaper() {
        if (MiscLINQ.firstOrDefault(this.enumerateAllPlayers(x -> x.getThinkAgents() == null)) != null) {
            this.disableThink();
            return;
        }
        this.checkAgentPoints();
    }

    public void setNextThink(float inSeconds) {
        this.nextThinkTick = ((GameServer)this.server).getSecondsInTicks(Math.max(0.0f, inSeconds));
    }

    public void disableThink() {
        this.nextThinkTick = -1;
    }

    public boolean isCurrentPlayer(SecAgPlayer player, TurnState state) {
        return this.isGameInProgress() && (player == null || this.playerTurn == player.getNr()) && this.turnState == state;
    }

    public void rollTheDice() {
        this.dice = Misc.getRandomInt(6) + 1;
        if (this.instawin && this.playerTurn == 0) {
            this.dice = 7;
        }
        this.turnState = TurnState.Turn;
        S_Turn msg = new S_Turn();
        msg.Dice = this.dice;
        ((GameServer)this.server).sendToAll(msg);
        this.setNextThink(2.0f);
    }

    public void doTurn(int[] results) {
        SecAgPlayer player = (SecAgPlayer)this.tryGetPlayer(this.playerTurn);
        if (results.length != this.agents.length) {
            if (player.isAI()) {
                throw new IllegalArgumentException("AI sent " + Misc.join(" ", results) + " for " + this.agents.length + " | dice=" + this.dice);
            }
            ((Client)player.getClient()).sendFixWrongNumberOfPlayers();
            return;
        }
        int sum = 0;
        int i = 0;
        while (i < results.length) {
            sum += results[i];
            ++i;
        }
        if (sum != this.dice) {
            if (player.isAI()) {
                throw new IllegalArgumentException("AI sent " + Misc.join(" ", results) + " for " + this.agents.length + " | dice=" + this.dice);
            }
            return;
        }
        for (SecAgPlayer aiPlayer : this.enumerateConnectedPlayers(Player::isAI)) {
            ((AI)aiPlayer.getAI()).notifyMoveEvent(player, results);
        }
        this.turnState = TurnState.TurnWait;
        S_Moved msg = new S_Moved();
        msg.Moves = new S_Moved.Move[this.agents.length];
        int i2 = 0;
        while (i2 < this.agents.length) {
            S_Moved.Move move = msg.Moves[i2] = new S_Moved.Move();
            Agent agent = this.agents[i2];
            int movedBy = results[i2];
            agent.move(movedBy);
            move.MovedBy = movedBy;
            if (movedBy > 0) {
                int house = agent.getHouse();
                int[] freePositions = IntStream.range(0, 7).filter(pos -> !MiscLINQ.any(this.agents, x -> x != agent && x.getHouse() == house && x.getPos() == pos)).toArray();
                agent.setPos(Misc.getRandom(freePositions));
            }
            move.Position = agent.getPos();
            ++i2;
        }
        ((GameServer)this.server).sendToAll(msg);
        this.setNextThink((float)this.dice + 2.5f);
    }

    private void afterMove() {
        if (Arrays.stream(this.agents).noneMatch(x -> x.getHouse() == this.safePos)) {
            this.nextPlayer();
            return;
        }
        S_ChooseSafePos msg = new S_ChooseSafePos();
        msg.NewAgentPoints = new int[this.agents.length];
        int[] scoreForAI = new int[this.agents.length];
        int i = 0;
        while (i < this.agents.length) {
            Agent agent = this.agents[i];
            scoreForAI[i] = agent.score() * 4;
            msg.NewAgentPoints[i] = agent.getPoints();
            ++i;
        }
        this.turnState = TurnState.ChooseSafePos;
        ((GameServer)this.server).sendToAll(msg);
        this.setNextThink(2.0f);
        SecAgPlayer turnPlayer = (SecAgPlayer)this.tryGetPlayer(this.playerTurn);
        for (SecAgPlayer player : this.enumerateConnectedPlayers(Player::isAI)) {
            ((AI)player.getAI()).notifySafeEvent(turnPlayer, scoreForAI);
        }
        if (!this.slots[this.playerTurn].isPlaying()) {
            this.placeSafeRandomly();
        }
    }

    public void placeSafe(int pos) {
        if (MiscLINQ.firstOrDefault(this.agents, x -> x.getHouse() == pos) != null) {
            return;
        }
        this.safePos = pos;
        this.turnState = TurnState.SafePlaced;
        S_SafePlaced msg = new S_SafePlaced();
        msg.NewSafePos = this.safePos;
        ((GameServer)this.server).sendToAll(msg);
        this.setNextThink(3.0f);
    }

    boolean validateSecretPaper(SecAgPlayer player, int[] results) {
        int i = 0;
        while (i < results.length) {
            if (this.slots[i].getPlayer() == null) {
                results[i] = -1;
            } else if (i == player.getNr()) {
                results[i] = -1;
            } else {
                if (results[i] < 0 || results[i] >= this.agents.length || results[i] == player.getAgent().Nr) {
                    return false;
                }
                int j = 0;
                while (j < i) {
                    if (results[i] == results[j]) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public int getRandomPlaceForSafe() {
        ArrayList<Integer> places = new ArrayList<Integer>();
        int i = 0;
        while (i < 12) {
            places.add(i);
            ++i;
        }
        i = 0;
        while (i < this.agents.length) {
            places.remove((Object)this.agents[i].getHouse());
            ++i;
        }
        return (Integer)Misc.getRandom(places);
    }

    public void placeSafeRandomly() {
        this.placeSafe(this.getRandomPlaceForSafe());
    }

    public Agent[] getAgents() {
        return this.agents;
    }

    public int getDice() {
        return this.dice;
    }

    public int getSafeHouse() {
        return this.safePos;
    }

    public int getHouseScore(int house) {
        if (house == 11) {
            return -3;
        }
        return house;
    }

    @Override
    public SecAgPlayer createPlayer() {
        return new SecAgPlayer();
    }

    public boolean isJoinable() {
        return !this.secretPapersSubmitted && this.turnState != TurnState.GameOver;
    }

    public TurnState getTurnState() {
        return this.turnState;
    }
}

