/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.server;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.game.server.GameServerApp;
import com.iosoft.ioengine.serverbrowser.BaseServerInfo;
import com.iosoft.secag.SecAgServerInfo;
import com.iosoft.secag.SecretAgents;
import com.iosoft.secag.server.Client;
import com.iosoft.secag.server.SecAgData;
import com.iosoft.secag.server.SecAgDedicatedInfo;
import com.iosoft.secag.server.SecAgPlayer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;

public class GameServer
extends GameServerApp<SecretAgents, SecAgData, SecAgPlayer, Client> {
    public GameServer(SecretAgents game) {
        super(game);
        this.setTicksPerSecond(5.0);
        this.bufferBetweenTicks = false;
    }

    @Override
    protected void fillClientDisconnectByReasonMapping(Map<String, Integer> mapping) {
        super.fillClientDisconnectByReasonMapping(mapping);
        mapping.put("AfterSecPap", 101);
    }

    @Override
    protected void writeServerUpdate(DataOutputStream dos, int nr) throws IOException {
        switch (nr) {
            case 7: {
                dos.writeShort(((SecAgData)this.data).pointsForGameover);
                dos.writeShort(((SecAgData)this.data).pointsForSecretPaper);
                break;
            }
            default: {
                super.writeServerUpdate(dos, nr);
            }
        }
    }

    @Override
    protected void writeStartUpdates(DataOutputStream dos, Client c) throws IOException {
        super.writeStartUpdates(dos, c);
        this.writeServerUpdate(dos, 7);
    }

    @Override
    protected int buildServerFlags() {
        int flags = super.buildServerFlags();
        flags = Misc.setFlag(flags, 64, ((SecAgData)this.data).useSecretPaper);
        return flags;
    }

    @Override
    protected BaseServerInfo createServerBrowserInfo() {
        SecAgServerInfo info = new SecAgServerInfo();
        info.PointLimit = ((SecAgData)this.data).pointsForGameover;
        info.SecretPaper = ((SecAgData)this.data).useSecretPaper;
        return info;
    }

    @Override
    protected boolean tryCommand(Client client, String cmd) {
        if (cmd.startsWith("limit ")) {
            int num = Misc.getAsInt(cmd.substring("limit ".length()));
            if (num != -1) {
                ((SecAgData)this.data).setLimit(num, -1.0f);
            }
            return true;
        }
        if (cmd.startsWith("secpap_quota ")) {
            float num = Misc.getAsFloat(cmd.substring("secpap_quota ".length()));
            if (num != -1.0f) {
                ((SecAgData)this.data).setLimit(-1, num);
            }
            return true;
        }
        if (cmd.startsWith("secpap ")) {
            ((SecAgData)this.data).setUseSecretPaper(cmd.substring("secpap ".length()).equals("1"));
            return true;
        }
        return super.tryCommand(client, cmd);
    }

    @Override
    protected void processChat(SecAgPlayer player, String msg) {
        if (((SecretAgents)this.Game).isDevmode() && "/instawin".equals(msg) && (player == null || player.isAdmin())) {
            ((SecAgData)this.data).doInstawin();
            this.broadcast("Instawin activated");
            return;
        }
        super.processChat(player, msg);
    }

    @Override
    protected SecAgDedicatedInfo createDedicatedServerInfo() {
        SecAgDedicatedInfo info = new SecAgDedicatedInfo();
        info.maxScore = ((SecAgData)this.data).isGameInProgress() ? 0 : ((SecAgData)this.data).getHighestScore();
        info.useSecretPaper = ((SecAgData)this.data).useSecretPaper;
        info.secretPaperLimit = ((SecAgData)this.data).pointsForSecretPaper;
        info.limit = ((SecAgData)this.data).pointsForGameover;
        return info;
    }

    @Override
    protected SecAgData createAppData() {
        return new SecAgData();
    }

    @Override
    protected Client createClient() {
        return new Client(this);
    }

    @Override
    public TextWithArguments canNotConnectBecause(Socket socket) {
        if (this.isUIDedi()) {
            this.addDediChat(socket.getInetAddress() + " is connecting...");
        }
        if (!((SecAgData)this.data).isJoinable()) {
            return new TextWithArguments("AfterSecPap", new Object[0]);
        }
        return super.canNotConnectBecause(socket);
    }

    @Override
    protected byte[] tryGetNoConnectReasonMsg(TextWithArguments disconnect) {
        if (this.isUIDedi()) {
            this.addDediChat("...but gets disconnected (" + disconnect + ")");
        }
        return super.tryGetNoConnectReasonMsg(disconnect);
    }
}

