/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.secag.server;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.localizer.TextWithArguments;
import com.iosoft.ioengine.AppProtocolException;
import com.iosoft.ioengine.game.server.GameClient;
import com.iosoft.secag.TurnState;
import com.iosoft.secag.dtos.C_Action;
import com.iosoft.secag.dtos.S_TipAccepted;
import com.iosoft.secag.server.GameServer;
import com.iosoft.secag.server.SecAgData;
import com.iosoft.secag.server.SecAgPlayer;

public class Client
extends GameClient<GameServer, SecAgData, SecAgPlayer> {
    public Client(GameServer server) {
        super(server);
    }

    @Override
    protected void handleDisconnecting(TextWithArguments reason) {
        if (((GameServer)this.Server).isUIDedi()) {
            ((GameServer)this.Server).addDediChat(String.valueOf(this.getName()) + " (" + this.getSlotId() + " | " + this.tryGetIPAddr() + ") has disconnected (" + reason + ")");
        }
        super.handleDisconnecting(reason);
    }

    protected void sendFixWrongNumberOfPlayers() {
        this.sendCommand("wrong_number_of_players");
    }

    @Override
    protected void registerMessages() {
        super.registerMessages();
        this.registerMessage(C_Action::new, this::onAction);
    }

    private void onAction(C_Action evt) throws AppProtocolException {
        SecAgPlayer player = (SecAgPlayer)this.getPlayer(evt.Who);
        if (player == null) {
            return;
        }
        SecAgData data = (SecAgData)this.getData();
        switch (evt.Action) {
            case 0: {
                if (!player.isAdmin() || data.isGameInProgress()) break;
                data.startStarting();
                break;
            }
            case 1: {
                if (data.isStarting()) break;
                player.setReady(evt.Param == 1);
                break;
            }
            case 2: {
                if (!player.isAdmin() || evt.Param == ((SecAgPlayer)this.getPrimaryPlayer()).getNr()) break;
                data.tryKick(evt.Param, false);
                break;
            }
            case 3: {
                if (!player.isAdmin() || evt.Param == ((SecAgPlayer)this.getPrimaryPlayer()).getNr()) break;
                data.tryKick(evt.Param, true);
                break;
            }
            case 4: {
                if (!player.isAdmin()) break;
                data.tryAddAI();
                break;
            }
            case 5: {
                if (!data.isCurrentPlayer(player, TurnState.RollTheDice)) break;
                data.rollTheDice();
                break;
            }
            case 6: {
                if (data.isCurrentPlayer(player, TurnState.Turn)) {
                    data.doTurn(evt.Params);
                    break;
                }
                this.sendFixWrongNumberOfPlayers();
                break;
            }
            case 7: {
                if (data.isCurrentPlayer(player, TurnState.ChooseSafePos)) {
                    data.placeSafe(Misc.clamp(evt.Param, 0, 11));
                    break;
                }
                this.sendFixWrongNumberOfPlayers();
                break;
            }
            case 8: {
                if (!data.isCurrentPlayer(null, TurnState.SubmitSecretPaper)) break;
                if (player.submitSecretPaper(evt.Params)) {
                    S_TipAccepted msg = new S_TipAccepted();
                    msg.Players = evt.Params;
                    this.send(msg);
                    break;
                }
                this.sendFixWrongNumberOfPlayers();
                break;
            }
            case 9: {
                if (!player.inGameOver()) break;
                player.onReplay();
                if (this.isAdmin()) {
                    data.restartGame();
                }
                data.checkSlots();
                break;
            }
            default: {
                throw new AppProtocolException("Unknown action (" + evt.Action + ", " + evt.Param + ", " + (evt.Params == null ? "(null)" : Misc.join(",", evt.Params)) + ")");
            }
        }
    }

    @Override
    protected void onGreetingReceived() {
        super.onGreetingReceived();
        if (((GameServer)this.Server).isUIDedi()) {
            ((GameServer)this.Server).addDediChat(String.valueOf(this.getName()) + " (" + this.getSlotId() + " | " + this.tryGetIPAddr() + ") has joined.");
        }
    }
}

